/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.Validator;
import oracle.install.asm.bean.ASMInputValidationHelper;
import oracle.install.asm.bean.DiskGroupSettings;
import oracle.install.asm.ui.DiskDiscoveryPathDialog;
import oracle.install.asm.util.ASMUtility;
import oracle.install.asm.util.ASMUtilityException;
import oracle.install.asm.util.Disk;
import oracle.install.asm.util.DiskHeaderStatus;
import oracle.install.asm.util.Redundancy;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.validate.CompositeInlineValidator;
import oracle.install.commons.swing.validate.InlineValidationHelper;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusControl;
import oracle.install.commons.util.StatusMessages;
import oracle.install.library.util.PlatformInfo;

public class DiskGroupCreationPane
extends JPanel {
    public static final String PROPERY_DISKGROUPSETTINGS = "DiskGroupCreationPane.diskGroupSettings";
    private MultiLineLabel lblTitle;
    private JTextField txtGroupName;
    private RedundancyRadioButton rdoHighRedundancy;
    private RedundancyRadioButton rdoNormalRedundancy;
    private RedundancyRadioButton rdoExternalRedundancy;
    private JTable tblDisks;
    private JButton btnStampDisk;
    private JButton btnDiscoveryPath;
    private JRadioButton rdoCandidateDisks;
    private JRadioButton rdoAllDisks;
    private TitledBorder borderAddDisks;
    private JLabel lblGroupName;
    private JLabel lblRedundancy;
    private ButtonGroup redundancyGroup;
    private DiskTableModel diskTableModel;
    private DiskGroupSettings diskGroupSettings = new DiskGroupSettings();
    private static final String DEFAULT_GROUP_NAME = "DATA";

    public DiskGroupCreationPane() {
        this.diskGroupSettings.setGroupName(DEFAULT_GROUP_NAME);
        this.diskGroupSettings.setRedundancy(Redundancy.NORMAL);
        this.buildUI();
    }

    public void setDiskGroupSettings(DiskGroupSettings diskGroupSettings) {
        if (this.diskGroupSettings != diskGroupSettings) {
            DiskGroupSettings oldValue = this.diskGroupSettings;
            this.diskGroupSettings = diskGroupSettings;
            this.firePropertyChange(PROPERY_DISKGROUPSETTINGS, oldValue, diskGroupSettings);
        }
    }

    public DiskGroupSettings getDiskGroupSettings() {
        this.diskGroupSettings.setGroupName(this.txtGroupName.getText());
        this.diskGroupSettings.setRedundancy(this.getSelectedRedundancy());
        return this.diskGroupSettings;
    }

    private Redundancy getSelectedRedundancy() {
        Redundancy redundancy = null;
        Enumeration<AbstractButton> e = this.redundancyGroup.getElements();
        while (e.hasMoreElements()) {
            RedundancyRadioButton button = (RedundancyRadioButton)e.nextElement();
            if (!button.isSelected()) continue;
            redundancy = button.getRedundancy();
            break;
        }
        return redundancy;
    }

    protected void buildUI() {
        this.diskTableModel = new DiskTableModel();
        this.lblTitle = new MultiLineLabel(WordWrapper.getTextWrapper(), "");
        this.txtGroupName = new JTextField();
        this.txtGroupName.setName("DiskGroupCreationPane.txtGroupName");
        this.rdoHighRedundancy = new RedundancyRadioButton(Redundancy.HIGH);
        this.rdoHighRedundancy.setName("DiskGroupCreationPane.rdoHighRedundancy");
        this.rdoNormalRedundancy = new RedundancyRadioButton(Redundancy.NORMAL);
        this.rdoNormalRedundancy.setName("DiskGroupCreationPane.rdoNormalRedundancy");
        this.rdoExternalRedundancy = new RedundancyRadioButton(Redundancy.EXTERNAL);
        this.rdoExternalRedundancy.setName("DiskGroupCreationPane.rdoExternalRedundancy");
        this.txtGroupName.setText(this.diskGroupSettings.getGroupName());
        this.diskTableModel.setDiskGroupSettings(this.diskGroupSettings);
        this.redundancyGroup = new ButtonGroup();
        this.redundancyGroup.add(this.rdoHighRedundancy);
        this.redundancyGroup.add(this.rdoNormalRedundancy);
        this.redundancyGroup.add(this.rdoExternalRedundancy);
        this.lblRedundancy = new JLabel();
        this.tblDisks = new JTable();
        this.tblDisks.setName("DiskGroupCreationPane.tblDisks");
        JScrollPane scrollPane = new JScrollPane(this.tblDisks);
        scrollPane.getViewport().setBackground(this.tblDisks.getBackground());
        this.rdoCandidateDisks = new JRadioButton();
        this.rdoCandidateDisks.setName("DiskGroupCreationPane.rdoCandidateDisks");
        this.rdoAllDisks = new JRadioButton();
        this.rdoAllDisks.setName("DiskGroupCreationPane.rdoAllDisks");
        this.btnDiscoveryPath = new JButton();
        this.btnDiscoveryPath.setName("DiskGroupCreationPane.btnDiscoveryPath");
        this.btnStampDisk = new JButton();
        this.btnStampDisk.setName("DiskGroupCreationPane.btnStampDisk");
        ButtonGroup group = new ButtonGroup();
        group.add(this.rdoCandidateDisks);
        group.add(this.rdoAllDisks);
        this.rdoCandidateDisks.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiskGroupCreationPane.this.diskTableModel.filterBy(DiskHeaderStatus.CANDIDATE);
            }
        });
        this.rdoAllDisks.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DiskGroupCreationPane.this.diskTableModel.filterBy(null);
            }
        });
        this.btnDiscoveryPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DiskGroupCreationPane.this.changeDiskDiscoveryPath();
                    }
                });
            }
        });
        this.lblGroupName = new JLabel();
        this.lblGroupName.setLabelFor(this.txtGroupName);
        JPanel pnlRedundancy = new JPanel(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.rdoHighRedundancy, (Container)pnlRedundancy, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)new Insets(LayoutUtils.STANDARD_INSETS.top, 0, LayoutUtils.STANDARD_INSETS.bottom, LayoutUtils.STANDARD_INSETS.right));
        LayoutUtils.addComponent((Component)this.rdoNormalRedundancy, (Container)pnlRedundancy, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.rdoExternalRedundancy, (Container)pnlRedundancy, (int)2, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        JPanel pnlAddDisks = new JPanel(new GridBagLayout());
        this.borderAddDisks = BorderFactory.createTitledBorder("Add Disks");
        pnlAddDisks.setBorder(this.borderAddDisks);
        LayoutUtils.addComponent((Component)this.rdoCandidateDisks, (Container)pnlAddDisks, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.rdoAllDisks, (Container)pnlAddDisks, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)pnlAddDisks, (int)2, (int)0, (int)2, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)scrollPane, (Container)pnlAddDisks, (int)0, (int)1, (int)4, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)pnlAddDisks, (int)0, (int)2, (int)2, (int)1, (int)2, (int)13, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.btnStampDisk, (Container)pnlAddDisks, (int)2, (int)2, (int)1, (int)1, (int)0, (int)13, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.btnDiscoveryPath, (Container)pnlAddDisks, (int)3, (int)2, (int)1, (int)1, (int)0, (int)13, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblTitle, (Container)this, (int)0, (int)0, (int)3, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.lblGroupName, (Container)this, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.txtGroupName, (Container)this, (int)1, (int)1, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.lblRedundancy, (Container)this, (int)0, (int)2, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)pnlRedundancy, (Container)this, (int)1, (int)2, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)2, (int)2, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)pnlAddDisks, (Container)this, (int)0, (int)3, (int)3, (int)1, (int)1, (int)10, (double)1.0, (double)1.0, (Insets)LayoutUtils.STANDARD_INSETS);
        this.localize();
        ActiveHelpManager.registerComponent((JComponent)this.txtGroupName, (String)"DiskGroupCreationPane.txtGroupName");
        ActiveHelpManager.registerComponent((JComponent)this.rdoHighRedundancy, (String)"DiskGroupCreationPane.rdoHighRedundancy");
        ActiveHelpManager.registerComponent((JComponent)this.rdoNormalRedundancy, (String)"DiskGroupCreationPane.rdoNormalRedundancy");
        ActiveHelpManager.registerComponent((JComponent)this.rdoExternalRedundancy, (String)"DiskGroupCreationPane.rdoExternalRedundancy");
        ActiveHelpManager.registerComponent((JComponent)this.rdoCandidateDisks, (String)"DiskGroupCreationPane.rdoCandidateDisks");
        ActiveHelpManager.registerComponent((JComponent)this.rdoAllDisks, (String)"DiskGroupCreationPane.rdoAllDisks");
        ActiveHelpManager.registerComponent((JComponent)this.btnStampDisk, (String)"DiskGroupCreationPane.btnStampDisk");
        ActiveHelpManager.registerComponent((JComponent)this.btnDiscoveryPath, (String)"DiskGroupCreationPane.btnDiscoveryPath");
        this.rdoNormalRedundancy.setSelected(true);
        this.rdoCandidateDisks.setSelected(true);
        this.tblDisks.setModel(this.diskTableModel);
        this.tblDisks.setDefaultRenderer(DiskHeaderStatus.class, new DiskHeaderStatusCellRenderer());
        this.tblDisks.getTableHeader().setReorderingAllowed(false);
        SwingUtils.setRowWiseFocusTraveralEnabled((JTable)this.tblDisks, (boolean)true);
        TableColumnModel columnModel = this.tblDisks.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setPreferredWidth(30);
        column = columnModel.getColumn(1);
        column.setPreferredWidth(700);
        column = columnModel.getColumn(2);
        column.setPreferredWidth(110);
        column = columnModel.getColumn(3);
        column.setPreferredWidth(110);
        SwingUtils.setCheckedTableColumn((JTable)this.tblDisks, (int)0, (ItemListener[])new ItemListener[0]);
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        if (platformInfo.isWindows()) {
            this.btnStampDisk.setVisible(true);
            this.btnStampDisk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                ASMUtility asmUtility = ASMUtility.getInstance();
                                Disk[] selectedDisks = DiskGroupCreationPane.this.diskTableModel.getSelectedDisks();
                                asmUtility.stampDisk(selectedDisks);
                                DiskGroupCreationPane.this.findDisks(new String[0]);
                            }
                            catch (ASMUtilityException e) {
                                StandardDialog.showError((Component)DiskGroupCreationPane.this, (Throwable)((Object)e));
                            }
                        }
                    });
                }
            });
        } else {
            this.btnStampDisk.setVisible(false);
        }
        InlineValidationHelper.registerInlineValidator((Component)this, (Component)this.txtGroupName, (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object value) {
                return ASMInputValidationHelper.validateGroupName((String)value, null);
            }
        }, (Object)ValidationComponent.FOCUS_CHANGE_VALIDATOR);
        this.addPropertyChangeListener(PROPERY_DISKGROUPSETTINGS, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DiskGroupSettings diskGroupSettings = (DiskGroupSettings)evt.getNewValue();
                String groupName = diskGroupSettings.getGroupName();
                if (groupName == null || groupName.trim().length() == 0) {
                    groupName = DiskGroupCreationPane.DEFAULT_GROUP_NAME;
                }
                DiskGroupCreationPane.this.txtGroupName.setText(groupName);
                DiskGroupCreationPane.this.diskTableModel.setDiskGroupSettings(diskGroupSettings);
                String discoveryString = diskGroupSettings.getDiskDiscoveryString();
                String[] diskDiscoveryPath = null;
                if (discoveryString != null) {
                    diskDiscoveryPath = discoveryString.split(",");
                }
                DiskGroupCreationPane.this.findDisks(diskDiscoveryPath);
                if (diskGroupSettings.getRedundancy() != null) {
                    Redundancy redundancy = diskGroupSettings.getRedundancy();
                    switch (redundancy) {
                        case EXTERNAL: {
                            DiskGroupCreationPane.this.rdoExternalRedundancy.setSelected(true);
                            break;
                        }
                        case HIGH: {
                            DiskGroupCreationPane.this.rdoHighRedundancy.setSelected(true);
                            break;
                        }
                        case NORMAL: {
                            DiskGroupCreationPane.this.rdoNormalRedundancy.setSelected(true);
                        }
                    }
                }
            }
        });
    }

    private void localize() {
        Application application = Application.getInstance();
        Resource resource = application.getResource("oracle.install.asm.resource.StringResourceBundle");
        String text = resource.getString("DiskGroupCreationPane.lblGroupName.text", "&Disk Group Name*", new Object[0]);
        SwingUtils.setText((JLabel)this.lblGroupName, (String)text);
        this.lblRedundancy.setText(resource.getString("DiskGroupCreationPane.lblRedundancy.text", "Redundancy*", new Object[0]));
        text = resource.getString("DiskGroupCreationPane.pnlAddDisks.candidateDisks", "&Candidate Disks*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoCandidateDisks, (String)text);
        text = resource.getString("DiskGroupCreationPane.pnlAddDisks.allDisks", "&All Disks*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoAllDisks, (String)text);
        this.borderAddDisks.setTitle(resource.getString("DiskGroupCreationPane.pnlAddDisks.border.text", "Add Disks", new Object[0]));
        this.diskTableModel.setColumnNames(new String[]{" ", resource.getString("DiskGroupCreationPane.tblDisks.column.diskPath", "Disk Path", new Object[0]), resource.getString("DiskGroupCreationPane.tblDisks.column.size", "Size (in MB)", new Object[0]), resource.getString("DiskGroupCreationPane.tblDisks.column.status", "Status", new Object[0])});
        this.lblTitle.setText(resource.getString("DiskGroupCreationPane.lblTitle.text", "Select Disk Group Characteristics and select disks", new Object[0]));
        text = resource.getString("DiskGroupCreationPane.btnDiscoveryPath", "Change Discovery &Path*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnDiscoveryPath, (String)text);
        text = resource.getString("DiskGroupCreationPane.btnStampDisk", "&Stamp Disk*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnStampDisk, (String)text);
    }

    private void changeDiskDiscoveryPath() {
        Frame frame = (Frame)SwingUtilities.windowForComponent(this);
        DiskDiscoveryPathDialog dialog = new DiskDiscoveryPathDialog(frame, this.diskGroupSettings.getDiskDiscoveryString());
        dialog.setVisible(true);
        String[] discoveryPath = dialog.getDiskDiscoveryPath();
        if (discoveryPath != null) {
            this.findDisks(discoveryPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findDisks(String ... discoveryPath) {
        String discoveryString = null;
        if (discoveryPath != null) {
            StringBuffer buffer = new StringBuffer();
            for (String entry : discoveryPath) {
                if (entry == null) continue;
                buffer.append(',').append(entry);
            }
            if (buffer.length() > 0) {
                buffer.deleteCharAt(0);
                discoveryString = buffer.toString();
            }
        }
        this.diskGroupSettings.setDiskDiscoveryString(discoveryString);
        Application application = Application.getInstance();
        StatusControl statusControl = application.getStatusControl();
        statusControl.open();
        try {
            ASMUtility utility = ASMUtility.getInstance();
            List<Disk> disks = utility.findDisks(discoveryPath);
            this.diskTableModel.setDisks(disks);
            if (this.rdoCandidateDisks.isSelected()) {
                this.diskTableModel.filterBy(DiskHeaderStatus.CANDIDATE);
            } else {
                this.diskTableModel.filterBy(null);
            }
        }
        catch (ASMUtilityException e) {
            e.printStackTrace();
            StandardDialog.showError((Component)this, (Throwable)((Object)e));
        }
        finally {
            statusControl.close();
        }
    }

    class RedundancyRadioButton
    extends JRadioButton
    implements ItemListener {
        private Redundancy redundancy;

        public RedundancyRadioButton(Redundancy redundancy) {
            this.redundancy = redundancy;
            Resource resource = Application.getInstance().getResource("oracle.install.asm.resource.StringResourceBundle");
            String key = "";
            key = redundancy == Redundancy.HIGH ? "DiskGroupCreationPane.rdoRedudancyHigh.text" : (redundancy == Redundancy.NORMAL ? "DiskGroupCreationPane.rdoRedudancyNormal.text" : "DiskGroupCreationPane.rdoRedudancyExternal.text");
            String text = resource.getString(key, redundancy.name() + "*", new Object[0]);
            SwingUtils.setText((AbstractButton)this, (String)text);
            this.addItemListener(this);
        }

        public Redundancy getRedundancy() {
            return this.redundancy;
        }

        public void itemStateChanged(ItemEvent e) {
            if (DiskGroupCreationPane.this.diskGroupSettings != null) {
                DiskGroupCreationPane.this.diskGroupSettings.setRedundancy(this.redundancy);
            }
        }
    }

    class DiskHeaderStatusCellRenderer
    extends DefaultTableCellRenderer {
        private HashMap<DiskHeaderStatus, String> textMap = new HashMap();

        public DiskHeaderStatusCellRenderer() {
            Resource resource = Application.getInstance().getResource("oracle.install.asm.resource.StringResourceBundle");
            this.textMap.put(DiskHeaderStatus.CANDIDATE, resource.getString(DiskHeaderStatus.CANDIDATE.name(), "Candidate", new Object[0]));
            this.textMap.put(DiskHeaderStatus.FOREIGN, resource.getString(DiskHeaderStatus.FOREIGN.name(), "Foreign", new Object[0]));
            this.textMap.put(DiskHeaderStatus.MEMBER, resource.getString(DiskHeaderStatus.MEMBER.name(), "Member", new Object[0]));
            this.textMap.put(DiskHeaderStatus.FORMER, resource.getString(DiskHeaderStatus.FORMER.name(), "Former", new Object[0]));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof DiskHeaderStatus) {
                this.setText(this.textMap.get((Object)((DiskHeaderStatus)((Object)value))));
            }
            return renderer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiskTableModel
    extends AbstractTableModel {
        private DiskGroupSettings diskGroupSettings;
        private List<Disk> disks = new ArrayList<Disk>();
        private String[] columnNames;
        private static final Class[] columnClass = new Class[]{Boolean.class, String.class, Long.class, DiskHeaderStatus.class};
        private List<Disk> filteredList = new ArrayList<Disk>();

        public void filterBy(DiskHeaderStatus diskHeaderStatus) {
            this.filteredList.clear();
            for (Disk disk : this.disks) {
                if (diskHeaderStatus != null && disk.getHeaderStatus() != diskHeaderStatus) continue;
                this.filteredList.add(disk);
            }
            this.fireTableDataChanged();
        }

        public List<Disk> getDisks() {
            return this.disks;
        }

        public void setDisks(List<Disk> disks) {
            List<String> paths;
            if (disks != null) {
                this.disks = disks;
            } else {
                this.disks.clear();
            }
            if (this.diskGroupSettings != null && (paths = this.diskGroupSettings.getDiskPaths()) != null) {
                paths.clear();
            }
            this.fireTableDataChanged();
        }

        public DiskGroupSettings getDiskGroupSettings() {
            return this.diskGroupSettings;
        }

        public void setDiskGroupSettings(DiskGroupSettings diskGroupSettings) {
            this.diskGroupSettings = diskGroupSettings;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnClass[columnIndex];
        }

        public Disk[] getSelectedDisks() {
            ArrayList<Disk> selectedDisks = new ArrayList<Disk>();
            if (this.diskGroupSettings != null && this.diskGroupSettings.getDiskPaths() != null && this.disks != null) {
                for (Disk disk : this.disks) {
                    if (!this.diskGroupSettings.getDiskPaths().contains(disk.getPath())) continue;
                    selectedDisks.add(disk);
                }
            }
            return selectedDisks.toArray(new Disk[0]);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Disk disk = this.filteredList.get(rowIndex);
            List<String> paths = this.diskGroupSettings.getDiskPaths();
            if (paths == null) {
                paths = new ArrayList<String>();
                this.diskGroupSettings.setDiskPaths(paths);
            }
            if (aValue == Boolean.TRUE && disk.getHeaderStatus() == DiskHeaderStatus.CANDIDATE) {
                if (!paths.contains(disk.getPath())) {
                    paths.add(disk.getPath());
                }
            } else {
                paths.remove(disk.getPath());
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            Disk disk = this.filteredList.get(rowIndex);
            return columnIndex == 0 && disk.getHeaderStatus() == DiskHeaderStatus.CANDIDATE;
        }

        public void setColumnNames(String[] columnNames) {
            this.columnNames = columnNames;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.filteredList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value = null;
            Disk disk = this.filteredList.get(rowIndex);
            if (disk != null) {
                switch (columnIndex) {
                    case 0: {
                        if (disk.getHeaderStatus() != DiskHeaderStatus.CANDIDATE) break;
                        List<String> diskPaths = this.diskGroupSettings.getDiskPaths();
                        if (diskPaths != null) {
                            value = diskPaths.contains(disk.getPath());
                            break;
                        }
                        value = false;
                        break;
                    }
                    case 1: {
                        value = disk.getPath();
                        break;
                    }
                    case 2: {
                        value = disk.getSize();
                        break;
                    }
                    case 3: {
                        value = disk.getHeaderStatus();
                    }
                }
            }
            return value;
        }
    }
}

