/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.util.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.asm.util.ASMInstance;
import oracle.install.asm.util.ASMUtility;
import oracle.install.asm.util.ASMUtilityErrorCode;
import oracle.install.asm.util.ASMUtilityException;
import oracle.install.asm.util.Disk;
import oracle.install.asm.util.DiskGroup;
import oracle.install.asm.util.impl.SRVCTLOpOutputParser;
import oracle.install.asm.util.kfod.KFOD;
import oracle.install.commons.base.util.OracleService;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.Version;
import oracle.install.library.crs.CRSInfo;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.ProductInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultASMUtility
extends ASMUtility {
    private static final Logger logger = Logger.getLogger(DefaultASMUtility.class.getName());
    public static final String ASMTOOL_HOME = "oracle.install.asm.util.asmtoolg.ASMTOOL_HOME";
    private ProcessBuilder srvctl;
    private ProcessBuilder asmtoolg;
    private OutputProcessor stderrProcessor;
    private KFOD kfod = new KFOD();

    public DefaultASMUtility() {
        this.stderrProcessor = new AbstractLineProcessor(){

            public void processLine(String line, int lineNumber) {
                logger.warning(line);
            }
        };
    }

    @Override
    public void init() throws ASMUtilityException {
        try {
            String home = CRSInfo.getInstance().getCRSHome();
            if (home != null && !home.equals("")) {
                Version version = InventoryInfo.getInstance().getProductVersion(home);
                if (version != null && version.compareTo(Version.parseVersion((String)"10.2.0.0.0")) < 0) {
                    this.kfod.init();
                    ASMInstance instance = this.getASMInstance();
                    if (instance != null && instance.getOracleHome() != null) {
                        home = instance.getOracleHome().getAbsolutePath();
                    } else {
                        return;
                    }
                }
                File srvctlHome = new File(home, "bin/");
                if (Boolean.getBoolean("oracle.install.asm.util.KFOD_FROM_ORACLE_HOME")) {
                    System.setProperty("oracle.install.asm.util.kfod.KFOD_HOME", srvctlHome.getPath());
                }
                this.srvctl = this.findSRVCTL(srvctlHome);
            } else {
                logger.log(Level.WARNING, "SRVCTL not found as there is no Grid Infrastructure home on the box");
            }
        }
        catch (ASMUtilityException e) {
            logger.log(Level.WARNING, "Failed to find SRVCTL ", (Throwable)((Object)e));
        }
        this.kfod.init();
    }

    private ProcessBuilder findSRVCTL(File path) throws ASMUtilityException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        File srvctl = null;
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        boolean windows = platformInfo.isWindows();
        srvctl = !windows ? new File(path, "srvctl") : new File(path, "srvctl.bat");
        if (srvctl == null || !srvctl.exists()) {
            logger.severe("SRVCTL not found at " + path);
            throw new ASMUtilityException(ASMUtilityErrorCode.DRIVER_NOT_FOUND, new Object[0]);
        }
        if (!windows) {
            processBuilder.command(srvctl.getPath());
            processBuilder.environment().remove("LC_ALL");
            processBuilder.environment().remove("LANG");
        } else {
            processBuilder.command("\"" + srvctl.getPath() + "\"");
        }
        processBuilder.directory(path);
        processBuilder.environment().put("ORACLE_HOME", path.getParent());
        return processBuilder;
    }

    @Override
    public List<Disk> findDisks(String ... discoveryString) throws ASMUtilityException {
        return this.kfod.findDisks(discoveryString);
    }

    @Override
    public List<String> findDiskgroupsFromHeader(String discoveryString) throws ASMUtilityException {
        return this.kfod.findDiskgroupsFromHeader(discoveryString);
    }

    @Override
    public ASMInstance getASMInstance() throws ASMUtilityException {
        return this.kfod.getASMInstance();
    }

    @Override
    public List<ASMInstance> getASMInstances(String ... nodes) throws ASMUtilityException {
        return this.kfod.getASMInstances(nodes);
    }

    @Override
    public List<OracleService> getClientServices(ASMInstance asmInstance) throws ASMUtilityException {
        return this.kfod.getClientServices(asmInstance);
    }

    @Override
    public List<DiskGroup> getDiskGroups(ASMInstance asmInstance) throws ASMUtilityException {
        return this.kfod.getDiskGroups(asmInstance);
    }

    @Override
    public List<Disk> getDisks(ASMInstance asmInstance, DiskGroup diskGroup) throws ASMUtilityException {
        return this.kfod.getDisks(asmInstance, diskGroup);
    }

    @Override
    public boolean isAccessible(ASMInstance asmInstance) throws ASMUtilityException {
        return this.kfod.isAccessible(asmInstance);
    }

    @Override
    public boolean isAlive(ASMInstance asmInstance) throws ASMUtilityException {
        return this.kfod.isAlive(asmInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> detectASM(boolean isUpgrade, String ... nodes) throws ASMUtilityException {
        ArrayList<String> list = new ArrayList<String>();
        if (nodes != null) {
            if (PlatformInfo.getInstance().isWindows() && !isUpgrade) {
                ArrayList<String> command = new ArrayList<String>();
                command.add("status");
                command.add("asm");
                command.add("-S");
                command.add("1");
                if (this.srvctl == null) {
                    throw new ASMUtilityException(ASMUtilityErrorCode.DRIVER_NOT_FOUND, new Object[0]);
                }
                try {
                    this.srvctl.command().addAll(command);
                    SRVCTLOpOutputParser outputParser = new SRVCTLOpOutputParser();
                    outputParser.setUpgrade(isUpgrade);
                    this.execute(this.srvctl, outputParser);
                    list.addAll(outputParser.getNodeList());
                }
                finally {
                    this.srvctl.command().removeAll(command);
                }
            } else if (this.srvctl != null) {
                for (String node : nodes) {
                    boolean asmPrsent = this.detectASM(isUpgrade, node);
                    if (!asmPrsent) continue;
                    list.add(node);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detectASM(boolean isUpgrade, String node) throws ASMUtilityException {
        boolean asmPresent = false;
        ArrayList<String> command = new ArrayList<String>();
        String OLD_SRVM_PROPERTY_DEFS = null;
        Map<String, String> srvctlEnv = this.srvctl.environment();
        command.add("status");
        command.add("asm");
        command.add("-n");
        command.add(node);
        if (this.srvctl == null) {
            throw new ASMUtilityException(ASMUtilityErrorCode.DRIVER_NOT_FOUND, new Object[0]);
        }
        try {
            this.srvctl.command().addAll(command);
            SRVCTLOpOutputParser outputParser = new SRVCTLOpOutputParser();
            outputParser.setUpgrade(isUpgrade);
            if (srvctlEnv.containsKey("SRVM_PROPERTY_DEFS")) {
                OLD_SRVM_PROPERTY_DEFS = srvctlEnv.get("SRVM_PROPERTY_DEFS");
            }
            srvctlEnv.put("SRVM_PROPERTY_DEFS", "-Duser.language=en");
            this.execute(this.srvctl, outputParser);
            asmPresent = outputParser.isAsmPresent();
            srvctlEnv.remove("SRVM_PROPERTY_DEFS");
        }
        catch (Throwable throwable) {
            srvctlEnv.remove("SRVM_PROPERTY_DEFS");
            if (OLD_SRVM_PROPERTY_DEFS != null) {
                srvctlEnv.put("SRVM_PROPERTY_DEFS", OLD_SRVM_PROPERTY_DEFS);
            }
            this.srvctl.command().removeAll(command);
            throw throwable;
        }
        if (OLD_SRVM_PROPERTY_DEFS != null) {
            srvctlEnv.put("SRVM_PROPERTY_DEFS", OLD_SRVM_PROPERTY_DEFS);
        }
        this.srvctl.command().removeAll(command);
        return asmPresent;
    }

    private void execute(ProcessBuilder processBuilder, SRVCTLOpOutputParser outputParser) throws ASMUtilityException {
        this.execute(processBuilder, outputParser, this.stderrProcessor);
    }

    private void execute(ProcessBuilder processBuilder, SRVCTLOpOutputParser outputParser, OutputProcessor stderrProcessor) throws ASMUtilityException {
        try {
            ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(processBuilder, (OutputProcessor)outputParser, stderrProcessor);
            ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
            ASMUtilityErrorCode errorCode = outputParser.getErrorCode();
            if (errorCode != null) {
                throw new ASMUtilityException(errorCode, new Object[0]);
            }
        }
        catch (ASMUtilityException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ASMUtilityException(e);
        }
    }

    private ProcessBuilder findASMToolg(File path) throws ASMUtilityException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        File asmtool = null;
        asmtool = new File(path, "asmtoolg.exe");
        if (asmtool == null || !asmtool.exists()) {
            logger.severe("asmtoolg not found at " + path);
            throw new ASMUtilityException(ASMUtilityErrorCode.DRIVER_NOT_FOUND, new Object[0]);
        }
        processBuilder.command("\"" + asmtool.getPath() + "\"");
        processBuilder.directory(path);
        String asmToolLib = path.getPath() + File.separator + "oui" + File.separator + "lib" + File.separator + "win32";
        String asmToolPath = processBuilder.environment().get("Path");
        asmToolPath = asmToolPath == null ? asmToolLib : asmToolPath + ";" + asmToolLib;
        processBuilder.environment().put("Path", asmToolPath);
        return processBuilder;
    }

    @Override
    public void stampDisk(Disk ... disks) throws ASMUtilityException {
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        boolean windows = platformInfo.isWindows();
        if (windows) {
            File asmtoolgFile = new File(System.getProperty(ASMTOOL_HOME));
            this.asmtoolg = this.findASMToolg(asmtoolgFile);
            if (this.asmtoolg != null) {
                try {
                    ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(this.asmtoolg);
                    ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ASMUtilityException(e);
                }
            }
        }
    }

    @Override
    public ASMInstance getDetails(ASMInstance asmInstance) throws ASMUtilityException {
        try {
            this.kfod.getDetails(asmInstance);
            Version version = asmInstance.getVersion();
            if (version.compareTo(Version.parseVersion((String)"0.0.0.0.0")) == 0) {
                try {
                    String strVersion = ProductInfo.getInstance().getProductVersion(asmInstance.getOracleHome().toString(), "oracle.rdbms");
                    asmInstance.setVersion(Version.parseVersion((String)strVersion));
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "while getting oracle.rdbms component version " + asmInstance.getOracleHome().toString() + "exception is " + ex);
                }
            }
        }
        catch (ASMUtilityException e) {
            String strVersion = null;
            if (e.getErrorCode() != ASMUtilityErrorCode.CORRUPT_ASM_HOME) {
                try {
                    strVersion = ProductInfo.getInstance().getProductVersion(asmInstance.getOracleHome().toString(), "oracle.rdbms");
                    asmInstance.setVersion(Version.parseVersion((String)strVersion));
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "while getting oracle.rdbms component version " + asmInstance.getOracleHome().toString() + "exception is " + ex);
                }
            }
            throw e;
        }
        return asmInstance;
    }
}

