/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.util.kfod;

import java.util.ArrayList;
import java.util.List;
import oracle.install.asm.util.Disk;
import oracle.install.asm.util.DiskHeaderStatus;
import oracle.install.asm.util.kfod.Helper;
import oracle.install.asm.util.kfod.KFODOpOutputParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GroupDetailsOpOutputParser
extends KFODOpOutputParser {
    List<Disk> disks = new ArrayList<Disk>();

    @Override
    public void parseLine(String line) {
        Disk disk = this.parseDisk(line);
        if (disk != null) {
            this.disks.add(disk);
        }
    }

    public List<Disk> getDisks() {
        return this.disks;
    }

    private Disk parseDisk(String line) {
        Disk disk = null;
        String[] tokens = Helper.tokenize(line);
        if (tokens.length == 2 || tokens.length == 4) {
            try {
                long size = Long.parseLong(tokens[0]);
                String path = tokens[1];
                disk = new Disk(path, size, DiskHeaderStatus.MEMBER);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return disk;
    }
}

