/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.asm.util.kfod;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.install.asm.util.ASMInstance;
import oracle.install.asm.util.ASMUtility;
import oracle.install.asm.util.ASMUtilityErrorCode;
import oracle.install.asm.util.ASMUtilityException;
import oracle.install.asm.util.Disk;
import oracle.install.asm.util.DiskGroup;
import oracle.install.asm.util.kfod.ClientsOpOutputParser;
import oracle.install.asm.util.kfod.DiskOpOutputParser;
import oracle.install.asm.util.kfod.GroupDetailsOpOutputParser;
import oracle.install.asm.util.kfod.GroupOpOutputParser;
import oracle.install.asm.util.kfod.Helper;
import oracle.install.asm.util.kfod.InstsOpOutputParser;
import oracle.install.asm.util.kfod.KFODOpOutputParser;
import oracle.install.asm.util.kfod.VersionOpOutputParser;
import oracle.install.commons.base.util.OracleService;
import oracle.install.commons.base.util.OracleServiceRegistry;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.Version;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.library.util.PlatformInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KFOD
extends ASMUtility {
    public static final String HOME = "oracle.install.asm.util.kfod.KFOD_HOME";
    public static final String KFOD_FROM_ORACLE_HOME = "oracle.install.asm.util.KFOD_FROM_ORACLE_HOME";
    private static final Logger logger = Logger.getLogger(KFOD.class.getName());
    public static final String UNIX_SIDPATTERN = "\\+.+";
    public static final String WIN_SIDPATTERN = ".+\\+.+";
    private ProcessBuilder processBuilder;
    private Pattern pattern;
    private OutputProcessor stderrProcessor = new AbstractLineProcessor(){

        public void processLine(String line, int lineNumber) {
            logger.warning(line);
        }
    };

    private ProcessBuilder findKFOD(File path) throws ASMUtilityException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        File kfod = null;
        PlatformInfo platformInfo = PlatformInfo.getInstance();
        boolean windows = platformInfo.isWindows();
        kfod = !windows ? new File(path, "kfod") : new File(path, "kfod.exe");
        if (kfod == null || !kfod.exists()) {
            String val = System.getProperty(KFOD_FROM_ORACLE_HOME);
            if (!Boolean.getBoolean(KFOD_FROM_ORACLE_HOME)) {
                logger.severe("KFOD not found at " + path);
                throw new ASMUtilityException(ASMUtilityErrorCode.DRIVER_NOT_FOUND, new Object[0]);
            }
            logger.warning("KFOD not found at " + path);
            return null;
        }
        if (!windows) {
            processBuilder.command(kfod.getPath());
            Map<String, String> env = processBuilder.environment();
            File libPath = new File(path, "../lib/");
            env.put("LD_LIBRARY_PATH", libPath.getPath());
        } else {
            processBuilder.command("\"" + kfod.getPath() + "\"");
        }
        List<String> command = processBuilder.command();
        command.add("nohdr=true");
        command.add("verbose=true");
        processBuilder.directory(path);
        return processBuilder;
    }

    @Override
    public void init() throws ASMUtilityException {
        File kfodHome = new File(System.getProperty(HOME, ""));
        this.processBuilder = this.findKFOD(kfodHome);
        this.pattern = Pattern.compile(KFOD.getSIDPattern(), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Disk> findDisks(String ... discoveryString) throws ASMUtilityException {
        List<Disk> disks = null;
        ArrayList<String> command = new ArrayList<String>();
        command.add("disks=all");
        command.add("status=true");
        command.add("op=disks");
        if (discoveryString != null) {
            StringBuffer asm_diskstring = new StringBuffer();
            for (String item : discoveryString) {
                asm_diskstring.append(",").append("'").append(item).append("'");
            }
            if (asm_diskstring.length() > 0) {
                asm_diskstring.deleteCharAt(0);
                command.add("asm_diskstring=" + asm_diskstring.toString());
            }
        }
        if (this.processBuilder != null) {
            try {
                this.processBuilder.command().addAll(command);
                DiskOpOutputParser outputParser = new DiskOpOutputParser();
                this.execute(this.processBuilder, outputParser);
                disks = outputParser.getDisks();
            }
            finally {
                this.processBuilder.command().removeAll(command);
            }
        }
        return disks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> findDiskgroupsFromHeader(String discoveryString) throws ASMUtilityException {
        final ArrayList<String> diskgroups = new ArrayList<String>();
        ArrayList<String> command = new ArrayList<String>();
        command.add("disks=all");
        command.add("op=disks");
        command.add("dscvgroup=TRUE");
        if (discoveryString != null && discoveryString.length() > 0) {
            command.add("asm_diskstring='" + discoveryString + "'");
        }
        if (this.processBuilder != null) {
            try {
                this.processBuilder.command().addAll(command);
                DiskOpOutputParser outputParser = new DiskOpOutputParser(){

                    public void parseLine(String line) {
                        String[] tokens = Helper.tokenize(line);
                        if (tokens.length == 3 || tokens.length == 5) {
                            try {
                                String diskGroupName = tokens[2].replaceAll("#", "").trim();
                                if (diskGroupName.length() > 0) {
                                    diskgroups.add(tokens[2].trim());
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                };
                this.execute(this.processBuilder, outputParser);
            }
            finally {
                this.processBuilder.command().removeAll(command);
            }
        }
        return diskgroups.size() == 0 ? null : diskgroups;
    }

    @Override
    public ASMInstance getASMInstance() throws ASMUtilityException {
        List<ASMInstance> asmList;
        ASMInstance instance = null;
        OracleServiceRegistry serviceRegistry = OracleServiceRegistry.getInstance();
        OracleService asm = serviceRegistry.findServiceById(this.pattern);
        if (asm != null) {
            instance = new ASMInstance(asm.getSid(), asm.getOracleHome());
        }
        if (instance == null && (asmList = this.getASMInstances(new String[0])) != null && asmList.size() > 0) {
            instance = asmList.get(0);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ASMInstance> getASMInstances(String ... nodes) throws ASMUtilityException {
        ArrayList<String> command = new ArrayList<String>();
        command.add("op=insts");
        if (nodes.length > 0) {
            StringBuffer buffer = new StringBuffer();
            for (String node : nodes) {
                buffer.append(',' + node);
            }
            buffer.deleteCharAt(0);
            command.add("hostlist=" + buffer.toString());
        }
        List<ASMInstance> instances = new ArrayList<ASMInstance>();
        if (this.processBuilder != null) {
            try {
                this.processBuilder.command().addAll(command);
                InstsOpOutputParser outputParser = new InstsOpOutputParser();
                this.execute(this.processBuilder, outputParser);
                instances = outputParser.getInstances();
            }
            finally {
                this.processBuilder.command().removeAll(command);
            }
        }
        return instances;
    }

    @Override
    public List<DiskGroup> getDiskGroups(ASMInstance asmInstance) throws ASMUtilityException {
        File oracleHome = asmInstance.getOracleHome();
        String sid = asmInstance.getSid();
        if (oracleHome.exists() && oracleHome.list() != null && oracleHome.list().length > 0) {
            ProcessBuilder processBuilder = this.findKFOD(new File(oracleHome, "bin/"));
            processBuilder.command().add("op=groups");
            processBuilder.command().add("cluster=true");
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("ORACLE_HOME", oracleHome.getPath());
            env.put("ORACLE_SID", sid);
            processBuilder.environment().putAll(env);
            GroupOpOutputParser outputParser = new GroupOpOutputParser();
            this.execute(processBuilder, outputParser);
            return outputParser.getDiskGroups();
        }
        return new ArrayList<DiskGroup>();
    }

    @Override
    public List<Disk> getDisks(ASMInstance asmInstance, DiskGroup diskGroup) throws ASMUtilityException {
        File oracleHome = asmInstance.getOracleHome();
        String sid = asmInstance.getSid();
        ProcessBuilder processBuilder = this.findKFOD(new File(oracleHome, "bin/"));
        processBuilder.command().add("op=groups");
        processBuilder.command().add(String.format("group=%s", diskGroup.getName()));
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("ORACLE_HOME", oracleHome.getPath());
        env.put("ORACLE_SID", sid);
        processBuilder.environment().putAll(env);
        GroupDetailsOpOutputParser outputParser = new GroupDetailsOpOutputParser();
        this.execute(processBuilder, outputParser);
        return outputParser.getDisks();
    }

    @Override
    public boolean isAccessible(ASMInstance asmInstance) throws ASMUtilityException {
        boolean accessible = true;
        try {
            this.getDiskGroups(asmInstance);
        }
        catch (ASMUtilityException e) {
            ErrorCode errorCode = e.getErrorCode();
            if (errorCode == ASMUtilityErrorCode.ASM_ACCESS_DENIED) {
                accessible = false;
            }
            throw e;
        }
        return accessible;
    }

    @Override
    public boolean isAlive(ASMInstance asmInstance) throws ASMUtilityException {
        File oracleHome = asmInstance.getOracleHome();
        String sid = asmInstance.getSid();
        ProcessBuilder processBuilder = this.findKFOD(new File(oracleHome, "bin/"));
        processBuilder.command().add("op=insts");
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("ORACLE_HOME", oracleHome.getPath());
        env.put("ORACLE_SID", sid);
        processBuilder.environment().putAll(env);
        InstsOpOutputParser outputParser = new InstsOpOutputParser();
        this.execute(processBuilder, outputParser);
        List<ASMInstance> instances = outputParser.getInstances();
        return instances != null && instances.contains((Object)asmInstance);
    }

    @Override
    public List<OracleService> getClientServices(ASMInstance asmInstance) throws ASMUtilityException {
        File oracleHome = asmInstance.getOracleHome();
        String sid = asmInstance.getSid();
        ProcessBuilder processBuilder = this.findKFOD(new File(oracleHome, "bin/"));
        processBuilder.command().add("op=clients");
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("ORACLE_HOME", oracleHome.getPath());
        env.put("ORACLE_SID", sid);
        processBuilder.environment().putAll(env);
        ClientsOpOutputParser outputParser = new ClientsOpOutputParser();
        this.execute(processBuilder, outputParser);
        return outputParser.getClients();
    }

    @Override
    public ASMInstance getDetails(ASMInstance instance) throws ASMUtilityException {
        if (instance != null) {
            Version version = this.getVersion(instance);
            instance.setVersion(version);
        }
        return instance;
    }

    private Version getVersion(ASMInstance instance) throws ASMUtilityException {
        Version version = null;
        if (instance != null) {
            File oracleHome = instance.getOracleHome();
            String sid = instance.getSid();
            if (oracleHome.exists()) {
                ProcessBuilder processBuilder = this.findKFOD(new File(oracleHome, "bin/"));
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("ORACLE_HOME", oracleHome.getPath());
                env.put("ORACLE_SID", sid);
                processBuilder.environment().putAll(env);
                processBuilder.command().add("op=version");
                VersionOpOutputParser outputParser = new VersionOpOutputParser(instance);
                this.execute(processBuilder, outputParser);
                instance = outputParser.getInstance();
                if (instance == null) {
                    throw new ASMUtilityException(ASMUtilityErrorCode.ASM_INSTANCE_DOWN, new Object[0]);
                }
                version = instance.getVersion();
            } else {
                throw new ASMUtilityException(ASMUtilityErrorCode.CORRUPT_ASM_HOME, new Object[0]);
            }
        }
        return version;
    }

    private void execute(ProcessBuilder processBuilder, KFODOpOutputParser outputParser) throws ASMUtilityException {
        this.execute(processBuilder, outputParser, this.stderrProcessor);
    }

    private void execute(ProcessBuilder processBuilder, KFODOpOutputParser outputParser, OutputProcessor stderrProcessor) throws ASMUtilityException {
        try {
            ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(processBuilder, (OutputProcessor)outputParser, stderrProcessor);
            ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
            ASMUtilityErrorCode errorCode = outputParser.getErrorCode();
            if (errorCode != null) {
                throw new ASMUtilityException(errorCode, new Object[0]);
            }
        }
        catch (ASMUtilityException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ASMUtilityException(e);
        }
    }

    public static String getSIDPattern() {
        return PlatformInfo.getInstance().isWindows() ? WIN_SIDPATTERN : UNIX_SIDPATTERN;
    }
}

