/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.bean;

import java.util.Locale;
import oracle.install.commons.bean.annotation.PropertyDef;
import oracle.install.ivw.common.bean.CentralInventorySettings;
import oracle.install.ivw.common.bean.OCMSettings;
import oracle.sysman.oii.oiix.OiixLanguage;

public abstract class OracleSetupBean {
    private String oracleHostName;
    private CentralInventorySettings centralInventory;
    private String[] languages;
    private OCMSettings ocmSettings;
    public static final String[] DEFAULT_LANGUAGE_SET = new String[]{"en"};

    public OracleSetupBean() {
        this("", null, null);
    }

    public OracleSetupBean(String oracleHostName, CentralInventorySettings centralInventory, String[] languages) {
        this.OracleSetupBeanConstruct(oracleHostName, centralInventory, languages, true);
    }

    public OracleSetupBean(String oracleHostName, CentralInventorySettings centralInventory, boolean setLocale) {
        this.OracleSetupBeanConstruct(oracleHostName, centralInventory, null, setLocale);
    }

    public OracleSetupBean(boolean setLocale) {
        this("", null, setLocale);
    }

    public void OracleSetupBeanConstruct(String oracleHostName, CentralInventorySettings centralInventory, String[] languages, boolean setLocale) {
        this.oracleHostName = oracleHostName;
        this.centralInventory = centralInventory;
        Locale defLocale = OiixLanguage.getDefaultLocale();
        String defLang = defLocale.toString();
        String[] defaultLangs = setLocale ? (!defLang.equals("en") ? new String[]{"en", defLang} : new String[]{"en"}) : new String[]{"en"};
        this.languages = languages == null ? defaultLangs : languages;
        this.ocmSettings = new OCMSettings();
    }

    @PropertyDef(value="OCMSettings")
    public OCMSettings getOcmSettings() {
        return this.ocmSettings;
    }

    public void setOcmSettings(OCMSettings ocmSettings) {
        this.ocmSettings = ocmSettings;
    }

    @PropertyDef(value="CentralInventorySettings")
    public CentralInventorySettings getCentralInventory() {
        return this.centralInventory;
    }

    public void setCentralInventory(CentralInventorySettings centralInventory) {
        this.centralInventory = centralInventory;
    }

    @PropertyDef(value="SELECTED_LANGUAGES")
    public String[] getLanguages() {
        return this.languages;
    }

    public void setLanguages(String[] languages) {
        this.languages = languages;
    }

    @PropertyDef(value="ORACLE_HOSTNAME")
    public String getOracleHostName() {
        return this.oracleHostName;
    }

    public void setOracleHostName(String oracleHostName) {
        this.oracleHostName = oracleHostName;
    }
}

