/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.install.commons.base.util.InstallComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTableModel
extends AbstractTableModel {
    private String[] columnNames;
    List<InstallComponent> components;
    private PropertyChangeListener propertyChangeListener;

    public ComponentTableModel(List<InstallComponent> comps, String[] columnNames) {
        this.components = comps;
        this.columnNames = columnNames;
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                InstallComponent comp = (InstallComponent)event.getSource();
                int index = ComponentTableModel.this.components.indexOf(comp);
                ComponentTableModel.this.fireTableRowsUpdated(index, index);
            }
        };
        this.registerForComponentPropertyChange();
    }

    public ComponentTableModel(List<InstallComponent> components) {
        this(components, null);
    }

    private void registerForComponentPropertyChange() {
        for (InstallComponent comp : this.components) {
            comp.addPropertyChangeListener(InstallComponent.SELECTION_CHANGED, this.propertyChangeListener);
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.components == null ? 0 : this.components.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object value = null;
        if (row < this.components.size()) {
            InstallComponent comp = this.components.get(row);
            value = this.getValueAt(comp, column);
        }
        return value;
    }

    protected Object getValueAt(InstallComponent comp, int column) {
        Object value = null;
        if (comp != null) {
            switch (column) {
                case 0: {
                    value = comp.isSelectedForInstall();
                    break;
                }
                case 1: {
                    value = comp.getDescription();
                }
            }
        }
        return value;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        InstallComponent comp = this.components.get(row);
        boolean isEnabled = comp.isEnabledForSelection();
        return col == 0 && isEnabled;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (row < this.components.size()) {
            InstallComponent comp = this.components.get(row);
            this.setValueAt(value, comp, col);
        }
        this.fireTableCellUpdated(row, col);
    }

    private void setValueAt(Object value, InstallComponent comp, int column) {
        if (comp != null) {
            switch (column) {
                case 0: {
                    boolean selected = (Boolean)value;
                    comp.setSelectedForInstall(selected);
                }
            }
        }
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public List<InstallComponent> getComponents() {
        return this.components;
    }

    private void clear() {
        for (InstallComponent comp : this.components) {
            comp.removePropertyChangeListener(InstallComponent.SELECTION_CHANGED, this.propertyChangeListener);
        }
    }

    public void setComponents(List<InstallComponent> components) {
        if (this.components != components) {
            this.clear();
            this.components = components;
            this.registerForComponentPropertyChange();
            this.fireTableDataChanged();
        }
    }
}

