/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.install.commons.base.summary.Summary;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class FinishPane
extends JPanel {
    private MultiLineLabel lblMessage;
    private JLabel lblMessage2;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private static final Logger logger = Logger.getLogger(FinishPane.class.getName());
    public static final String S_RESOURCE_BUNDLE = "oracle.sysman.oii.oiir.OiirRuntimeRes";
    public static final String SESSION_SUCCESS = OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_SESSION_SUCCESS");
    public static final String SUCCESS_MINUS_REMOTE = OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"OIIFW1203");
    public static final String SUCCESS_MINUS_CONFIGTOOLS = OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_SESSION_SUCCESS_MINUS_CONFIGTOOLS");
    public static final String SESSION_FAILURE = OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_SESSION_FAILURE");
    public static final String TYPE_INSTALL = OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_INSTALLATION");
    public static final String TYPE_UPGRADE = OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_CTCMP_UPGRADE");
    private Resource resource = Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID");

    public FinishPane() {
        this.buildUI();
    }

    private void buildUI() {
        this.lblMessage = new MultiLineLabel(WordWrapper.getTextWrapper(), "");
        this.lblMessage2 = new JLabel();
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.scrollPane = new JScrollPane(this.textArea);
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblMessage, (Container)this, (int)0, (int)0, (int)2, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent((Component)this.lblMessage2, (Container)this, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)2, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0);
        LayoutUtils.addComponent((Component)this.scrollPane, (Container)this, (int)0, (int)2, (int)2, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (Insets)new Insets(5, 5, 5, 5));
        this.setVisible(true);
    }

    public void setStatusText(String text) {
        this.lblMessage.setText(text);
    }

    public void toggleTextArea() {
        String text = this.textArea.getText();
        if (text == null || text.trim().length() == 0) {
            this.scrollPane.setVisible(false);
            this.lblMessage2.setVisible(false);
        } else {
            this.scrollPane.setVisible(true);
            this.lblMessage2.setVisible(true);
        }
    }

    public String calculateSessionStatus(Summary summary) {
        String status = SESSION_SUCCESS;
        boolean instSuccess = summary.isSuccessfullInstall();
        boolean toolSuccess = summary.isSuccessfulConfig();
        boolean instRemoteSuccess = summary.isSuccessfullRemoteInstall();
        logger.info("Install Succeeded: " + instSuccess);
        logger.info("Config Tool Succeeded: " + toolSuccess);
        logger.info("Remote Install Succeeded: " + instRemoteSuccess);
        if (instSuccess) {
            if (!instRemoteSuccess) {
                status = SUCCESS_MINUS_REMOTE;
            }
            if (!toolSuccess) {
                status = SUCCESS_MINUS_CONFIGTOOLS;
            }
        } else {
            status = SESSION_FAILURE;
        }
        return status;
    }

    public void setInstallMessages(String endMsgs) {
        this.textArea.setEditable(true);
        this.textArea.setText(endMsgs);
        this.lblMessage2.setText(this.resource.getString("EndOfInstallMessage.Note", "Note", new Object[0]));
        this.lblMessage2.setVisible(true);
        this.scrollPane.setVisible(true);
        this.textArea.setEditable(false);
    }
}

