/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.Validator;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.validate.CompositeInlineValidator;
import oracle.install.commons.swing.validate.InlineValidationHelper;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.exception.Severity;
import oracle.install.ivw.common.validator.BaseInstallLocationValidator;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.OFAWrapper;
import oracle.install.library.util.PathInfo;

public class InstallLocationPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MultilineLabel lblInstallLocDesc = null;
    private JLabel lblOracleBases = null;
    private JComboBox cbxOracleBases = null;
    private JButton btnOraBaseBrowse = null;
    private MultilineLabel lblSoftwareLocDesc = null;
    private JLabel lblName = null;
    private JLabel lblSoftwareLoc = null;
    private JComboBox cbxSoftwareLoc = null;
    private JButton btnOraHomeBrowse = null;
    private String oraBaseLocation = "";
    private String oraHomeLoc = "";
    private String oraBaseActiveHelpId = "InstallLocationPane.cbxOracleBases";
    private String oraHomeActiveHelpId = "InstallLocationPane.cbxSoftwareLoc";
    private boolean oracleHomeLocEdited = false;
    private boolean oracleBaseLocEdited = false;
    private boolean computeOracleHomeLoc;
    private boolean computeCRSHome = false;
    private boolean incrementHomeName = true;
    private boolean updatingOB = false;
    private boolean updatingOH = false;
    String defaultOraHome;
    JPanel orabasePanel = new JPanel();
    JPanel orahomePanel = new JPanel();
    String defaultOraBase;

    public InstallLocationPane() {
        this.initialize();
        this.inlinevalidation();
    }

    public void setOracleHomeActiveHelpId(String activeId) {
        this.oraHomeActiveHelpId = activeId;
        ActiveHelpManager.registerComponent((JComponent)this.cbxSoftwareLoc, (String)this.oraHomeActiveHelpId);
    }

    public void setOracleBaseActiveHelpId(String activeId) {
        this.oraBaseActiveHelpId = activeId;
        ActiveHelpManager.registerComponent((JComponent)this.cbxOracleBases, (String)this.oraBaseActiveHelpId);
    }

    public void setComputeOracleHomeLoc(boolean computeOracleHomeLoc, boolean computeCRSHome) {
        this.computeOracleHomeLoc = computeOracleHomeLoc;
        this.computeCRSHome = computeCRSHome;
    }

    public void setComputeOracleHomeLoc(boolean computeOracleHomeLoc) {
        this.setComputeOracleHomeLoc(computeOracleHomeLoc, false);
    }

    public void setIncrementHomeName(boolean incrementHomeName) {
        this.incrementHomeName = incrementHomeName;
    }

    private void initialize() {
        String base;
        this.lblOracleBases = new JLabel();
        this.lblOracleBases.setName("InstallLocationUI_lblOracleBases");
        this.lblName = new JLabel();
        this.lblName.setName("InstallLocationUI_lblName");
        this.lblSoftwareLocDesc = new MultilineLabel();
        this.lblSoftwareLocDesc.setName("InstallLocationUI_lblSoftwareLocDesc");
        this.lblSoftwareLoc = new JLabel();
        this.lblSoftwareLoc.setName("InstallLocationUI_lblSoftwareLoc");
        this.lblInstallLocDesc = new MultilineLabel();
        this.lblInstallLocDesc.setName("InstallLocationUI_lblInstallLocDesc");
        this.orabasePanel = this.getOrabasePanel();
        this.orahomePanel = this.getOrahomePanel();
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.orabasePanel, (Container)this, (int)0, (int)0, (int)1, (int)1, (int)2, (int)10, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.orahomePanel, (Container)this, (int)0, (int)1, (int)1, (int)1, (int)2, (int)10, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)2, (int)1, (int)1, (int)1, (int)10, (double)1.0, (double)1.0, (Insets)LayoutUtils.STANDARD_INSETS);
        ActiveHelpManager.registerComponent((JComponent)this.cbxOracleBases, (String)this.oraBaseActiveHelpId);
        ActiveHelpManager.registerComponent((JComponent)this.cbxSoftwareLoc, (String)this.oraHomeActiveHelpId);
        String key = "ORACLE_HOME";
        String home = InstallHelper.getValue(key);
        if (home != null && home.length() > 0) {
            this.oracleHomeLocEdited = true;
        }
        if ((base = InstallHelper.getValue(key = "ORACLE_BASE")) != null && base.length() > 0) {
            this.oracleBaseLocEdited = true;
        }
    }

    public void inlinevalidation() {
        InlineValidationHelper.registerInlineValidator((Component)this, (Component)this.cbxOracleBases, (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object data) throws ValidationException {
                return BaseInstallLocationValidator.validateOracleBase(data.toString());
            }
        }, (Object)ValidationComponent.FOCUS_CHANGE_VALIDATOR);
        InlineValidationHelper.registerInlineValidator((Component)this, (Component)this.cbxSoftwareLoc, (Validator)new CompositeInlineValidator(){

            public StatusMessages<ValidationStatusMessage> doValidate(Component component, Object data) throws ValidationException {
                return BaseInstallLocationValidator.validateOracleHomeLocation(data.toString());
            }
        }, (Object)ValidationComponent.FOCUS_CHANGE_VALIDATOR);
    }

    private JPanel getOrabasePanel() {
        JPanel orabasePanel = new JPanel();
        Insets inset = new Insets(10, 5, 10, 5);
        orabasePanel.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblInstallLocDesc, (Container)orabasePanel, (int)0, (int)0, (int)3, (int)1, (int)2, (int)10, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.lblOracleBases, (Container)orabasePanel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (Insets)inset);
        JComboBox cbxOB = this.getOracleBasesComboBox();
        this.lblOracleBases.setLabelFor(cbxOB);
        LayoutUtils.addComponent((Component)cbxOB, (Container)orabasePanel, (int)1, (int)1, (int)1, (int)1, (int)2, (int)10, (double)1.0, (double)0.0, (Insets)inset);
        LayoutUtils.addComponent((Component)this.getOrabaseBrowseButton(), (Container)orabasePanel, (int)2, (int)1, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (Insets)inset);
        return orabasePanel;
    }

    private JPanel getOrahomePanel() {
        JPanel orahomePanel = new JPanel();
        Insets inset = new Insets(10, 5, 10, 5);
        orahomePanel.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblSoftwareLocDesc, (Container)orahomePanel, (int)0, (int)0, (int)3, (int)1, (int)2, (int)10, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.lblSoftwareLoc, (Container)orahomePanel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (Insets)inset);
        JComboBox cbxOH = this.getSoftwareLocComboBox();
        this.lblSoftwareLoc.setLabelFor(cbxOH);
        LayoutUtils.addComponent((Component)cbxOH, (Container)orahomePanel, (int)1, (int)1, (int)1, (int)1, (int)2, (int)10, (double)1.0, (double)0.0, (Insets)inset);
        LayoutUtils.addComponent((Component)this.getOrahomeBrowseButton(), (Container)orahomePanel, (int)2, (int)1, (int)1, (int)1, (int)0, (int)10, (double)0.0, (double)0.0, (Insets)inset);
        return orahomePanel;
    }

    public void fillOracleHomeLocations(String ... locations) {
        try {
            String[] oraHomeLocs = OFAWrapper.getInstance().getAllOracleHomeLocs();
            if (oraHomeLocs != null && oraHomeLocs.length > 0) {
                for (String homeLoc : oraHomeLocs) {
                    if (this.containsItem(this.cbxSoftwareLoc, homeLoc)) continue;
                    this.cbxSoftwareLoc.addItem(homeLoc);
                }
            }
        }
        catch (InstallException e) {
            ExceptionManager.getInstance().reportException(e.getCause(), Severity.WARNING, e.getErrorCode(), e.getHint(), e.getMessage(), new Object[0]);
        }
    }

    private void fillOracleBases() {
        try {
            String[] oraBases;
            this.defaultOraBase = OFAWrapper.getInstance().getDefaultOracleBaseLocation();
            if (!this.containsItem(this.cbxOracleBases, this.defaultOraBase)) {
                this.cbxOracleBases.addItem(this.defaultOraBase);
            }
            if ((oraBases = OFAWrapper.getInstance().getOracleBases()) != null && oraBases.length > 0) {
                for (String orabase : oraBases) {
                    if (this.containsItem(this.cbxOracleBases, orabase)) continue;
                    this.cbxOracleBases.addItem(orabase);
                }
            }
            this.cbxOracleBases.setSelectedItem(this.defaultOraBase);
            this.oraBaseLocation = (String)this.cbxOracleBases.getSelectedItem();
        }
        catch (InstallException e) {
            ExceptionManager.getInstance().reportException(e.getCause(), Severity.WARNING, e.getErrorCode(), e.getHint(), e.getMessage(), new Object[0]);
        }
    }

    public String getOracleBase() {
        this.oraBaseLocation = (String)this.cbxOracleBases.getSelectedItem();
        return this.oraBaseLocation;
    }

    public void setOracleBase(String oraBase) {
        if (oraBase != null) {
            if (!this.containsItem(this.cbxOracleBases, oraBase)) {
                this.cbxOracleBases.addItem(oraBase);
            }
            this.cbxOracleBases.setSelectedItem(oraBase);
            this.oraBaseLocation = oraBase;
        }
    }

    public void setOracleHomeLocation(String oraHome) {
        if (oraHome != null) {
            if (!this.containsItem(this.cbxSoftwareLoc, oraHome)) {
                this.cbxSoftwareLoc.addItem(oraHome);
            }
            this.cbxSoftwareLoc.setSelectedItem(oraHome);
            this.oraHomeLoc = oraHome;
        }
    }

    public String getOracleHomeLocation() {
        return this.oraHomeLoc;
    }

    public void setDefOracleHomeLocation(String oraHome) {
        if (oraHome != null) {
            if (!this.containsItem(this.cbxSoftwareLoc, oraHome)) {
                this.cbxSoftwareLoc.addItem(oraHome);
            }
            this.cbxSoftwareLoc.setSelectedItem(oraHome);
            this.oraHomeLoc = oraHome;
        }
        this.defaultOraBase = OFAWrapper.getInstance().getDefaultOracleBaseLocation();
        this.defaultOraHome = oraHome;
    }

    private JComboBox getOracleBasesComboBox() {
        if (this.cbxOracleBases == null) {
            this.cbxOracleBases = new JComboBox();
            this.cbxOracleBases.setName("InstallLocationUI_cbxOracleBases");
            this.cbxOracleBases.setEditable(true);
            this.fillOracleBases();
            ((JTextField)this.cbxOracleBases.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                }

                public void insertUpdate(DocumentEvent e) {
                    if (!InstallLocationPane.this.updatingOH) {
                        InstallLocationPane.this.updatingOB = true;
                        try {
                            String newBase = "";
                            newBase = e.getDocument().getText(0, e.getDocument().getLength());
                            if (newBase != null && !newBase.equalsIgnoreCase("")) {
                                InstallLocationPane.this.computeNewHomeLocation(newBase);
                                InstallLocationPane.this.oraBaseLocation = newBase;
                            }
                        }
                        catch (BadLocationException e1) {
                            e1.printStackTrace();
                        }
                        InstallLocationPane.this.updatingOB = false;
                    }
                }

                public void removeUpdate(DocumentEvent e) {
                    this.insertUpdate(e);
                }
            });
        }
        return this.cbxOracleBases;
    }

    private JButton getOrabaseBrowseButton() {
        if (this.btnOraBaseBrowse == null) {
            this.btnOraBaseBrowse = new JButton();
            this.btnOraBaseBrowse.setName("InstallLocationUI_btnOraBaseBrowse");
            this.btnOraBaseBrowse.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InstallLocationPane.this.showFileChooserFor(InstallLocationPane.this.cbxOracleBases, true);
                }
            });
        }
        return this.btnOraBaseBrowse;
    }

    private JComboBox getSoftwareLocComboBox() {
        if (this.cbxSoftwareLoc == null) {
            this.cbxSoftwareLoc = new JComboBox();
            this.cbxSoftwareLoc.setName("InstallLocationUI_cbxSoftwareLoc");
            this.cbxSoftwareLoc.setEditable(true);
            this.fillOracleHomeLocations(new String[0]);
            ((JTextComponent)this.cbxSoftwareLoc.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                }

                public void insertUpdate(DocumentEvent e) {
                    if (!InstallLocationPane.this.updatingOB) {
                        InstallLocationPane.this.updatingOH = true;
                        try {
                            String newOraHome = e.getDocument().getText(0, e.getDocument().getLength());
                            InstallLocationPane.this.oraHomeLoc = newOraHome;
                            String oraBase = OFAWrapper.getInstance().getBaseForLocation(InstallLocationPane.this.oraHomeLoc);
                            InstallLocationPane.this.cbxOracleBases.setEnabled(true);
                            SwingUtils.setComponentEnabled((Component)InstallLocationPane.this.btnOraBaseBrowse, (boolean)true);
                            if (OFAWrapper.getInstance().isHomeWithLocationExist(InstallLocationPane.this.oraHomeLoc) && oraBase != null && oraBase.trim().length() > 0) {
                                InstallLocationPane.this.setOracleBase(oraBase);
                                InstallLocationPane.this.dissableOracleBase();
                            } else if (!InstallLocationPane.this.oracleBaseLocEdited && InstallLocationPane.this.oraHomeLoc.equals(InstallLocationPane.this.defaultOraHome) && InstallLocationPane.this.containsItem(InstallLocationPane.this.cbxOracleBases, InstallLocationPane.this.defaultOraBase)) {
                                InstallLocationPane.this.cbxOracleBases.setSelectedItem(InstallLocationPane.this.defaultOraBase);
                                InstallLocationPane.this.oraBaseLocation = InstallLocationPane.this.defaultOraBase;
                            }
                        }
                        catch (BadLocationException e1) {
                            e1.printStackTrace();
                        }
                        InstallLocationPane.this.updatingOH = false;
                    }
                }

                public void removeUpdate(DocumentEvent e) {
                    this.insertUpdate(e);
                }
            });
            this.cbxSoftwareLoc.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() != '\n') {
                        InstallLocationPane.this.oracleHomeLocEdited = true;
                    }
                }
            });
            this.cbxOracleBases.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() != '\n') {
                        InstallLocationPane.this.oracleBaseLocEdited = true;
                    }
                }
            });
        }
        return this.cbxSoftwareLoc;
    }

    private JButton getOrahomeBrowseButton() {
        if (this.btnOraHomeBrowse == null) {
            this.btnOraHomeBrowse = new JButton();
            this.btnOraHomeBrowse.setName("InstallLocationUI_btnOraHomeBrowse");
            this.btnOraHomeBrowse.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    InstallLocationPane.this.showFileChooserFor(InstallLocationPane.this.cbxSoftwareLoc, false);
                }
            });
        }
        return this.btnOraHomeBrowse;
    }

    public void setOracleHomeDesc(String oraHomeDesc) {
        this.lblSoftwareLocDesc.setText(oraHomeDesc);
    }

    public void setOracleBaseDesc(String oraBaseDesc) {
        this.lblInstallLocDesc.setText(oraBaseDesc);
    }

    public void localize() {
        Resource resource = Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID");
        String text = resource.getString("INSTALL_COMMON_INSTALL_LOCATION_DLG_LABEL_SOFTWARE_LOCATION", "Software Location:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblSoftwareLoc, (String)text);
        text = resource.getString("INSTALL_COMMON_ORACLE_BASE_LABEL", "Oracle Base:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblOracleBases, (String)text);
        text = resource.getString("INSTALL_COMMON_INSTALL_LOCATION_DLG_ORACLE_BASE_BROWSE", "B&rowse...", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnOraBaseBrowse, (String)text);
        text = resource.getString("INSTALL_COMMON_INSTALL_LOCATION_DLG_ORACLE_HOME_BROWSE", "Bro&wse", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnOraHomeBrowse, (String)text);
    }

    private void computeNewHomeLocation(String newBase) {
        String location = this.getOracleHomeLocation();
        String oldBase = this.oraBaseLocation;
        if (!this.oracleHomeLocEdited && location != null && !location.equals("")) {
            if (this.computeCRSHome) {
                if (new File(oldBase).getParent() != null) {
                    oldBase = new File(oldBase).getParent();
                }
                if (new File(newBase).getParent() != null) {
                    newBase = new File(newBase).getParent();
                }
            }
            String newHome = this.replaceStr(location, oldBase, newBase);
            if (this.incrementHomeName && newHome.lastIndexOf(95) != -1) {
                newHome = newHome.substring(0, newHome.lastIndexOf(95));
                newHome = newHome + "_" + this.getNewHomeLocIndex(newHome);
            }
            newHome = PathInfo.getInstance().getNativeForm(newHome);
            this.cbxSoftwareLoc.getEditor().setItem(newHome);
            this.oraHomeLoc = newHome;
        }
    }

    private void showFileChooserFor(JComboBox combo, boolean oracleBase) {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        Resource resource = Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID");
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(resource.getString("INSTALL_COMMON_INSTALL_LOCATION_DLG_LABEL_SELECT_PATH", "Select Path", new Object[0]));
        chooser.setApproveButtonText(resource.getString("INSTALL_COMMON_INSTALL_LOCATION_DLG_LABEL_SELECT", "Select", new Object[0]));
        if (combo.getSelectedItem() != null && !combo.getSelectedItem().equals("")) {
            chooser.setCurrentDirectory(new File((String)combo.getSelectedItem()));
        }
        if ((returnVal = chooser.showOpenDialog(this)) == 0) {
            String path = chooser.getSelectedFile().getPath();
            combo.setSelectedItem(path);
            if (oracleBase) {
                this.oraBaseLocation = path;
            } else {
                this.oraHomeLoc = path;
            }
        }
    }

    private boolean containsItem(JComboBox combo, String item) {
        boolean contains = false;
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (!item.equalsIgnoreCase((String)combo.getItemAt(i))) continue;
            contains = true;
        }
        return contains;
    }

    private int getNewHomeLocIndex(String sNewHome) {
        int idx = 1;
        boolean bPathExists = true;
        while (bPathExists) {
            String sPath = sNewHome + "_" + idx;
            bPathExists = new File(sPath).exists();
            if (!bPathExists) continue;
            ++idx;
        }
        return idx;
    }

    private String replaceStr(String origS, String findS, String replaceS) {
        int i = origS.indexOf(findS);
        if (i < 0) {
            return origS;
        }
        String partBefore = origS.substring(0, i);
        String partAfter = origS.substring(i + findS.length());
        if (replaceS.endsWith(File.separator) && partAfter.startsWith(File.separator) && partAfter.length() > 1) {
            partAfter = partAfter.substring(1, partAfter.length());
        }
        if (!replaceS.endsWith(File.separator) && !partAfter.startsWith(File.separator)) {
            replaceS = replaceS + File.separator;
        }
        return partBefore + replaceS + partAfter;
    }

    public void hideOracleBasePanel(boolean value) {
        this.orabasePanel.setVisible(!value);
    }

    public void dissableOracleBase() {
        SwingUtils.setComponentEnabled((Component)this.btnOraBaseBrowse, (boolean)false);
        this.cbxOracleBases.setEnabled(false);
    }

    public void setOracleHomeLocEditied(boolean val) {
        this.oracleHomeLocEdited = val;
    }
}

