/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.ivw.common.bean.PrivilegedOSGroup;

public class PrivilegedOSGroupsPane
extends JPanel {
    private PrivilegedOSGroup[] privilegedOSGroups;
    private String[] osGroups;
    private String title;
    private MultiLineLabel lblTitle;
    private JPanel pnlGroups;
    private Map<PrivilegedOSGroup, String> helpIdMap;

    public PrivilegedOSGroupsPane() {
        this.buildUI();
        this.helpIdMap = new HashMap<PrivilegedOSGroup, String>();
    }

    protected void buildUI() {
        this.setLayout(new GridBagLayout());
        this.lblTitle = new MultiLineLabel(WordWrapper.getTextWrapper(), "");
        this.pnlGroups = new JPanel();
        this.pnlGroups.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblTitle, (Container)this, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.pnlGroups, (Container)this, (int)0, (int)1, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (Insets)new Insets(0, 0, 0, 0));
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)2, (int)1, (int)1, (int)1, (int)11, (double)1.0, (double)1.0, (Insets)LayoutUtils.STANDARD_INSETS);
    }

    public void associateHelpId(PrivilegedOSGroup priviledgedOSGroup, String helpId) {
        this.helpIdMap.put(priviledgedOSGroup, helpId);
        if (this.pnlGroups.getComponentCount() > 0) {
            Component[] components;
            for (Component component : components = this.pnlGroups.getComponents()) {
                if (!(component instanceof PriviledgedOSGroupComboBox)) continue;
                PriviledgedOSGroupComboBox comboBox = (PriviledgedOSGroupComboBox)component;
                if (comboBox.getPrivilegedOSGroup() != priviledgedOSGroup) break;
                ActiveHelpManager activeHelpManager = ActiveHelpManager.getInstance();
                activeHelpManager.register((JComponent)comboBox, helpId);
                break;
            }
        }
    }

    public String[] getOsGroups() {
        return this.osGroups;
    }

    public void setOsGroups(String[] osGroups) {
        if (osGroups != null) {
            String[] oldValue = this.osGroups;
            this.osGroups = osGroups;
            this.firePropertyChange("PrivilegedOSGroupsPane.osGroups", oldValue, this.osGroups);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title != null) {
            this.title = title;
            this.lblTitle.setText(title);
        }
    }

    public PrivilegedOSGroup[] getPrivilegedOSGroups() {
        return this.privilegedOSGroups;
    }

    public void setPrivilegedOSGroups(PrivilegedOSGroup[] osGroups) {
        this.privilegedOSGroups = osGroups;
        if (!this.helpIdMap.isEmpty()) {
            this.helpIdMap.keySet().retainAll(Arrays.asList(osGroups));
        }
        this.layoutGroupsUI();
    }

    private void layoutGroupsUI() {
        if (this.privilegedOSGroups != null) {
            this.pnlGroups.removeAll();
            int gridy = 0;
            for (PrivilegedOSGroup priviledgedOSGroup : this.privilegedOSGroups) {
                PriviledgedOSGroupLabel lblName = new PriviledgedOSGroupLabel(priviledgedOSGroup);
                PriviledgedOSGroupComboBox cbxGroup = new PriviledgedOSGroupComboBox(priviledgedOSGroup, this.osGroups);
                this.addPropertyChangeListener("PrivilegedOSGroupsPane.osGroups", cbxGroup);
                lblName.setLabelFor(cbxGroup);
                String helpId = this.helpIdMap.get((Object)priviledgedOSGroup);
                if (helpId != null) {
                    ActiveHelpManager activeHelpManager = ActiveHelpManager.getInstance();
                    activeHelpManager.register((JComponent)cbxGroup, helpId);
                }
                LayoutUtils.addComponent((Component)lblName, (Container)this.pnlGroups, (int)0, (int)gridy, (int)1, (int)1, (int)2, (int)13, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
                LayoutUtils.addComponent((Component)cbxGroup, (Container)this.pnlGroups, (int)1, (int)gridy, (int)1, (int)1, (int)0, (int)13, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
                if (gridy == 0) {
                    cbxGroup.grabFocus();
                }
                ++gridy;
            }
            this.pnlGroups.validate();
            this.validate();
        }
    }

    private static class PriviledgedOSGroupComboBox
    extends JComboBox
    implements ItemListener,
    PropertyChangeListener {
        private PrivilegedOSGroup privilegedOSGroup;
        private DefaultComboBoxModel osGroupsModel;

        public PriviledgedOSGroupComboBox(PrivilegedOSGroup privilegedOSGroup, String[] osGroups) {
            this.privilegedOSGroup = privilegedOSGroup;
            this.addItemListener(this);
            this.osGroupsModel = new DefaultComboBoxModel();
            this.setModel(this.osGroupsModel);
            this.resetOSGroups(osGroups);
        }

        public PrivilegedOSGroup getPrivilegedOSGroup() {
            return this.privilegedOSGroup;
        }

        public void setPrivilegedOSGroup(PrivilegedOSGroup priviledgedOSGroup) {
            this.privilegedOSGroup = priviledgedOSGroup;
        }

        private void resetOSGroups(String[] osGroups) {
            if (osGroups != null) {
                String defaultGroup = this.privilegedOSGroup.getGroupName();
                this.osGroupsModel.removeAllElements();
                for (String group : osGroups) {
                    this.osGroupsModel.addElement(group);
                    if (!group.equalsIgnoreCase(defaultGroup)) continue;
                    this.osGroupsModel.setSelectedItem(group);
                }
            }
        }

        public void itemStateChanged(ItemEvent e) {
            this.privilegedOSGroup.setGroupName((String)this.getSelectedItem());
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("PrivilegedOSGroupPane.osGroups")) {
                this.resetOSGroups((String[])evt.getNewValue());
            }
        }
    }

    private static class PriviledgedOSGroupLabel
    extends JLabel
    implements PropertyChangeListener {
        private PrivilegedOSGroup privilegedOSGroup;

        public PriviledgedOSGroupLabel(PrivilegedOSGroup priviledgedOSGroup) {
            this.privilegedOSGroup = priviledgedOSGroup;
            this.privilegedOSGroup.addPropertyChangeListener(this);
            String text = this.privilegedOSGroup.getDescription();
            SwingUtils.setText((JLabel)this, (String)text);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("PriviledgedOSGroup.description")) {
                this.setText((String)evt.getNewValue());
            }
        }
    }
}

