/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowWorker;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.util.Application;
import oracle.install.ivw.common.bean.Language;
import oracle.install.ivw.common.bean.OracleSetupBean;
import oracle.install.ivw.common.view.ProductLanguagePane;
import oracle.install.library.util.ProductInfo;

@ViewDef(id="ProductLanguageUI")
public class ProductLanguageGUI
implements View {
    private static Logger logger = Logger.getLogger(ProductLanguageGUI.class.getName());
    private ProductLanguagePane productLanguagePane = new ProductLanguagePane();

    public Component getView() {
        return this.productLanguagePane;
    }

    public void localize(FlowContext flowContext) {
        this.productLanguagePane.localize();
    }

    public void onEvent(FlowContext flowContext, EventType eventType) {
        switch (eventType) {
            case INIT: {
                OracleSetupBean setupBean = (OracleSetupBean)flowContext.getBeanLike(OracleSetupBean.class);
                if (setupBean == null) break;
                final String[] selectedLanguages = setupBean.getLanguages();
                FlowWorker flowWorker = FlowWorker.getInstance((FlowContext)flowContext);
                flowWorker.perform((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Application.showStatus((String)Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID").getString("ProductLanguagePane.statusControl.text", "Fetching Available Languages...", new Object[0]));
                        final Set<Language> supportedLanguages = ProductInfo.getInstance().getSupportedLanguages();
                        Application.hideStatus();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ProductLanguageGUI.this.productLanguagePane.setData(supportedLanguages, selectedLanguages);
                            }
                        });
                        return null;
                    }
                });
            }
        }
    }

    public void processInput(FlowContext flowContext) {
        OracleSetupBean setupBean = (OracleSetupBean)flowContext.getBeanLike(OracleSetupBean.class);
        if (setupBean != null) {
            String[] languageCodes = this.productLanguagePane.getSelectedLanguageCodes();
            setupBean.setLanguages(languageCodes);
            logger.log(Level.INFO, "The languages in which the product will be installed are {0}", Arrays.asList(languageCodes));
        }
    }
}

