/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.bean.Language;
import oracle.install.ivw.common.resource.CommonErrorCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductLanguagePane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JList availableList;
    private JList selectedList;
    private Shuttle shuttle;
    private JLabel availLabel;
    private JLabel selectLabel;
    private MultilineLabel lblDesc;
    private DefaultListModel availableLanguagesModel;
    private DefaultListModel selectedLanguagesModel;
    private Resource resource;
    private Set<Language> availableLanguages;

    public ProductLanguagePane() {
        this.buildUI();
    }

    public Set<Language> getAvailableLanguages() {
        return this.availableLanguages;
    }

    public String[] getSelectedLanguageCodes() {
        ArrayList<String> codes = new ArrayList<String>();
        int n = this.selectedLanguagesModel.getSize();
        for (int i = 0; i < n; ++i) {
            Language language = (Language)this.selectedLanguagesModel.get(i);
            codes.add(language.getCode());
        }
        return codes.toArray(new String[0]);
    }

    public void setData(Set<Language> availableLanguages, String[] selectedLanguageCodes) {
        this.availableLanguages = availableLanguages;
        List<String> selectedLanguages = Arrays.asList(selectedLanguageCodes);
        for (Language language : availableLanguages) {
            if (selectedLanguages.contains(language.getCode())) {
                this.selectedLanguagesModel.addElement(language);
                continue;
            }
            this.availableLanguagesModel.addElement(language);
        }
    }

    private void buildUI() {
        this.resource = Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID");
        this.lblDesc = new MultilineLabel();
        this.availLabel = new JLabel();
        this.availableLanguagesModel = new DefaultListModel();
        this.availableList = new JList(this.availableLanguagesModel);
        this.availLabel.setLabelFor(this.availableList);
        this.selectLabel = new JLabel();
        this.selectedLanguagesModel = new DefaultListModel();
        this.selectedList = new JList(this.selectedLanguagesModel);
        this.selectLabel.setLabelFor(this.selectedList);
        this.shuttle = new Shuttle();
        this.shuttle.add((Component)this.availLabel, (Object)"FromHeader");
        this.shuttle.add((Component)this.selectLabel, (Object)"ToHeader");
        ListPicker availableListPicker = new ListPicker(this.availableList);
        availableListPicker.setItemsSorted(true);
        this.shuttle.setFromPicker((ItemPicker)availableListPicker);
        ListPicker selectedListPicker = new ListPicker(this.selectedList);
        selectedListPicker.setItemsSorted(true);
        this.shuttle.setToPicker((ItemPicker)selectedListPicker);
        this.shuttle.setMode(0);
        this.shuttle.setHorizontalLayout(true);
        this.shuttle.addShuttleListener(new ShuttleListener(){

            public void shuttleItemsMoved(ShuttleEvent event) {
            }

            public void shuttleItemsRemoved(ShuttleEvent event) {
                Transferable[] items;
                for (Transferable transferable : items = event.getItems()) {
                    try {
                        DataFlavor[] flavors;
                        for (DataFlavor flavor : flavors = transferable.getTransferDataFlavors()) {
                            Language language;
                            Object data = transferable.getTransferData(flavor);
                            if (!(data instanceof Language) || !(language = (Language)data).getCode().equals(Locale.ENGLISH.getLanguage())) continue;
                            ProductLanguagePane.this.availableLanguagesModel.removeElement(language);
                            ProductLanguagePane.this.selectedLanguagesModel.addElement(language);
                            DefaultErrorMessage errorMessage = new DefaultErrorMessage((ErrorCode)CommonErrorCode.PRODUCT_LANGUAGE_ENGLISH_IS_MANDATORY, new Object[0]);
                            StandardDialog.showError(null, (String)errorMessage.getErrorInfo().getDescription());
                        }
                    }
                    catch (UnsupportedFlavorException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }

            public void shuttleItemsReordered(ShuttleEvent event) {
            }
        });
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblDesc, (Container)this, (int)0, (int)0, (int)1, (int)1, (int)1, (int)23, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)this.shuttle, (Container)this, (int)0, (int)2, (int)1, (int)1, (int)1, (int)10, (double)0.1f, (double)0.1f, (Insets)new Insets(3, 5, 2, 5));
        this.setVisible(true);
    }

    public void localize() {
        this.lblDesc.setText(this.resource.getString("PRODUCT_LANGUAGE_DEC_PROMPT", "", new Object[0]));
        SwingUtils.setText((JLabel)this.availLabel, (String)this.resource.getString("PRODUCT_LANGUAGE_AVAILABLE_LANGUAGES_LABEL", "", new Object[0]));
        SwingUtils.setText((JLabel)this.selectLabel, (String)this.resource.getString("PRODUCT_LANGUAGE_SELECTED_LANGUAGES_LABEL", "", new Object[0]));
    }
}

