/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.install.commons.net.support.SSHConnectivityDetails;
import oracle.install.commons.net.support.SSHConnectivitySetupInfo;
import oracle.install.commons.net.support.SSHSupportManager;
import oracle.install.commons.net.support.SSHSupportManagerException;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.StandardDialog;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.ivw.common.resource.CommonDialogLabelResID;
import oracle.install.library.util.Node;
import oracle.install.library.util.PlatformInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSHSetupPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Set<? extends Node> nodeSet;
    private JButton btnSetupSSH;
    private JButton btnTestSSH;
    private JCheckBox chkSharedHome;
    private JCheckBox chkReuseKeys;
    private JLabel lblUsername;
    private JTextField txtUsername;
    private JLabel lblUnixPassword;
    private JPasswordField txtUnixPassword;
    private SSHConnectivitySetupInfo sshConnectivitySetupInfo;
    private Resource resource;
    private NodeSetProvider nodeSetProvider;

    public SSHSetupPane() {
        Application application = Application.getInstance();
        this.resource = application.getResource(CommonDialogLabelResID.class.getName());
        this.nodeSetProvider = new NodeSetProvider(){

            @Override
            public Set<? extends Node> getNodeSet() {
                return SSHSetupPane.this.nodeSet;
            }
        };
        this.buildUI();
        this.setSshConnectivitySetupInfo(new SSHConnectivitySetupInfo());
        super.setVisible(!PlatformInfo.getInstance().isWindows());
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(PlatformInfo.getInstance().isWindows() ? false : visible);
    }

    protected void buildUI() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.btnSetupSSH = new JButton();
        this.btnTestSSH = new JButton();
        this.chkSharedHome = new JCheckBox();
        this.chkReuseKeys = new JCheckBox();
        this.txtUsername = new JTextField(15);
        this.txtUsername.setEditable(false);
        this.lblUsername = new JLabel();
        this.lblUnixPassword = new JLabel();
        this.txtUnixPassword = new JPasswordField(15);
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblUsername, (Container)this, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.txtUsername, (Container)this, (int)1, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.lblUnixPassword, (Container)this, (int)2, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.txtUnixPassword, (Container)this, (int)3, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.chkSharedHome, (Container)this, (int)0, (int)1, (int)4, (int)1, (int)2, (int)17, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.chkReuseKeys, (Container)this, (int)0, (int)2, (int)4, (int)1, (int)2, (int)17, (double)1.0, (double)0.0);
        this.txtUnixPassword.setMinimumSize(this.txtUnixPassword.getPreferredSize());
        this.txtUsername.setMinimumSize(this.txtUsername.getPreferredSize());
        JPanel pnlControl = new JPanel(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.btnTestSSH, (Container)pnlControl, (int)0, (int)0, (int)1, (int)1, (int)0, (int)13, (double)0.0, (double)0.0, (Insets)new Insets(0, 0, 0, 1));
        LayoutUtils.addComponent((Component)this.btnSetupSSH, (Container)pnlControl, (int)1, (int)0, (int)1, (int)1, (int)0, (int)13, (double)0.0, (double)0.0, (Insets)new Insets(0, 1, 0, 0));
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)3, (int)4, (int)1, (int)2, (int)13, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)pnlControl, (Container)this, (int)1, (int)3, (int)5, (int)1, (int)0, (int)13, (double)0.0, (double)0.0);
        this.lblUsername.setLabelFor(this.txtUsername);
        this.lblUnixPassword.setLabelFor(this.txtUnixPassword);
        this.localize();
        this.chkSharedHome.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SSHSetupPane.this.sshConnectivitySetupInfo.setSharedHome(e.getStateChange() == 1);
            }
        });
        this.chkReuseKeys.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SSHSetupPane.this.sshConnectivitySetupInfo.setReuseKeys(e.getStateChange() == 1);
            }
        });
        this.txtUnixPassword.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                SSHSetupPane.this.sshConnectivitySetupInfo.setSharedPassword(new String(SSHSetupPane.this.txtUnixPassword.getPassword()));
            }

            public void removeUpdate(DocumentEvent e) {
                SSHSetupPane.this.sshConnectivitySetupInfo.setSharedPassword(new String(SSHSetupPane.this.txtUnixPassword.getPassword()));
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.btnTestSSH.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SSHSetupPane.this.doTestSSH();
            }
        });
        this.btnSetupSSH.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SSHSetupPane.this.doSetupSSH();
            }
        });
    }

    public NodeSetProvider getNodeSetProvider() {
        return this.nodeSetProvider;
    }

    public void setNodeSetProvider(NodeSetProvider nodeSetProvider) {
        this.nodeSetProvider = nodeSetProvider;
    }

    public Set<? extends Node> getNodeSet() {
        return this.nodeSet;
    }

    public void setNodeSet(Set<? extends Node> nodes) {
        this.nodeSet = nodes;
    }

    public SSHConnectivitySetupInfo getSshConnectivitySetupInfo() {
        return this.sshConnectivitySetupInfo;
    }

    public void setSshConnectivitySetupInfo(SSHConnectivitySetupInfo sshConnectivitySetupInfo) {
        this.sshConnectivitySetupInfo = sshConnectivitySetupInfo;
        this.chkSharedHome.setSelected(this.sshConnectivitySetupInfo.isSharedHome());
        this.chkReuseKeys.setSelected(this.sshConnectivitySetupInfo.isReuseKeys());
        this.txtUnixPassword.setText(this.sshConnectivitySetupInfo.getSharedPassword());
        this.txtUsername.setText(this.sshConnectivitySetupInfo.getSharedUsername());
    }

    private void doSetupSSH() {
        final Set<? extends Node> nodeSet = this.nodeSetProvider.getNodeSet();
        if (nodeSet != null && !nodeSet.isEmpty()) {
            if (this.sshConnectivitySetupInfo.getSharedPassword() == null || this.sshConnectivitySetupInfo.getSharedPassword().trim().length() == 0) {
                String message = this.resource.getString("SSHConnectivity.error.invalidPassword", "Unix password not provided.", new Object[0]);
                StandardDialog.showError((Component)this, (String)message);
            } else {
                SSHOperation t = new SSHOperation(){

                    public SSHConnectivityDetails perform(SSHSupportManager sshSupportManager) throws SSHSupportManagerException {
                        SSHSetupPane.this.sshConnectivitySetupInfo.setNodes(this.getNodeList(nodeSet, true));
                        SSHConnectivityDetails details = sshSupportManager.establishSSHConnectivity(SSHSetupPane.this.sshConnectivitySetupInfo);
                        if (details.isConfigurationComplete()) {
                            SSHSetupPane.this.sshConnectivitySetupInfo.setEnabled(true);
                        }
                        return details;
                    }
                };
                t.start();
            }
        }
    }

    private void doTestSSH() {
        final Set<? extends Node> nodeSet = this.nodeSetProvider.getNodeSet();
        if (nodeSet != null && !nodeSet.isEmpty()) {
            SSHOperation t = new SSHOperation(){

                public SSHConnectivityDetails perform(SSHSupportManager sshSupportManager) throws SSHSupportManagerException {
                    String[] nodeList = this.getNodeList(nodeSet, false);
                    SSHConnectivityDetails details = sshSupportManager.getSSHConnectivityDetails(nodeList);
                    return details;
                }
            };
            t.start();
        }
    }

    public void localize() {
        String text = this.resource.getString("SSHSetupPane.lblUsername.text", "&Operating System Username:*", new Object[0]);
        SwingUtils.setText((JLabel)this.lblUsername, (String)text);
        text = this.resource.getString("SSHSetupPane.lblUnixPassword.text", "Operating System Pass&word:*", new Object[0]);
        SwingUtils.setText((JLabel)this.lblUnixPassword, (String)text);
        text = this.resource.getString("SSHSetupPane.btnSetupSSH.text", "Setu&p*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnSetupSSH, (String)text);
        text = this.resource.getString("SSHSetupPane.btnTestSSH.text", "&Test*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnTestSSH, (String)text);
        text = this.resource.getString("SSHSetupPane.chkReuseKeys.text", "Reuse private and public &keys existing in user home*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.chkReuseKeys, (String)text);
        text = this.resource.getString("SSHSetupPane.chkSharedHome.text", "User home is shared b&y the selected nodes*", new Object[0]);
        SwingUtils.setText((AbstractButton)this.chkSharedHome, (String)text);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class SSHOperation
    extends Thread {
        public SSHOperation() {
            super("SSHSetupPane.SSHOperation");
        }

        public String[] getNodeList(Set<? extends Node> nodeSet, boolean fqn) {
            ArrayList<String> nodeList = new ArrayList<String>();
            for (Node node : nodeSet) {
                nodeList.add(Node.getHostName(node.getName(), fqn));
            }
            return nodeList.toArray(new String[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            SSHSupportManager sshSupportManager = SSHSupportManager.getInstance();
            try {
                SSHConnectivityDetails details = this.perform(sshSupportManager);
                if (details.isConfigurationComplete()) {
                    StatusMessage statusMessage = details.getOverallStatusMessage();
                    StandardDialog.showInformation((Component)SSHSetupPane.this, (String)statusMessage.getMessage());
                } else {
                    ErrorMessage errorMessage = details.getOverallErrorMessage();
                    StandardDialog.showError((Component)SSHSetupPane.this, (ErrorMessage)errorMessage);
                }
            }
            catch (SSHSupportManagerException e) {
                StandardDialog.showError((Component)SSHSetupPane.this, (Throwable)e);
            }
            finally {
                Application.hideStatus();
            }
        }

        public abstract SSHConnectivityDetails perform(SSHSupportManager var1) throws SSHSupportManagerException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface NodeSetProvider {
        public Set<? extends Node> getNodeSet();
    }
}

