/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.asm;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.install.commons.util.ProxyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACFSUtil {
    private static final Logger logger = Logger.getLogger(ACFSUtil.class.getName());
    private static ACFSUtil instance = null;
    private ClusterwareInfo clusterwareInfo = null;

    private void initClusterwareInfo() {
        if (this.clusterwareInfo == null) {
            this.clusterwareInfo = new ClusterwareInfo();
        }
    }

    protected ACFSUtil() {
        this.initClusterwareInfo();
    }

    public static ACFSUtil getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (ACFSUtil)(proxyFactory = ProxyFactory.getInstance()).createProxy(ACFSUtil.class)) == null) {
            instance = new ACFSUtil();
        }
        return instance;
    }

    public boolean isACFSDriversConfigured() {
        if (this.isACFSDriversInstalled()) {
            try {
                return this.clusterwareInfo.isOFSDriversConfigured();
            }
            catch (InstallException e) {
                logger.log(Level.FINEST, e.getMessage());
                return false;
            }
        }
        return false;
    }

    public boolean isACFSDriversInstalled() {
        try {
            return this.clusterwareInfo.isOFSDriversInstalled();
        }
        catch (InstallException e) {
            logger.log(Level.FINEST, e.getMessage());
            return false;
        }
    }

    public List<String> getACFSMountPoints() {
        if (this.isACFSDriversConfigured()) {
            try {
                return this.clusterwareInfo.getOFSMountPoints();
            }
            catch (InstallException e) {
                logger.log(Level.FINEST, e.getMessage());
                return null;
            }
        }
        return null;
    }

    public List<String> getRegisteredACFSMountPoints() {
        if (this.isACFSDriversConfigured()) {
            List<String> allValidMountPoints = ACFSUtil.getListWithValidElemsOnly(this.getACFSMountPoints());
            ArrayList<String> registeredMountPoints = null;
            if (allValidMountPoints != null) {
                ListIterator<String> li = allValidMountPoints.listIterator();
                while (li.hasNext()) {
                    String path = li.next();
                    try {
                        if (!this.clusterwareInfo.isPathOnACFS(path)) continue;
                        if (registeredMountPoints == null) {
                            registeredMountPoints = new ArrayList<String>();
                        }
                        registeredMountPoints.add(path);
                    }
                    catch (InstallException e) {
                        logger.log(Level.FINEST, e.getMessage());
                    }
                }
            }
            return registeredMountPoints;
        }
        return null;
    }

    private static List<String> getListWithValidElemsOnly(List<String> list) {
        if (list != null && list.size() > 0) {
            ArrayList<String> newlist = new ArrayList<String>(list);
            ListIterator iter = newlist.listIterator();
            while (iter.hasNext()) {
                String s = (String)iter.next();
                if (s != null && s.trim().length() != 0) continue;
                iter.remove();
            }
            return newlist;
        }
        return list;
    }

    public boolean isPathOnACFS(String path) {
        List<String> allValidMountPoints;
        if (this.isACFSDriversConfigured() && (allValidMountPoints = ACFSUtil.getListWithValidElemsOnly(this.getACFSMountPoints())) != null) {
            ListIterator<String> li = allValidMountPoints.listIterator();
            while (li.hasNext()) {
                String mountpoint = li.next();
                if (!path.startsWith(mountpoint) || path.length() != mountpoint.length() && path.charAt(mountpoint.length()) != File.separatorChar) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPathOnRegisteredACFS(String path) {
        List<String> allValidRegisteredMountPoints;
        if (this.isACFSDriversConfigured() && (allValidRegisteredMountPoints = ACFSUtil.getListWithValidElemsOnly(this.getRegisteredACFSMountPoints())) != null) {
            ListIterator<String> li = allValidRegisteredMountPoints.listIterator();
            while (li.hasNext()) {
                String mountpoint = li.next();
                if (!path.startsWith(mountpoint) || path.length() != mountpoint.length() && path.charAt(mountpoint.length()) != File.separatorChar) continue;
                return true;
            }
        }
        return false;
    }
}

