/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.crs;

import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OIFCFGResult;
import oracle.cluster.cmdtools.OIFCFGUtil;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.exception.Severity;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.PlatformInfo;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.Version;
import oracle.sysman.oii.oiip.oiipg.OiipgDetectCluster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRSInfo {
    private Logger logger = Logger.getLogger(CRSInfo.class.getName());
    private String crsVersion;
    private static CRSInfo instance = null;
    private String localNodeName;
    public static final char sep = File.separatorChar;
    String clusterName;
    private ClusterwareInfo clusterwareInfo = null;
    public static final String OIFCFG_SUBDIR = "ext" + File.separator + "bin";

    public void initClusterwareInfo() {
        if (this.clusterwareInfo == null) {
            this.clusterwareInfo = new ClusterwareInfo();
        }
    }

    public static CRSInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (CRSInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(CRSInfo.class)) == null) {
            instance = new CRSInfo();
        }
        return instance;
    }

    public String getDefaultClusterName() {
        String strDefCRSName = this.getClusterPrefix();
        if (strDefCRSName.length() > 0) {
            strDefCRSName = strDefCRSName + "-";
        }
        return strDefCRSName + "cluster";
    }

    public String getClusterPrefix() {
        String hostName;
        StringBuffer prefix = new StringBuffer("");
        MachineInfo mInfo = MachineInfo.getInstance();
        String hostWithoutDomain = mInfo.getMachineName(hostName = mInfo.getFullHostName());
        if (hostWithoutDomain != null && hostWithoutDomain.trim().length() > 0) {
            prefix = new StringBuffer(hostWithoutDomain);
            String regEx = "[0-9]";
            boolean hasNumericSuffix = true;
            while (hasNumericSuffix && prefix.length() > 0) {
                String lastChar = prefix.substring(prefix.length() - 1);
                hasNumericSuffix = lastChar.matches(regEx);
                if (!hasNumericSuffix) continue;
                prefix.deleteCharAt(prefix.length() - 1);
            }
            if (prefix.length() > 7) {
                prefix = new StringBuffer(prefix.substring(0, 7));
            }
        }
        return prefix.toString();
    }

    public String getCRSHome() {
        List<String> pre112CRSHomes = null;
        List<String> giHomes = null;
        String crsHome = "";
        InventoryInfo invInfo = InventoryInfo.getInstance();
        try {
            giHomes = invInfo.getListOfOH("oracle.crs", "11.2.0.0.0", "999.9.9.9.9");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (giHomes != null && giHomes.size() > 0) {
            ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
            String home = giHomes.get(0);
            try {
                crsHome = clusterwareInfo.getConfiguredCRSHome(home);
            }
            catch (InstallException e) {
                e.printStackTrace();
            }
            if (crsHome != null && crsHome.length() > 0) {
                return crsHome;
            }
        }
        try {
            pre112CRSHomes = invInfo.getListOfOH("oracle.crs", "10.1.0.0.0", "11.1.9.9.9");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (pre112CRSHomes != null && pre112CRSHomes.size() > 0) {
            crsHome = pre112CRSHomes.get(0);
        }
        return crsHome;
    }

    public String getCRSNodeList() {
        String crsNodeList = "";
        try {
            InventoryInfo inv = InventoryInfo.getInstance();
            crsNodeList = inv.getCRSNodes();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return crsNodeList;
    }

    public boolean isCRSPresent() {
        boolean isClusterware = false;
        InventoryInfo invInfo = InventoryInfo.getInstance();
        try {
            isClusterware = invInfo.isCRSInstalled();
        }
        catch (InstallException e) {
            ExceptionManager.handle((Throwable)e);
        }
        return isClusterware;
    }

    public String[] getNodesFromCRSstack() {
        OiipgDetectCluster detectCluster = OiipgDetectCluster.getDetectCluster();
        String[] clusterNodes = detectCluster.getNodeNames();
        return clusterNodes;
    }

    public String getCRSActiveVersion() {
        if (this.isCRSPresent()) {
            try {
                ClusterInfo cInfo = new ClusterInfo(this.getCRSHome());
                return cInfo.getCRSActiveVersionString();
            }
            catch (ClusterInfoException e) {
                return "";
            }
            catch (Exception e) {
                return "";
            }
        }
        return "";
    }

    public String getCRSHomeName() {
        return "";
    }

    public String getClusterName() {
        if (this.isCRSPresent() && this.clusterName == null) {
            ProcessBuilder processBuilder = new ProcessBuilder(this.getCRSHome() + sep + "bin" + sep + "cemutlo");
            processBuilder.command().add("-n");
            AbstractLineProcessor lineProcessor = new AbstractLineProcessor(){

                public void processLine(String line, int lineNumber) {
                    CRSInfo.this.clusterName = line;
                }
            };
            ProcessLaunchInfo processLaunchInfo = new ProcessLaunchInfo(processBuilder, (OutputProcessor)lineProcessor, null);
            try {
                ProcessLauncher.launch((ProcessLaunchInfo)processLaunchInfo);
            }
            catch (Exception e) {
                this.logger.severe("GetClusterName Exception:" + e.getMessage());
                e.printStackTrace();
            }
        }
        return this.clusterName;
    }

    public boolean isCRsActive() {
        return false;
    }

    public String[] getPrivateInterfaces() {
        String OIFCFG = "oifcfg";
        String scratch_path = InstallHelper.getInstallBinariesPath();
        String command = "";
        String[] envp = null;
        command = PlatformInfo.getInstance().isUnix() ? scratch_path + sep + OIFCFG : "\"" + scratch_path + sep + OIFCFG + ".exe\"";
        String[] commandWithArgs = new String[]{command, "-p", "-n"};
        OIFCFGParse oifcfg = new OIFCFGParse();
        try {
            oifcfg.runCommand(commandWithArgs, envp);
        }
        catch (Exception e) {
            ExceptionManager.getInstance().reportException((Throwable)e, Severity.FATAL, (ErrorCode)CommonErrorCode.INSTALL_COMMON_IO_EXCEPTION, null);
        }
        String[] str = new String[oifcfg.storeList.size()];
        oifcfg.storeList.toArray(str);
        return str;
    }

    public String getDefaultNodeList() {
        return "";
    }

    public String getLocalNodeName() {
        if (this.localNodeName == null) {
            OiipgDetectCluster detectCluster = OiipgDetectCluster.getDetectCluster();
            this.localNodeName = detectCluster.getLocalNodeName();
        }
        return this.localNodeName;
    }

    public String getCRSVersion() {
        if (this.crsVersion == null) {
            OiipgDetectCluster detectCluster = OiipgDetectCluster.getDetectCluster();
            this.crsVersion = detectCluster.getActiveVersion();
        }
        return this.crsVersion;
    }

    public List<String> getRemoteNodes() {
        ArrayList<String> nodeList = new ArrayList<String>();
        try {
            ClusterInfo clusterInfo;
            String[] nodeNames;
            if (this.getCRSHome() != null && (nodeNames = (clusterInfo = new ClusterInfo(this.getCRSHome())).getNodeNames()) != null && nodeNames.length > 0) {
                for (String node : nodeNames) {
                    if (node.equals(clusterInfo.getLocalNodeName())) continue;
                    nodeList.add(node);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nodeList;
    }

    public String getDefaultGNSDomain() {
        String gnsDomain = null;
        String prefix = this.getClusterPrefix();
        String domain = MachineInfo.getInstance().getDomainName();
        gnsDomain = prefix + "." + domain;
        return gnsDomain;
    }

    public String getDefaultIPAddressForGNSVIP() {
        String defaultIP;
        block10: {
            defaultIP = null;
            String scratchPath = System.getProperty("oracle.installer.scratchPath");
            String oifcfgPath = scratchPath + File.separator + OIFCFG_SUBDIR;
            NetworkInterface oInterface = null;
            List results = null;
            OIFCFGUtil oifcfgUtil = null;
            try {
                oInterface = NetworkInterface.getByInetAddress(InetAddress.getByName(MachineInfo.getInstance().getFullHostName()));
            }
            catch (SocketException e) {
                this.logger.log(Level.INFO, "Exception occurred while getting the interface name of the local node");
            }
            catch (UnknownHostException e) {
                this.logger.log(Level.INFO, "Exception occurred while getting the interface name of the local node");
            }
            try {
                oifcfgUtil = new OIFCFGUtil(oifcfgPath, true);
                results = oifcfgUtil.listInterfaces(MachineInfo.getInstance().getFullHostName());
                if (results == null || results.size() <= 0) break block10;
                for (OIFCFGResult res : results) {
                    if (!oInterface.getName().equals(res.getInterfaceName())) continue;
                    defaultIP = res.getSubnet().getHostAddress();
                    StringTokenizer tokenizer = new StringTokenizer(defaultIP, ".");
                    int numOfTokens = tokenizer.countTokens();
                    if (numOfTokens != 4) break;
                    String[] tokens = new String[numOfTokens];
                    int tokenIndex = 0;
                    while (tokenizer.hasMoreElements()) {
                        tokens[tokenIndex++] = tokenizer.nextToken();
                    }
                    String lastField = tokens[numOfTokens - 1];
                    try {
                        int last = Integer.parseInt(lastField);
                        tokens[numOfTokens - 1] = Integer.toString(++last);
                    }
                    catch (NumberFormatException e) {
                        this.logger.log(Level.INFO, "Error while defaulting the GNS VIP");
                    }
                    defaultIP = "";
                    for (String s : tokens) {
                        defaultIP = defaultIP + s + ".";
                    }
                    defaultIP = defaultIP.substring(0, defaultIP.length() - 1);
                    break;
                }
            }
            catch (CmdToolUtilException cue) {
                this.logger.info("The defaulting of GNS VIP failed : Message: " + cue.getMessage());
            }
        }
        return defaultIP;
    }

    public List<String> getHAManagedDatabases(String crsHomeLoc) {
        this.initClusterwareInfo();
        try {
            return this.clusterwareInfo.getHAManagedDatabases(crsHomeLoc);
        }
        catch (InstallException e) {
            return null;
        }
    }

    public boolean doesDatabaseExistsOnNode(String crsHoome, String node, String db) throws InstallException {
        this.initClusterwareInfo();
        return this.clusterwareInfo.isDatabaseExists(crsHoome, node, db);
    }

    public String getActualHostName(String node) {
        String hostname = "";
        Version version = new Version();
        try {
            hostname = ClusterInfo.getHostName((String)node, (Version)version);
        }
        catch (ClusterInfoException e) {
            this.logger.info("Failed while retrieving the hostname for the nodes");
        }
        return hostname;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum oifcfgMapping {
        UNKNOWN(3),
        PRIVATE(2),
        PUBLIC(1);

        private String value;

        private oifcfgMapping(int indentifier) {
            this.value = indentifier + "";
        }

        public String getValue() {
            return this.value;
        }
    }

    private class OIFCFGParse
    extends AbstractLineProcessor {
        private ArrayList<String> storeList;

        private OIFCFGParse() {
        }

        public void processLine(String line, int lineNumber) {
            String[] input = line.split("[\\s\\t]{2}");
            StringBuffer output = new StringBuffer();
            for (String token : input) {
                oifcfgMapping[] mappings;
                for (oifcfgMapping mapping : mappings = oifcfgMapping.values()) {
                    if (token.indexOf(mapping.toString()) == -1) continue;
                    token = mapping.getValue();
                    break;
                }
                output.append(token);
                output.append(':');
            }
            if (output.charAt(output.length() - 1) == ':') {
                output.deleteCharAt(output.length() - 1);
            }
            this.storeList.add(output.toString());
        }

        private void runCommand(String[] command, String[] envp) {
            this.storeList = new ArrayList();
            try {
                ProcessBuilder pb = new ProcessBuilder(command);
                int currentPlatform = PlatformInfo.getInstance().getCurrentPlatform();
                if (currentPlatform == 610 || currentPlatform == 453 || currentPlatform == 197) {
                    pb.environment().put("LD_LIBRARY_PATH", InstallHelper.getInstallLibrariesPath());
                }
                ProcessLaunchInfo pli = new ProcessLaunchInfo(pb, (OutputProcessor)this, null);
                ProcessLauncher.launch((ProcessLaunchInfo)pli);
            }
            catch (Exception e) {
                ExceptionManager.getInstance().reportException((Throwable)e, Severity.FATAL, (ErrorCode)CommonErrorCode.INSTALL_COMMON_IO_EXCEPTION, null);
            }
        }
    }
}

