/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.crs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.library.crs.CRSInfo;
import oracle.install.library.util.InstallConstants;
import oracle.install.library.util.ProductInfo;
import oracle.install.library.util.VersionInfo;
import oracle.ops.mgmt.cluster.CSSConfigInfo;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.LocalCSSException;
import oracle.ops.mgmt.cluster.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSInfo {
    private static final Logger logger = Logger.getLogger(CSSInfo.class.getName());
    public static final String ClusterCSS10 = "ClusterCSS10";
    public static final String LocalCSS10 = "LocalCSS10";
    public static final String ClusterCSS92 = "ClusterCSS92";
    public static final String NoCSS = "NoCSS";

    public static List<String> getCSSInfo(String[] nodeNames) {
        Version ver10 = new Version();
        Version ver92 = Version.get92Version();
        boolean ifCss = false;
        String[] nodes = nodeNames;
        ArrayList<String> retList = new ArrayList<String>();
        try {
            for (int i = 0; i < nodes.length; ++i) {
                CSSConfigInfo ci = ClusterInfo.getCSSConfig((String)nodes[i], (Version)ver10);
                ifCss = ci.isClusterConfig();
                String cnvrt = new Boolean(ifCss).toString();
                if (ifCss) {
                    retList.add(nodes[i] + ":" + ClusterCSS10 + ":" + cnvrt);
                    continue;
                }
                ifCss = ci.isLocalConfig();
                cnvrt = new Boolean(ifCss).toString();
                if (ifCss) {
                    retList.add(nodes[i] + ":" + LocalCSS10 + ":" + cnvrt);
                    continue;
                }
                ci = ClusterInfo.getCSSConfig((String)nodes[i], (Version)ver92);
                ifCss = ci.isClusterConfig();
                cnvrt = new Boolean(ifCss).toString();
                if (ifCss) {
                    retList.add(nodes[i] + ":" + ClusterCSS92 + ":" + cnvrt);
                    continue;
                }
                retList.add(nodes[i] + ":" + NoCSS + ":" + cnvrt);
            }
        }
        catch (ClusterInfoException cie) {
            logger.info("Caught ClusterException in CSSInfo." + cie.getLocalizedMessage());
        }
        return retList;
    }

    public static boolean isCSSAlreadyUpgraded() {
        String releaseVersion = InstallConstants.VERSION.toString();
        String cssVersion = CSSInfo.getCSSVersion();
        if (cssVersion == null || cssVersion.equals("")) {
            return true;
        }
        if (releaseVersion.equalsIgnoreCase(cssVersion)) {
            return true;
        }
        String higherVersion = new VersionInfo().getHigherVersion(releaseVersion, cssVersion);
        return cssVersion.equalsIgnoreCase(higherVersion);
    }

    public static String getCSSVersion() {
        String crsHome = CRSInfo.getInstance().getCRSHome();
        if (crsHome != null && !crsHome.equals("")) {
            return CRSInfo.getInstance().getCRSActiveVersion();
        }
        try {
            return ProductInfo.getInstance().getProductVersion(CSSInfo.getCSSHomeSI(), "oracle.rdbms");
        }
        catch (ClusterInfoException e) {
            logger.log(Level.INFO, "while getting CSS version" + (Object)((Object)e));
            return "";
        }
        catch (LocalCSSException e) {
            logger.log(Level.INFO, "while getting CSS version" + (Object)((Object)e));
            return "";
        }
        catch (Exception e) {
            logger.log(Level.INFO, "while getting CSS version" + e);
            return "";
        }
    }

    public static boolean isLocalCSSExist() {
        boolean exist = false;
        try {
            for (Version v : Arrays.asList(new Version(), Version.get92Version())) {
                CSSConfigInfo cssConfig = ClusterInfo.getCSSConfig((Version)v);
                if (cssConfig == null || !cssConfig.isLocalConfig()) continue;
                return true;
            }
        }
        catch (ClusterInfoException e) {
            logger.log(Level.WARNING, "Error while checking the existance of Local CSS.", e);
        }
        return exist;
    }

    public static String getCSSHomeSI() throws LocalCSSException {
        String localCSSHome = "";
        if (CSSInfo.isLocalCSSExist()) {
            try {
                localCSSHome = ClusterInfo.getLocalCSSHome((Version)new Version());
                if (localCSSHome == null || localCSSHome.trim().equals("")) {
                    localCSSHome = ClusterInfo.getLocalCSSHome((Version)Version.get92Version());
                }
            }
            catch (ClusterInfoException e) {
                logger.log(Level.WARNING, "Error while looking for Local CSS home.", e);
            }
        }
        return localCSSHome;
    }
}

