/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import oracle.install.asm.util.ASMInstance;
import oracle.install.asm.util.ASMUtility;
import oracle.install.asm.util.ASMUtilityException;
import oracle.install.commons.system.process.AbstractLineProcessor;
import oracle.install.commons.system.process.OutputProcessor;
import oracle.install.commons.system.process.ProcessLaunchInfo;
import oracle.install.commons.system.process.ProcessLauncher;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InstallHelper;
import oracle.install.library.util.PlatformInfo;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.oiipg.OiipgOracleHomes;
import oracle.sysman.oii.oiix.OiixClusterQueries;
import oracle.sysman.oii.oiix.OiixPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseInfo {
    public static final String NATIVE_LIB_PATH = System.getProperty("oracle.installer.scratchPath");
    private static final int RAC_SIDS_HOMES = 0;
    private static final int RAC_SIDS_NODELIST = 1;
    private static final String LOCAL_NODE = "localnode";
    public static final int DB_TYPE_RAC = 0;
    public static final int DB_TYPE_LOCAL_SI = 1;
    public static final int DB_TYPE_REMOTE_SI = 2;
    private boolean racDBInfoStored = false;
    HashMap<String, String> racDBSidsAndHomes;
    HashMap<String, String[]> racDBSidsAndNodeList;
    HashMap<String, String> localNodeSIDsAndHomes;
    HashMap<String, String> remoteNodesSIDsAndHomes;
    private static DatabaseInfo instance = null;

    protected DatabaseInfo() {
    }

    public static DatabaseInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (DatabaseInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(DatabaseInfo.class)) == null) {
            instance = new DatabaseInfo();
        }
        return instance;
    }

    public HashMap<String, String> getListOfSIDatabasesLocalNode() throws InstallException {
        HashMap<String, String> localSidsAndHomes = this.getSIDsAndHomesLocalNode();
        HashMap<String, String> racSidsAndHomes = this.getRACDBs();
        String[] asmSidsAndHomes = this.getASMSidAndHome();
        HashMap<String, String> SIDBMap = new HashMap<String, String>();
        if (localSidsAndHomes != null) {
            for (String sid : localSidsAndHomes.keySet()) {
                if (racSidsAndHomes != null && racSidsAndHomes.keySet().contains(sid) || asmSidsAndHomes != null && this.contains(asmSidsAndHomes, sid)) continue;
                SIDBMap.put(sid, localSidsAndHomes.get(sid));
            }
        }
        return SIDBMap;
    }

    public HashMap<String, String> getListOfSIDatabasesRemoteNode() throws InstallException {
        HashMap<String, String> remoteSidsAndHomes = this.getSIDsAndHomesRemoteNodes();
        HashMap<String, String> racSidsAndHomes = this.getRACDBs();
        String[] asmSidsAndHomes = this.getASMSidAndHome();
        HashMap<String, String> SIDBMap = new HashMap<String, String>();
        if (remoteSidsAndHomes != null) {
            for (String sid : remoteSidsAndHomes.keySet()) {
                if (racSidsAndHomes != null && racSidsAndHomes.keySet().contains(sid) || asmSidsAndHomes != null && this.contains(asmSidsAndHomes, sid)) continue;
                SIDBMap.put(sid, remoteSidsAndHomes.get(sid));
            }
        }
        return SIDBMap;
    }

    public String getOratabLocation() {
        return OiipgOracleHomes.getOratabLocation();
    }

    public boolean checkIfSIDAlreadyExists(String sid) throws InstallException {
        if (this.getSIDsAndHomesLocalNode() != null) {
            return this.getSIDsAndHomesLocalNode().containsKey(sid.toUpperCase());
        }
        return false;
    }

    public String getDefaultGlobalDBName() {
        PlatformInfo platInfo = PlatformInfo.getInstance();
        String domainName = "";
        if (platInfo.getFullHostName() != null || platInfo.getFullHostName().trim().length() != 0) {
            domainName = platInfo.getDomainName(platInfo.getFullHostName());
        }
        String gdbName = "";
        gdbName = domainName == null || domainName.trim().length() == 0 ? "orcl" : "orcl." + domainName;
        return gdbName;
    }

    private HashMap<String, String> getSIDsAndHomesLocalNode() throws InstallException {
        if (this.localNodeSIDsAndHomes == null || this.localNodeSIDsAndHomes.isEmpty()) {
            this.localNodeSIDsAndHomes = this.getSIDsAndHomes(LOCAL_NODE);
        }
        return this.localNodeSIDsAndHomes;
    }

    private HashMap<String, String> getRACDBs() throws InstallException {
        return this.getRACDBsInfo(0);
    }

    private HashMap<String, ?> getRACDBsInfo(int outputType) throws InstallException {
        String crshome = OiixClusterQueries.getCRSLocation();
        if (crshome == null) {
            return null;
        }
        ArrayList sids = new ArrayList();
        String argument = "config";
        char sep = File.separatorChar;
        if (!this.racDBInfoStored) {
            String WINSRVCTL = "srvctl.bat";
            String UNIXSRVCTL = "srvctl";
            this.racDBSidsAndHomes = new HashMap();
            this.racDBSidsAndNodeList = new HashMap();
            boolean isWindows = PlatformInfo.getInstance().isWindows();
            String commandPath = crshome + sep + "bin" + sep;
            String command = commandPath + UNIXSRVCTL;
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            if (isWindows) {
                command = commandPath + WINSRVCTL;
            } else {
                builder.environment().put("ORACLE_HOME", crshome);
            }
            try {
                builder.command(command, argument);
                SRVCTLSIDProcessor lineParse = new SRVCTLSIDProcessor();
                ProcessLaunchInfo pli = new ProcessLaunchInfo(builder, (OutputProcessor)lineParse, null);
                ProcessLauncher.launch((ProcessLaunchInfo)pli);
                sids = lineParse.sids;
            }
            catch (Exception e) {
                throw new InstallException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_DB_UNABLE_TO_GET_RAC_DB_INFO, new Object[0]);
            }
            for (int j = 0; j < sids.size(); ++j) {
                String sid = (String)sids.get(j);
                builder.command(command, argument, "database", "-d", sid);
                try {
                    builder.command().add(sid);
                    SRVCTLOutputProcessor lineParse = new SRVCTLOutputProcessor();
                    lineParse.sid = sid;
                    ProcessLauncher.launch((ProcessLaunchInfo)new ProcessLaunchInfo(builder, (OutputProcessor)lineParse, null));
                    continue;
                }
                catch (Exception e) {
                    throw new InstallException((Throwable)e, (ErrorCode)CommonErrorCode.INSTALL_DB_UNABLE_TO_GET_RAC_DB_INFO, new Object[0]);
                }
            }
            this.racDBInfoStored = true;
        }
        if (outputType == 1) {
            return this.racDBSidsAndNodeList;
        }
        return this.racDBSidsAndHomes;
    }

    private HashMap<String, String> getSIDsAndHomesRemoteNodes() throws InstallException {
        if (this.remoteNodesSIDsAndHomes == null || this.remoteNodesSIDsAndHomes.isEmpty()) {
            this.remoteNodesSIDsAndHomes = new HashMap();
            if (OiixClusterQueries.getCRSLocation() != null) {
                try {
                    ClusterInfo clusterInfo = new ClusterInfo(OiixClusterQueries.getCRSLocation());
                    String[] nodeNames = clusterInfo.getNodeNames();
                    if (nodeNames != null && nodeNames.length > 0) {
                        for (String node : nodeNames) {
                            if (node.equals(clusterInfo.getLocalNodeName())) continue;
                            HashMap<String, String> nodeSidsAndHomes = this.getSIDsAndHomes(node);
                            this.remoteNodesSIDsAndHomes.putAll(nodeSidsAndHomes);
                        }
                    }
                }
                catch (Exception noCrsEx) {
                    throw new InstallException((Throwable)noCrsEx, (ErrorCode)CommonErrorCode.INSTALL_DB_UNABLE_TO_GET_SID_HOME_REMOTE_NODES, new Object[0]);
                }
            }
        }
        return this.remoteNodesSIDsAndHomes;
    }

    private HashMap<String, String> getSIDsAndHomes(String nodeName) throws InstallException {
        HashMap<String, String> sidsAndHomesMap = new HashMap<String, String>();
        try {
            int curPlatId = OiixPlatform.getCurrentPlatform();
            int curPlatGroup = OiixPlatform.getPlatGroup((int)curPlatId);
            switch (curPlatGroup) {
                case -3: {
                    if (curPlatId == 615) break;
                    InstallHelper.Load(InstallHelper.getInstallBinariesPath(), "SID_Queries.dll");
                    String[] strarray = this.w32LocateSidHome();
                    if (strarray != null) {
                        for (int i = 0; i < strarray.length; ++i) {
                            String sid = strarray[i++];
                            String OH = strarray[i];
                            sidsAndHomesMap.put(sid, OH);
                        }
                    }
                    break;
                }
                case -1: {
                    String oratabLoc = OiipgOracleHomes.getOratabLocation();
                    File oratab = null;
                    if (nodeName == LOCAL_NODE) {
                        oratab = new File(oratabLoc);
                        if (!oratab.exists()) {
                            return null;
                        }
                    } else {
                        ClusterCmd clusterCmd = new ClusterCmd();
                        if (!clusterCmd.fileExists(nodeName, oratabLoc)) {
                            return null;
                        }
                        oratab = File.createTempFile("oratab_" + nodeName, "");
                        clusterCmd.copyFileFromNode(nodeName, oratabLoc, oratab.getAbsolutePath());
                        oratab.deleteOnExit();
                    }
                    FileInputStream fis = new FileInputStream(oratab);
                    InputStreamReader is = new InputStreamReader(fis);
                    BufferedReader bf = new BufferedReader(is);
                    String input = "";
                    int cols = 3;
                    while ((input = bf.readLine()) != null) {
                        if (input.startsWith("#") || input.startsWith("*") || input.trim().compareTo("") == 0) continue;
                        StringTokenizer tokenizer = new StringTokenizer(input, ":");
                        if (tokenizer.countTokens() < cols) {
                            System.err.print("Invalid oratab file: ");
                            System.err.println(oratabLoc);
                            return null;
                        }
                        String sid = tokenizer.nextToken();
                        String OH = tokenizer.nextToken();
                        sidsAndHomesMap.put(sid, OH);
                    }
                    break;
                }
            }
        }
        catch (Exception natexcept) {
            throw new InstallException((Throwable)natexcept, (ErrorCode)CommonErrorCode.INSTALL_DB_UNABLE_TO_GET_SID_HOME_ON_NODE, nodeName);
        }
        return sidsAndHomesMap;
    }

    public native String[] w32LocateSidHome() throws OiilNativeException;

    private boolean contains(String[] parent, String child) {
        for (String s : parent) {
            if (!s.equalsIgnoreCase(child)) continue;
            return true;
        }
        return false;
    }

    private String[] getASMSidAndHome() {
        try {
            ASMInstance asmInstance = ASMUtility.getInstance().getASMInstance();
            if (asmInstance != null) {
                return new String[]{asmInstance.getSid(), asmInstance.getOracleHome().getAbsolutePath()};
            }
        }
        catch (ASMUtilityException e) {
            ExceptionManager.handle((Throwable)((Object)e));
        }
        return null;
    }

    private class SRVCTLOutputProcessor
    extends AbstractLineProcessor {
        String sid;

        private SRVCTLOutputProcessor() {
        }

        public void processLine(String line, int lineNumber) {
            String[] tokens = line.split("\\s");
            int len = tokens.length;
            ArrayList<String> nodeList = new ArrayList<String>();
            String dbHome = null;
            if (len >= 3) {
                if (dbHome == null) {
                    dbHome = tokens[len - 1];
                }
                String nodeName = tokens[len - 3];
                nodeList.add(nodeName);
            }
            DatabaseInfo.this.racDBSidsAndHomes.put(this.sid, dbHome);
            String[] nodeListArray = new String[nodeList.size()];
            nodeList.toArray(nodeListArray);
            DatabaseInfo.this.racDBSidsAndNodeList.put(this.sid, nodeListArray);
        }
    }

    private class SRVCTLSIDProcessor
    extends AbstractLineProcessor {
        private ArrayList<String> sids = new ArrayList();

        SRVCTLSIDProcessor() {
            this.sids.clear();
        }

        public void processLine(String line, int lineNumber) {
            String[] tokens = line.split("\\s");
            if (tokens.length >= 1) {
                this.sids.add(tokens[0]);
            }
        }
    }
}

