/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.dhcp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;

public class LinuxDHCPImpl {
    public String checkIfStaticIPOnLinux(String interfaceName, String ipAddr, String linuxFlavor) throws Exception {
        String interfaceFile = "";
        String[][] pname = null;
        File interfaceFileObj = null;
        String result = "NOT EXECUTED";
        try {
            if (linuxFlavor.equalsIgnoreCase("redhat") || linuxFlavor.equalsIgnoreCase("mandrake") || linuxFlavor.equalsIgnoreCase("fedora")) {
                pname = new String[1][3];
                pname[0][0] = "BOOTPROTO";
                pname[0][1] = "S|static|none|bootp";
                pname[0][2] = "F|dhcp";
                interfaceFile = "/etc/sysconfig/network-scripts/ifcfg-" + interfaceName;
                interfaceFileObj = new File(interfaceFile);
                if (!interfaceFileObj.exists()) {
                    interfaceFile = "/etc/sysconfig/nic-config/ifcfg-" + interfaceName;
                    if (!interfaceFileObj.exists()) {
                        return "NOT EXECUTED";
                    }
                }
            } else if (linuxFlavor.equalsIgnoreCase("suse")) {
                interfaceFile = "/etc/rc.config";
                interfaceFileObj = new File(interfaceFile);
                if (!interfaceFileObj.exists()) {
                    return "NOT EXECUTED";
                }
                int interfaceIndex = LinuxDHCPImpl.getSuseInterfaceIndex(interfaceFileObj, interfaceName);
                if (interfaceIndex == -1) {
                    return "NOT EXECUTED";
                }
                pname = new String[1][3];
                pname[0][0] = "IFCONFIG_" + interfaceIndex;
                pname[0][1] = "F|\"dhcpclient\"";
                pname[0][2] = "S|";
            }
            if (interfaceFileObj == null) {
                return "NOT EXECUTED";
            }
            if (!interfaceFileObj.canRead()) {
                return "SUCCESS";
            }
            int successCounter = 0;
            for (int i = 0; i < pname.length; ++i) {
                String res = LinuxDHCPImpl.parseFile(linuxFlavor, pname[i], interfaceFileObj);
                if (res.equals("SUCCESS")) {
                    ++successCounter;
                    continue;
                }
                if (!res.equals("FAILURE")) continue;
                successCounter = -1;
                break;
            }
            if (successCounter == pname.length) {
                return "SUCCESS";
            }
            if (successCounter == -1) {
                return "FAILURE";
            }
            if (successCounter != pname.length) {
                return "NOT EXECUTED";
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            throw e;
        }
        return result;
    }

    private static String parseFile(String linuxFlavor, String[] pname, File interfaceFileObj) throws Exception {
        BufferedReader br = null;
        String result = "NOT EXECUTED";
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(interfaceFileObj)));
            OiiolTextLogger.appendText((String)("Inspect interface file :" + interfaceFileObj));
            String line = null;
            while ((line = br.readLine()) != null) {
                int indexVal = line.indexOf("=");
                if (indexVal == -1 || indexVal != line.lastIndexOf("=")) continue;
                String name = line.substring(0, indexVal);
                name = name != null ? name : "";
                name = name.trim();
                String value = line.substring(indexVal + 1);
                value = value != null ? value : "";
                value = value.trim();
                if (name.length() == 0 || !name.equalsIgnoreCase(pname[0])) continue;
                result = LinuxDHCPImpl.checkParams(value, pname[1], "");
                if (result.equalsIgnoreCase("NOT_EXECUTED")) {
                    result = LinuxDHCPImpl.checkParams(value, pname[2], "NE");
                    continue;
                }
                break;
            }
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        return result;
    }

    private static String checkParams(String value, String pname, String initialResult) throws Exception {
        String result = "NOT_EXECUTED";
        StringTokenizer st = new StringTokenizer(pname, "|");
        String curToken = st.nextToken();
        if (curToken.equalsIgnoreCase("S")) {
            String nextToken = null;
            while (st.hasMoreTokens()) {
                nextToken = st.nextToken();
                if (value.length() == 0 || !value.equalsIgnoreCase(nextToken)) continue;
                result = "SUCCESS";
                break;
            }
        } else if (curToken.equalsIgnoreCase("F")) {
            String nextToken = null;
            while (st.hasMoreTokens()) {
                nextToken = st.nextToken();
                if (value.length() != 0 && value.equalsIgnoreCase(nextToken)) {
                    result = "FAILURE";
                } else {
                    if (value.length() == 0 || value.equalsIgnoreCase(nextToken)) continue;
                    if (initialResult.equalsIgnoreCase("NE")) {
                        return result;
                    }
                    result = "SUCCESS";
                }
                break;
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getSuseInterfaceIndex(File interfaceFileObj, String interfaceName) throws Exception {
        BufferedReader br = null;
        int numberOfInterfaces = 0;
        int interfaceIndex = -1;
        try {
            String value;
            String name;
            int indexVal;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(interfaceFileObj)));
            OiiolTextLogger.appendText((String)("Inspect Suse Interface File:" + interfaceFileObj));
            String line = null;
            while ((line = br.readLine()) != null) {
                indexVal = line.indexOf("=");
                if (indexVal == -1 || indexVal != line.lastIndexOf("=")) continue;
                name = line.substring(0, indexVal);
                String string = name = name != null ? name : "";
                if ((name = name.trim()).length() == 0 || !name.equalsIgnoreCase("NETCONFIG")) continue;
                value = line.substring(indexVal + 1);
                value = value != null ? value : "";
                if ((value = value.trim()).length() == 0) {
                    interfaceIndex = -1;
                    break;
                }
                for (int i = 0; i < value.length(); ++i) {
                    if (value.charAt(i) != '_') continue;
                    ++numberOfInterfaces;
                }
            }
            br = null;
            OiiolTextLogger.appendText((String)("Number of interfaces:" + numberOfInterfaces));
            if (numberOfInterfaces == 0) return interfaceIndex;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(interfaceFileObj)));
            while ((line = br.readLine()) != null) {
                indexVal = line.indexOf("=");
                if (indexVal == -1 || indexVal != line.lastIndexOf("=")) continue;
                name = line.substring(0, indexVal);
                String string = name = name != null ? name : "";
                if ((name = name.trim()).length() == 0 || !name.startsWith("NETDEV_")) continue;
                value = line.substring(indexVal + 1);
                value = value != null ? value : "";
                if (!(value = value.trim()).equalsIgnoreCase("\"" + interfaceName + "\"") && !value.equalsIgnoreCase(interfaceName)) continue;
                String str = name.substring(name.lastIndexOf(95) + 1);
                try {
                    interfaceIndex = Integer.parseInt(str);
                    return interfaceIndex;
                }
                catch (NumberFormatException nfe) {
                    throw nfe;
                    return interfaceIndex;
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        InetAddress inet = InetAddress.getLocalHost();
        System.out.println("inet Address:" + inet);
        String fullyQualifiedIP = inet.getHostAddress();
        System.out.println("fullyQualifiedIP:" + fullyQualifiedIP);
        inet = InetAddress.getByName(fullyQualifiedIP);
        System.out.println("new inet:" + inet);
        String ipaddr = inet.getHostAddress();
        NetworkInterface nwiObj = NetworkInterface.getByInetAddress(inet);
        System.out.println("NETWORK INTERFACE name :" + nwiObj.getName());
        String bindingInterfaceDesc = nwiObj.getDisplayName();
        String bindingInterfaceName = nwiObj.getName();
        System.out.println("NETWORK INTERFACE DISPLAY name :" + bindingInterfaceDesc);
        System.out.println("NETWORK INTERFACE name :" + bindingInterfaceName);
        System.out.println("RESULT:" + new LinuxDHCPImpl().checkIfStaticIPOnLinux(bindingInterfaceName, ipaddr, "suse"));
    }
}

