/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.em;

import java.util.logging.Logger;
import oracle.install.library.em.Connect;

public class SMTPConnectionCheck {
    public static final Logger logger = Logger.getLogger(SMTPConnectionCheck.class.getName());
    public static int UNKNOWN_ERROR = -1;
    public static int NO_ERROR = 0;
    public static int UNKNOWN_HOST = 1;
    public static int CONNECTION_REFUSED = 2;
    public static int CONNECTION_TIMED_OUT = 3;

    public static int testGateWay(String gateway) {
        if (gateway == null) {
            return -1;
        }
        return SMTPConnectionCheck.testPort(gateway, 25, 20);
    }

    public static int testPort(String host, int port, int timeout) {
        try {
            Connect c = new Connect(host, port);
            Thread t = new Thread(c);
            t.setName("notificationTcpTest");
            t.start();
            for (int i = 0; i < timeout; ++i) {
                try {
                    Thread.sleep(1000L);
                    if (!c.isFinished()) continue;
                    if (c.wasSuccessful()) {
                        return NO_ERROR;
                    }
                    return c.getError();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (!c.isFinished()) {
                t.interrupt();
                return CONNECTION_TIMED_OUT;
            }
            return c.getError();
        }
        catch (Exception e) {
            return UNKNOWN_ERROR;
        }
    }
}

