/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.UncheckedException;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.CompatibilityMatrix;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.RemoteDirException;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;

public class FileInfo {
    private static final Logger logger = Logger.getLogger(CompatibilityMatrix.class.getName());
    private OiipgFileSystem fileSystem = new OiipgFileSystem();
    private static FileInfo instance;

    protected FileInfo() {
    }

    public static FileInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (FileInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(FileInfo.class)) == null) {
            instance = new FileInfo();
        }
        return instance;
    }

    public boolean areLocsSame(String sNatUserHomeLoc, String sNatLoc) {
        return this.fileSystem.areLocsSame(sNatUserHomeLoc, sNatLoc);
    }

    public boolean isRemoteDirWriatble(String node, String dir) {
        try {
            ClusterCmd cc = new ClusterCmd();
            return cc.isDirWritable(node, dir);
        }
        catch (ClusterException ce) {
            ce.printStackTrace();
            logger.severe("occured while checking permissions for " + dir + "on host " + node);
            return false;
        }
    }

    public boolean doesRemoteDirExist(String node, String dir) {
        try {
            ClusterCmd cc = new ClusterCmd();
            return cc.dirExists(node, dir);
        }
        catch (RemoteDirException re) {
            logger.log(Level.WARNING, String.format("Failed while checking for %s directory existance on remote node %s using SRVM API.", dir, node), re);
            throw new UncheckedException((Throwable)re, (ErrorCode)CommonErrorCode.UNEXPECTED_REMOTE_DIR_CHECK_FAILURE, new Object[]{dir, node});
        }
    }

    public static String getLastExistingParent(String inputPath) {
        File f = new File(inputPath);
        if (f.exists() && f.isDirectory()) {
            return inputPath;
        }
        return FileInfo.getLastExistingParent(f.getParent().toString());
    }

    public String getLastExistingRemoteParent(String node, String location) {
        boolean fileExists = false;
        String dirToCheck = location;
        while (!fileExists) {
            fileExists = this.doesRemoteDirExist(node, dirToCheck);
            if (fileExists) continue;
            if (dirToCheck.lastIndexOf(File.separatorChar) == 0) {
                dirToCheck = File.separator;
                continue;
            }
            dirToCheck = dirToCheck.substring(0, dirToCheck.lastIndexOf(File.separatorChar));
        }
        return dirToCheck;
    }
}

