/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.ClusterVerification;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationResultSet;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.etc.UnhandledDriverException;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.asm.ACFSUtil;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.MachineInfo;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixGeneralQueries;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemInfo {
    private static FileSystemInfo instance = null;
    private static Logger logger = Logger.getLogger(FileSystemInfo.class.getName());
    private String localNode = null;

    protected FileSystemInfo() {
    }

    public static FileSystemInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (FileSystemInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(FileSystemInfo.class)) == null) {
            instance = new FileSystemInfo();
        }
        return instance;
    }

    public boolean isLocationOnACFS(String mountPoint) throws InstallException {
        return ACFSUtil.getInstance().isPathOnACFS(mountPoint);
    }

    public boolean isLocationOnCFS(String oraclehome, List<String> nodeList) throws InstallException {
        if (this.localNode == null) {
            for (String node : nodeList) {
                if (!MachineInfo.getInstance().isLocalHost(node)) continue;
                this.localNode = node;
            }
        }
        if (this.localNode == null) {
            throw new InstallException((ErrorCode)oracle.install.library.resource.CommonErrorCode.INSTALL_COMMON_UNABLE_TO_CHECK_WHETHER_OH_ON_CFS, new Object[0]);
        }
        String[] nodeListArray = new String[nodeList.size()];
        nodeList.toArray(nodeListArray);
        try {
            if (Cluster.isSharedPath((String)oraclehome, (String[])nodeListArray, (String)this.localNode)) {
                return true;
            }
        }
        catch (Exception e) {
            throw new InstallException((Throwable)e, (ErrorCode)oracle.install.library.resource.CommonErrorCode.INSTALL_COMMON_UNABLE_TO_CHECK_WHETHER_OH_ON_CFS, new Object[0]);
        }
        return false;
    }

    public Integer getFreeSpace(String localDirPath, Boolean val) {
        return OiixGeneralQueries.getFreeSpaceux((String)localDirPath, (Boolean)val);
    }

    public boolean isDirWritable(String dirPath) {
        return OiixFunctionOps.writablePath((String)dirPath);
    }

    public ErrorMessage checkFreeDiskSpace(String[] nodes, String path, long requiredSizeInMegaBytes) {
        if (!DriverHelper.isCVUOperationEnabled((String)"oracle.install.cvu.checkSpaceAvailability")) {
            return null;
        }
        VerificationResultSet cvuResult = null;
        try {
            path = this.getLongestValidPathAcrossNodes(nodes, path);
            cvuResult = ClusterVerification.getInstance().checkSpaceAvailability(nodes, path, requiredSizeInMegaBytes, StorageUnit.MBYTE);
        }
        catch (Exception e) {
            return new ValidationStatusMessage((Throwable)new UnhandledDriverException((Throwable)e, (ErrorCode)oracle.install.library.resource.CommonErrorCode.FREE_SPACE_CHECK_FAILED, new Object[0]));
        }
        if (cvuResult == null) {
            return new ValidationStatusMessage((Throwable)new UnhandledDriverException((ErrorCode)oracle.install.library.resource.CommonErrorCode.FREE_SPACE_CHECK_FAILED, new Object[0]));
        }
        if (cvuResult.getOverallStatus() == OverallStatus.OPERATION_FAILED) {
            logger.log(Level.WARNING, "ClusterVerification::checkFreeDiskSpace returned OPERATION_FAILED");
            return new ValidationStatusMessage((Throwable)new UnhandledDriverException((ErrorCode)oracle.install.library.resource.CommonErrorCode.FREE_SPACE_CHECK_FAILED, new Object[0]));
        }
        if (cvuResult.getFailedNodes().size() > 0) {
            return new ValidationStatusMessage((Throwable)new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_MIN_FREE_DISK_SPACE_ERR, new Object[]{requiredSizeInMegaBytes, cvuResult.getFailedNodes()}));
        }
        return null;
    }

    public String getLongestValidPathAcrossNodes(String[] nodes, String path) throws Exception, ClusterException {
        if (nodes == null || path == null || nodes.length == 0 || path.trim().length() == 0) {
            throw new Exception();
        }
        ClusterCmd cCmdObj = new ClusterCmd();
        ArrayList<String> listOfValidPathOnEachNode = new ArrayList<String>(nodes.length);
        int i = 0;
        for (String node : nodes) {
            File fileObj = new File(path);
            while (!cCmdObj.dirExists(node, fileObj.getPath())) {
                fileObj = fileObj.getParentFile();
            }
            if (!cCmdObj.isDirWritable(node, fileObj.getPath())) {
                throw new Exception();
            }
            listOfValidPathOnEachNode.add(i, fileObj.getPath());
            ++i;
        }
        String shortestPath = (String)listOfValidPathOnEachNode.get(0);
        for (i = 1; i < listOfValidPathOnEachNode.size(); ++i) {
            if (((String)listOfValidPathOnEachNode.get(i)).length() >= shortestPath.length()) continue;
            shortestPath = (String)listOfValidPathOnEachNode.get(i);
        }
        return shortestPath;
    }

    public String getLocationWithMaxFreespace(List<String> locs) {
        int i;
        String selectedLoc = null;
        long maxMBSizeTillNow = 0L;
        ArrayList<String> listOfValidPaths = new ArrayList<String>();
        for (i = 0; i < locs.size(); ++i) {
            if (locs.get(i) == null || locs.get(i).trim().length() <= 0) continue;
            listOfValidPaths.add(locs.get(i));
        }
        if (listOfValidPaths.size() > 0) {
            selectedLoc = locs.get(0);
            maxMBSizeTillNow = this.getFreeSpace(selectedLoc, true).intValue();
            for (i = 1; i < listOfValidPaths.size(); ++i) {
                long sizeval = this.getFreeSpace((String)listOfValidPaths.get(i), true).intValue();
                if (sizeval <= maxMBSizeTillNow) continue;
                selectedLoc = (String)listOfValidPaths.get(i);
                maxMBSizeTillNow = sizeval;
            }
        }
        return selectedLoc;
    }
}

