/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.library.util.InstallException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.sysman.oii.oiix.OiixNetOps;

public class MachineInfo {
    private static final Logger logger = Logger.getLogger(MachineInfo.class.getName());
    private static MachineInfo instance = null;

    protected MachineInfo() {
    }

    public static MachineInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (MachineInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(MachineInfo.class)) == null) {
            instance = new MachineInfo();
        }
        return instance;
    }

    public String getDomainName(String strHostName) throws UnknownHostException {
        String ipAddress = this.getIPAddressForHostName(strHostName);
        String fullHostName = this.getHostNameForIPAddress(ipAddress);
        String domainName = OiixNetOps.getDomainName((String)fullHostName);
        return domainName;
    }

    public String getFullQualifiedHostName(String hostName) {
        String fqnName = hostName;
        if (hostName != null && hostName.indexOf(46) == -1) {
            try {
                String domainName = MachineInfo.getInstance().getDomainName(hostName);
                if (domainName != null && domainName.length() > 0) {
                    fqnName = hostName + "." + domainName;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to retrieve the full host name");
            }
        }
        return fqnName;
    }

    public String getFullHostName() {
        SetupDriver setupDriver = SetupDriver.getInstance();
        Properties clArgs = setupDriver.getCommandLineArgs();
        String sOracleHostname = null;
        if (clArgs != null && (sOracleHostname = clArgs.getProperty("oracle_hostname")) != null) {
            return sOracleHostname;
        }
        return OiixNetOps.getFullHostName();
    }

    public String getDefPubName(String strNode) {
        return strNode;
    }

    public String getDefVIPName(String strNode) {
        int iIndex = strNode.indexOf(".");
        String strVIP = iIndex != -1 ? strNode.substring(0, iIndex) + "-vip" + strNode.substring(iIndex) : strNode + "-vip";
        return strVIP;
    }

    public String getMachineName(String strNode) {
        return OiixNetOps.getMachineName((String)strNode);
    }

    public String getHostIPAddress() {
        return OiixNetOps.getHostIPAddress();
    }

    public String getHostNameForIPAddress(String ipAddress) throws UnknownHostException {
        return OiixNetOps.getHostNameForIPAddress((String)ipAddress);
    }

    public String getIPAddressForHostName(String hostName) throws UnknownHostException {
        return OiixNetOps.getIPAddressForHostName((String)hostName);
    }

    public String[] getAllHostNames() {
        return OiixNetOps.getAllHostNames();
    }

    public String[] getAllIPAddressesForHostName(String hostName) throws UnknownHostException {
        return OiixNetOps.getAllIPAddressesForHostName((String)hostName);
    }

    public boolean isLocalHost(String hostName) {
        boolean localHost = false;
        try {
            InetAddress[] addresses = InetAddress.getAllByName(hostName);
            for (int i = 0; i < addresses.length; ++i) {
                NetworkInterface networkInterface = NetworkInterface.getByInetAddress(addresses[i]);
                if (networkInterface == null) continue;
                localHost = true;
                break;
            }
        }
        catch (UnknownHostException e) {
            logger.log(Level.FINE, "Unknown Host: {0}. Error: {1}", new Object[]{hostName, e.getMessage()});
        }
        catch (SocketException e) {
            logger.log(Level.FINE, "Invalid Host: {0}. Error: {1}", new Object[]{hostName, e.getMessage()});
        }
        return localHost;
    }

    public String getDomainName() {
        String domain = null;
        try {
            String host = this.getFullHostName();
            domain = this.getDomainName(host);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return domain;
    }

    public boolean isLocalPortAvailable(int iPortNumber) {
        String[] strNode = new String[]{this.getHostIPAddress()};
        try {
            return Cluster.isPortAvailable((String[])strNode, (int)iPortNumber);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getFreePort(int minPort, int maxPort) {
        for (int i = minPort; i <= maxPort; ++i) {
            if (!this.isLocalPortAvailable(i)) continue;
            return String.valueOf(i);
        }
        return null;
    }

    public boolean isIPv4InterfacePresent() throws InstallException {
        try {
            Enumeration<NetworkInterface> enumInterfaces = NetworkInterface.getNetworkInterfaces();
            ArrayList<NetworkInterface> arrInterfaces = new ArrayList<NetworkInterface>();
            while (enumInterfaces.hasMoreElements()) {
                arrInterfaces.add(enumInterfaces.nextElement());
            }
            for (NetworkInterface oInterface : arrInterfaces) {
                if (oInterface.equals(NetworkInterface.getByInetAddress(InetAddress.getByName(null)))) continue;
                Enumeration<InetAddress> enumInetAddress = oInterface.getInetAddresses();
                ArrayList<InetAddress> arrInetAddress = new ArrayList<InetAddress>();
                while (enumInetAddress.hasMoreElements()) {
                    arrInetAddress.add(enumInetAddress.nextElement());
                }
                for (InetAddress oInetAddress : arrInetAddress) {
                    if (oInetAddress instanceof Inet4Address) {
                        logger.info(oInetAddress.getHostAddress() + " is ipv4\n");
                        return true;
                    }
                    if (!(oInetAddress instanceof Inet6Address) || !((Inet6Address)oInetAddress).isIPv4CompatibleAddress()) continue;
                    logger.info(oInetAddress.getHostAddress() + " is ipv4 compatible\n");
                    return true;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            throw new InstallException(e);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new InstallException(e);
        }
        return false;
    }

    public static void main(String[] args) {
    }
}

