/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import oracle.install.library.util.MachineInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
implements Comparable<Node> {
    private String hostname;
    private boolean localNode;

    public Node() {
    }

    public Node(String hostname) {
        this.hostname = hostname;
    }

    public boolean isLocalNode() {
        return this.localNode;
    }

    public void setLocalNode(boolean localNode) {
        this.localNode = localNode;
    }

    public String getName() {
        return this.hostname;
    }

    public String getName(boolean fqn) {
        return Node.getHostName(this.hostname, fqn);
    }

    public void setName(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public int compareTo(Node o) {
        return this.hostname.compareTo(o.hostname);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        Node node = (Node)obj;
        if (node != null) {
            if (this.isLocalNode() && node.isLocalNode()) {
                result = true;
            } else {
                String nodeName1 = this.hostname;
                String nodeName2 = node.hostname;
                int index1 = nodeName1.indexOf(".");
                int index2 = nodeName2.indexOf(".");
                String shortName1 = nodeName1;
                String shortName2 = nodeName2;
                if (index1 > 0) {
                    shortName1 = nodeName1.substring(0, index1);
                }
                if (index2 > 0) {
                    shortName2 = nodeName2.substring(0, index2);
                }
                result = nodeName1.equals(nodeName2) || shortName1.equals(shortName2);
            }
        }
        return result;
    }

    public static String getHostName(String hostName, boolean fqn) {
        if (hostName != null && hostName.trim().length() > 0) {
            hostName = hostName.trim();
            int dotIndex = hostName.indexOf(46);
            if (fqn) {
                if (dotIndex == -1) {
                    hostName = MachineInfo.getInstance().getFullQualifiedHostName(hostName);
                }
            } else if (dotIndex != -1) {
                hostName = hostName.substring(0, dotIndex);
            }
        }
        return hostName;
    }
}

