/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.util.ArrayList;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;

public class NodeValidation {
    public static final String UNKNOWN_HOST = "ping: unknown host ";
    public static final String SUCC_MSG = "SUCCESS";
    public static final String ERROR_SINGLE_NODE = "FAILURE";
    public static final String ERROR_MULTIPLE_NODES = "ERROR";

    public static String[] checkLiveliness(String[] nodeList, int timeout) {
        ArrayList<String> RetMsg;
        block8: {
            ArrayList<String> upNodes = new ArrayList<String>();
            ArrayList<String> errNodes = new ArrayList<String>();
            RetMsg = new ArrayList<String>();
            String CurrNode = "";
            boolean flag = false;
            try {
                ClusterCmd Ccmd = new ClusterCmd();
                flag = Ccmd.areNodesAlive(nodeList, timeout, null);
                if (!flag) break block8;
                RetMsg.add(SUCC_MSG);
            }
            catch (ClusterException ce) {
                RetMsg.add(ERROR_SINGLE_NODE);
            }
            catch (RemoteFileOperationException rfoe) {
                int i;
                RetMsg.add(ERROR_MULTIPLE_NODES);
                for (i = 0; i < nodeList.length; ++i) {
                    CurrNode = nodeList[i];
                    try {
                        int status = rfoe.getStatus(CurrNode);
                        if (status == 0) {
                            flag = true;
                            upNodes.add(CurrNode);
                        }
                        if (status != 1 && status != 2) continue;
                        errNodes.add(CurrNode);
                        continue;
                    }
                    catch (NoSuchNodeException nsne) {
                        flag = false;
                        RetMsg.add(UNKNOWN_HOST);
                    }
                }
                int DownNodeSz = errNodes.size();
                if (DownNodeSz <= 0) break block8;
                for (i = 0; i < DownNodeSz; ++i) {
                    RetMsg.add((String)errNodes.get(i));
                }
            }
        }
        String[] RetAry = RetMsg.toArray(new String[RetMsg.size()]);
        return RetAry;
    }
}

