/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.ivw.common.bean.Language;
import oracle.install.library.resource.CommonErrorCode;
import oracle.sysman.oii.oiic.OiicInstallSession;
import oracle.sysman.oii.oiic.OiicInstaller;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductInfo {
    private static ProductInfo instance = null;
    private static final String STARTUP_LOCATION = System.getProperty("oracle.installer.startup_location");
    private static final String sep = File.separator;
    private static final String PRODUCTS_XML = "products.xml";
    private static final String INSTALL_JAR = "install{0}.jar";
    private static final String productsXML = System.getProperty("oracle.installer.sourceLoc");
    private static final Logger logger = Logger.getLogger(ProductInfo.class.getName());
    private String m_TopLevel = null;
    private Properties langProps;
    public Set<Language> supportedLanguages = null;
    public static final String PRODUCTLANGUAGES_PROPERTIES_LOCATION = System.getProperty("oracle.installer.startup_location") + "/../stage/productlanguages.properties";

    protected ProductInfo() {
    }

    public static ProductInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (ProductInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(ProductInfo.class)) == null) {
            instance = new ProductInfo();
        }
        return instance;
    }

    public void loadPropertiesFileForLang() {
        if (this.langProps != null) {
            return;
        }
        try {
            File langFile = new File(PRODUCTLANGUAGES_PROPERTIES_LOCATION);
            if (langFile.exists()) {
                FileInputStream fileStream = new FileInputStream(langFile);
                this.langProps = new Properties();
                this.langProps.load(fileStream);
                fileStream.close();
            }
        }
        catch (Exception e) {
            ExceptionManager.handle((Throwable)e);
        }
    }

    public String getShiphomeTopLevelComponent() {
        if (this.m_TopLevel != null) {
            return this.m_TopLevel;
        }
        this.loadPropertiesFileForLang();
        Enumeration<Object> enume = this.langProps.keys();
        if (enume.hasMoreElements()) {
            String key = enume.nextElement().toString();
            this.m_TopLevel = key.substring(0, key.indexOf("_lang"));
        }
        return this.m_TopLevel;
    }

    public Set<Language> getSupportedLanguages() {
        if (this.supportedLanguages == null) {
            this.supportedLanguages = new TreeSet<Language>();
            this.loadPropertiesFileForLang();
            String value = null;
            Enumeration<Object> enume = this.langProps.keys();
            if (enume.hasMoreElements()) {
                String key = enume.nextElement().toString();
                value = this.langProps.getProperty(key);
            }
            String[] langs = null;
            if (value != null) {
                langs = value.split("\\s");
            }
            if (langs != null) {
                for (String lang : langs) {
                    String name = OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)("S_LANGUAGE_" + lang));
                    Language language = new Language(lang, name);
                    this.supportedLanguages.add(language);
                }
            }
        }
        return this.supportedLanguages;
    }

    public String copyProductsXMLtoScratch() {
        String SCRATCH_PATH = System.getProperty("oracle.installer.scratchPath");
        String dest_dir = SCRATCH_PATH + sep + "products";
        String source_dir = new File(productsXML).getParent();
        new File(dest_dir).mkdir();
        String products_file = dest_dir + sep + PRODUCTS_XML;
        this.copyOnCondition(productsXML, products_file);
        int i = 1;
        String thisJar = MessageFormat.format(INSTALL_JAR, i);
        while (new File(source_dir + sep + thisJar).exists()) {
            String source_file = source_dir + sep + thisJar;
            String dest_file = dest_dir + sep + thisJar;
            this.copyOnCondition(source_file, dest_file);
            thisJar = MessageFormat.format(INSTALL_JAR, ++i);
        }
        return products_file;
    }

    protected void copyOnCondition(String source_file, String dest_file) {
        try {
            if (!new File(dest_file).exists()) {
                logger.finest("Copying file " + source_file + " into " + dest_file);
                OiixFileOps.copyFile((String)new File(source_file).getCanonicalPath(), (String)dest_file, (boolean)true, (boolean)true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.severe("unable to copy " + source_file + " to " + dest_file);
        }
    }

    public String getProductVersion(String ohLoc, String name) throws Exception {
        Vector compEntries;
        OiicInstallSession installSession = null;
        OiicInstaller installer = OiicInstaller.getHandleToOiicInstaller();
        if (installer != null) {
            try {
                installSession = new OiicInstallSession(installer);
            }
            catch (OiifbEndIterateException e) {
                String errorCode = CommonErrorCode.INSTALL_COMMON_CREATE_INSTALL_SESSION_EXCEPTION.name();
                String localizedMsg = Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.library.resource.CommonErrorResID", (String)errorCode), new Object[0]);
                throw new Exception(localizedMsg, e);
            }
        }
        name = name.trim();
        if (ohLoc != null) {
            ohLoc = ohLoc.trim();
            ohLoc = OiixPathOps.getNativeForm((String)ohLoc);
        }
        if (!new File(ohLoc).exists()) {
            String errorCode = CommonErrorCode.INSTALL_COMMON_HOME_NOT_FOUND_EXCEPTION.name();
            String exName = Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.library.resource.CommonErrorResID", (String)errorCode), new Object[0]);
            throw new Exception(exName);
        }
        OiiiInstallAreaControl instArea = (OiiiInstallAreaControl)OiiiInstallAreaControl.getInventoryAreaControl();
        OiiiInstallInventory areaInv = instArea.getInstallInventory();
        OiiiVersion oVersion = null;
        if (ohLoc != null) {
            Vector ohList = areaInv.getHomes();
            int index = OiiiOracleHomeInfo.getOHIndex((Vector)ohList, (String)ohLoc);
            if (index == -1) {
                String errorCode = CommonErrorCode.INSTALL_COMMON_HOME_NOT_FOUND_EXCEPTION.name();
                String exName = Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.library.resource.CommonErrorResID", (String)errorCode), new Object[0]);
                throw new Exception(exName);
            }
            compEntries = areaInv.getCompInvEntries(name, index);
        } else {
            int nAppltopIndex;
            int nOhIndex = installSession.getOHIndex();
            compEntries = areaInv.getCompInvEntries(name, nOhIndex);
            if (compEntries.size() == 0 && (nAppltopIndex = installSession.getAppltopIndex()) != 0) {
                compEntries = areaInv.getCompInvEntries(name, nAppltopIndex);
            }
        }
        if (compEntries.size() == 0) {
            String[] variables = new String[1];
            String[] values = new String[1];
            variables[0] = new String("%1%");
            values[0] = new String(name);
            String errorCode = CommonErrorCode.INSTALL_COMMON_PRODUCT_NOT_FOUND_EXCEPTION.name();
            String exName = Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.library.resource.CommonErrorResID", (String)errorCode), new Object[0]);
            throw new Exception(exName);
        }
        if (compEntries.size() != 1) {
            int nSize = compEntries.size();
            int nComps = 0;
            for (int i = 0; i < nSize; ++i) {
                OiiiCompInvEntry cie = (OiiiCompInvEntry)compEntries.elementAt(i);
                OiiiCompInstallID id = cie.getCompInstallID();
                if (id.getCompType() == 1 && ++nComps > 1) {
                    String[] variables = new String[1];
                    String[] values = new String[1];
                    variables[0] = new String("%1%");
                    values[0] = new String(name);
                    String errorCode = CommonErrorCode.INSTALL_COMMON_MULTIPLE_VERSIONS_FOUND_EXCEPTION.name();
                    String exName = Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.library.resource.CommonErrorResID", (String)errorCode), new Object[0]);
                    throw new Exception(exName);
                }
                if (oVersion != null && !cie.getVersion().laterThan(oVersion)) continue;
                oVersion = id.getVersion();
            }
        }
        if (oVersion == null) {
            OiiiCompInvEntry entry = (OiiiCompInvEntry)compEntries.elementAt(0);
            oVersion = entry.getVersion();
        }
        return oVersion.getVerString();
    }
}

