/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.File;
import java.io.FileInputStream;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.driver.oui.ShiphomeMetadata;
import oracle.install.library.util.PlatformInfo;

public class StageSizeInfo {
    private static final String SEP = File.separator;
    private static final String SIZE_SUFFIX = ".sizes.properties";
    private static final Logger logger = Logger.getLogger(StageSizeInfo.class.getName());
    public static final double UNIT = 1024.0;
    public static final double KB = 1024.0;
    public static final double MB = 1048576.0;
    public static final double GB = 1.073741824E9;
    public static final String SIZE_LOCATION = System.getProperty("oracle.installer.startup_location") + "/../stage/sizes";
    public static final int PLATID = PlatformInfo.getInstance().getCurrentPlatform();
    private static final String KEY_ALL_LANG = "ALL_LANGUAGES_" + PLATID;
    private static String[] propertyFiles;

    protected StageSizeInfo() {
    }

    private static String getPropertiesFile(String installType) {
        if (propertyFiles == null) {
            StageSizeInfo.populatePropertyFiles();
        }
        String propsFile = "";
        for (int i = 0; i < propertyFiles.length; ++i) {
            String installSuffix = installType + SIZE_SUFFIX;
            if (!propertyFiles[i].endsWith(installSuffix)) continue;
            propsFile = SIZE_LOCATION + SEP + propertyFiles[i];
            break;
        }
        return propsFile;
    }

    private static void populatePropertyFiles() {
        propertyFiles = new File(SIZE_LOCATION).list();
    }

    public static String getReadableSize(double size) {
        double floatValue = size;
        String suffix = "MB";
        if (size > 1024.0) {
            suffix = "GB";
            floatValue = (float)(size / 1024.0);
        }
        DecimalFormat df = new DecimalFormat(".##");
        return df.format(floatValue) + suffix;
    }

    public static String getSizeString(String installType, boolean considerOracleHomeOffset) {
        return StageSizeInfo.getReadableSize(StageSizeInfo.getSize(installType, considerOracleHomeOffset));
    }

    public static String getSizeString(String installType) {
        return StageSizeInfo.getReadableSize(StageSizeInfo.getSize(installType, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSize(String installType, boolean considerOracleHomeOffset) {
        double retVal = 0.0;
        FileInputStream fis = null;
        try {
            long oracleHomeOffsetSize;
            File propsFile = new File(StageSizeInfo.getPropertiesFile(installType));
            fis = new FileInputStream(propsFile);
            Properties sizes = new Properties();
            sizes.load(fis);
            retVal = (double)Long.parseLong(sizes.getProperty(KEY_ALL_LANG)) / 1048576.0;
            if (considerOracleHomeOffset && (oracleHomeOffsetSize = StageSizeInfo.getOracleHomeOffsetSize()) != 0L) {
                retVal += (double)oracleHomeOffsetSize;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "occured while trying to estimate size" + e);
            e.printStackTrace();
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "occured while closing FOS in StageSizeInfo" + ex);
                ex.printStackTrace();
            }
        }
        logger.log(Level.INFO, "size estimation for " + installType + "install is " + retVal);
        return (long)retVal;
    }

    private static long getOracleHomeOffsetSize() {
        String oraHomeOffsetSize = "";
        String oraHomeOffsetSizeUnits = "";
        long oracleHomeOffsetSize = 0L;
        String STARTUP_LOCATION = System.getProperty("oracle.installer.startup_location");
        File metadataFile = new File(STARTUP_LOCATION, File.separator + ".." + File.separator + "stage" + File.separator + "shiphomeproperties.xml");
        ShiphomeMetadata metadata = null;
        try {
            metadata = ShiphomeMetadata.newInstance((File)metadataFile);
        }
        catch (Exception e1) {
            logger.log(Level.WARNING, "Error in retriving metadata from shiphomeproperties xml", e1);
        }
        if (metadata != null) {
            if (metadata.getProperty("ORACLE_HOME_OFFSET_SIZE") != null) {
                // empty if block
            }
            oraHomeOffsetSize = metadata.getProperty("ORACLE_HOME_OFFSET_SIZE");
            if (metadata.getProperty("ORACLE_HOME_OFFSET_SIZE_UNITS") != null) {
                oraHomeOffsetSizeUnits = metadata.getProperty("ORACLE_HOME_OFFSET_SIZE_UNITS");
            }
            if (oraHomeOffsetSizeUnits.equalsIgnoreCase("MB")) {
                oracleHomeOffsetSize += Long.parseLong(oraHomeOffsetSize);
            } else if (oraHomeOffsetSizeUnits.equalsIgnoreCase("GB")) {
                oracleHomeOffsetSize += Long.parseLong(oraHomeOffsetSize) * 1024L;
            }
        }
        return oracleHomeOffsetSize;
    }

    public static long getSize(String installType) {
        return StageSizeInfo.getSize(installType, false);
    }
}

