/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.awt.Component;
import java.awt.Cursor;
import javax.accessibility.AccessibleContext;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.Validator;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.validate.InlineValidationHelper;
import oracle.install.commons.swing.validate.SimpleInlineValidator;
import oracle.install.library.util.GenericValidation;
import oracle.sysman.oii.oiif.oiifm.OiifmCursorUtil;

public class UIUtil {
    public static void registerInlineValidator(Component view, final JPasswordField txtPasswordField, final JPasswordField confirmPasswordField, final String passwdDesc, Validator inlineValidator, Object validationType) {
        InlineValidationHelper.registerInlineValidator((Component)view, (Component)txtPasswordField, (Validator)inlineValidator, (Object)validationType);
        InlineValidationHelper.registerInlineValidator((Component)view, (Component)confirmPasswordField, (Validator)new SimpleInlineValidator(){

            public ValidationStatusMessage doValidate(Component component, Object data) throws ValidationException {
                ValidationStatusMessage message = null;
                if (confirmPasswordField.hasFocus()) {
                    String confirmPasswd = data.toString();
                    char[] passwd = txtPasswordField.getPassword();
                    String passwordText = new String(passwd);
                    message = GenericValidation.validatePasswdMatch(passwordText, confirmPasswd, passwdDesc);
                }
                return message;
            }
        }, (Object)ValidationComponent.MODEL_CHANGE_VALIDATOR);
        txtPasswordField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                try {
                    String password = e.getDocument().getText(0, e.getDocument().getLength());
                    if (password != null) {
                        confirmPasswordField.setText(null);
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }

            public void removeUpdate(DocumentEvent e) {
                try {
                    String password = e.getDocument().getText(0, e.getDocument().getLength());
                    if (password != null) {
                        confirmPasswordField.setText(null);
                    }
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    public static void setCursor(int cursor, Component component) {
        OiifmCursorUtil.setCursor((int)cursor, (Component)component);
    }

    public static void setCursor(Cursor cursor, Component component) {
        OiifmCursorUtil.setCursor((Cursor)cursor, (Component)component);
    }

    public static JRadioButton createDescriptiveRadioButton(MultilineLabel lblDescription) {
        DescriptiveRadioButton descriptiveRadioButton = new DescriptiveRadioButton();
        descriptiveRadioButton.setDescriptionComponentAccessibleContext(lblDescription.getAccessibleContext());
        return descriptiveRadioButton;
    }

    static class DescriptiveRadioButton
    extends JRadioButton {
        private AccessibleContext descriptionComponentAccessibleContext;

        public DescriptiveRadioButton() {
        }

        public DescriptiveRadioButton(String text) {
            super(text);
        }

        public AccessibleContext getDescriptionComponentAccessibleContext() {
            return this.descriptionComponentAccessibleContext;
        }

        public void setDescriptionComponentAccessibleContext(AccessibleContext descriptionComponentAccessibleContext) {
            this.descriptionComponentAccessibleContext = descriptionComponentAccessibleContext;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleDescriptibeRadioButton();
            }
            return this.accessibleContext;
        }

        class AccessibleDescriptibeRadioButton
        extends JRadioButton.AccessibleJRadioButton {
            AccessibleDescriptibeRadioButton() {
                super(DescriptiveRadioButton.this);
            }

            public String getAccessibleName() {
                String description;
                StringBuffer buffer = new StringBuffer();
                String accessibleName = super.getAccessibleName();
                if (accessibleName != null) {
                    buffer.append(accessibleName);
                }
                if ((description = this.getAccessibleDescription()) != null) {
                    buffer.append(".");
                    buffer.append(" ");
                    buffer.append(description);
                }
                return buffer.toString();
            }

            public String getAccessibleDescription() {
                return DescriptiveRadioButton.this.descriptionComponentAccessibleContext != null ? DescriptiveRadioButton.this.descriptionComponentAccessibleContext.getAccessibleDescription() : super.getAccessibleDescription();
            }
        }
    }
}

