/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cluster;

import java.util.ArrayList;
import java.util.List;
import oracle.install.commons.bean.annotation.BeanDef;
import oracle.install.commons.bean.annotation.PropertyDef;
import oracle.install.commons.util.Bean;
import oracle.install.library.util.cluster.ClusterNode;
import oracle.install.library.util.cluster.ClusterwareType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BeanDef(value="ClusterConfig")
public class ClusterConfig
extends Bean {
    public static final String PROPERTY_AUTO_CONFIGURE_NODE_VIP = "ClusterConfig.autoConfigureNodeVIP";
    private ClusterwareType clusterwareType = ClusterwareType.UNKNOWN;
    private String clusterName;
    private List<ClusterNode> clusterNodes = new ArrayList<ClusterNode>();
    private boolean readonly;
    private boolean validated;
    private boolean autoConfigureNodeVIP;

    @PropertyDef(value="ClusterwareType")
    public ClusterwareType getClusterwareType() {
        return this.clusterwareType;
    }

    public void setClusterwareType(ClusterwareType type) {
        this.clusterwareType = type;
    }

    @PropertyDef(value="ClusterwareName")
    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @PropertyDef(value="ClusterNodes")
    public List<ClusterNode> getClusterNodes() {
        return this.clusterNodes;
    }

    public void setClusterNodes(List<ClusterNode> clusterNodes) {
        this.clusterNodes = clusterNodes;
        this.validated = false;
    }

    @PropertyDef(value="Readonly")
    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @PropertyDef(value="Validated")
    public boolean isAutoConfigureNodeVIP() {
        return this.autoConfigureNodeVIP;
    }

    public void setAutoConfigureNodeVIP(boolean autoConfigureNodeVIP) {
        boolean oldValue = this.autoConfigureNodeVIP;
        if (oldValue != autoConfigureNodeVIP) {
            this.autoConfigureNodeVIP = autoConfigureNodeVIP;
            if (this.clusterNodes != null) {
                for (ClusterNode clusterNode : this.clusterNodes) {
                    clusterNode.setAutoVIPConfigEnabled(autoConfigureNodeVIP);
                }
            }
            this.validated = false;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_AUTO_CONFIGURE_NODE_VIP, oldValue, this.autoConfigureNodeVIP);
        }
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean validated) {
        this.validated = validated;
    }

    public ClusterNode getClusterNodeAt(int index) {
        ClusterNode clusterNode = null;
        if (this.clusterNodes != null && index < this.clusterNodes.size()) {
            clusterNode = this.clusterNodes.get(index);
        }
        return clusterNode;
    }

    public int addClusterNode(ClusterNode clusterNode) {
        int index = -1;
        if (clusterNode != null && this.clusterNodes.add(clusterNode)) {
            index = this.clusterNodes.size() - 1;
            this.validated = false;
        }
        return index;
    }

    public List<ClusterNode> getClusterNodes(int[] indices) {
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>();
        for (int index : indices) {
            nodes.add(this.clusterNodes.get(index));
        }
        return nodes;
    }

    public boolean removeClusterNodes(List<ClusterNode> trashableNodes) {
        boolean deleted = this.clusterNodes.removeAll(trashableNodes);
        if (deleted) {
            this.validated = false;
        }
        return deleted;
    }

    public void removeClusterNodes(int[] indices) {
        List<ClusterNode> trashableNodes = this.getClusterNodes(indices);
        this.removeClusterNodes(trashableNodes);
    }

    public static List<String> getPublicNodeNames(ClusterConfig clusterConfig, boolean fqcn) {
        List<ClusterNode> clusterNodes;
        ArrayList<String> publicNodeNames = null;
        if (clusterConfig != null && !(clusterNodes = clusterConfig.getClusterNodes()).isEmpty()) {
            publicNodeNames = new ArrayList<String>();
            for (ClusterNode clusterNode : clusterNodes) {
                publicNodeNames.add(clusterNode.getPublicNodeName(fqcn));
            }
        }
        return publicNodeNames;
    }

    public static List<String> getVirtualHostNames(ClusterConfig clusterConfig, boolean fqcn) {
        ArrayList<String> virtualHostNames = null;
        List<ClusterNode> clusterNodes = clusterConfig.getClusterNodes();
        if (!clusterNodes.isEmpty()) {
            virtualHostNames = new ArrayList<String>();
            for (ClusterNode clusterNode : clusterNodes) {
                virtualHostNames.add(clusterNode.getVirtualHostName(fqcn));
            }
        }
        return virtualHostNames;
    }
}

