/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cluster;

import java.text.MessageFormat;
import java.text.ParseException;
import oracle.install.commons.bean.annotation.BeanDef;
import oracle.install.commons.bean.annotation.PropertyDef;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.Node;

@BeanDef(value="ClusterNode")
public class ClusterNode
extends Node {
    private String publicNodeName;
    private String virtualHostName;
    private boolean autoVIPConfigEnabled;
    private boolean oracle9iRACDetected;
    private boolean readonly;
    private static final MessageFormat format = new MessageFormat("{0}:{1}");
    public static final String AUTO = "AUTO";

    public ClusterNode() {
    }

    public ClusterNode(String publicNodeName, String virtualHostName) {
        super(publicNodeName);
        this.publicNodeName = publicNodeName;
        this.virtualHostName = virtualHostName;
    }

    @PropertyDef(value="Readonly")
    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @PropertyDef(value="PublicNodeName")
    public String getPublicNodeName() {
        return this.publicNodeName;
    }

    public String getPublicNodeName(boolean fqn) {
        return ClusterNode.getHostName(this.publicNodeName, fqn);
    }

    public void setPublicNodeName(String publicNodeName) {
        this.publicNodeName = publicNodeName;
        super.setName(publicNodeName);
    }

    @PropertyDef(value="VirtualHostName")
    public String getVirtualHostName() {
        return this.virtualHostName;
    }

    public String getVirtualHostName(boolean fqn) {
        return ClusterNode.getHostName(this.virtualHostName, fqn);
    }

    public void setVirtualHostName(String virtualHostName) {
        this.virtualHostName = virtualHostName;
    }

    @PropertyDef(value="EnableAutoVIPConfig")
    public boolean isAutoVIPConfigEnabled() {
        return this.autoVIPConfigEnabled;
    }

    public void setAutoVIPConfigEnabled(boolean autoConfigureVIP) {
        this.autoVIPConfigEnabled = autoConfigureVIP;
    }

    @PropertyDef(value="Oracle9iRACDetected")
    public boolean isOracle9iRACDetected() {
        return this.oracle9iRACDetected;
    }

    public void setOracle9iRACDetected(boolean oracle9iRACDetected) {
        this.oracle9iRACDetected = oracle9iRACDetected;
    }

    public static ClusterNode parseClusterNode(String text) throws IllegalArgumentException {
        ClusterNode clusterNode;
        block6: {
            clusterNode = null;
            try {
                Object[] args = format.parse(text);
                if (args != null && args.length == 2) {
                    clusterNode = new ClusterNode();
                    String publicNodeName = (String)args[0];
                    clusterNode.setPublicNodeName(publicNodeName);
                    String virtualHostName = (String)args[1];
                    if (AUTO.equals(virtualHostName)) {
                        clusterNode.setAutoVIPConfigEnabled(true);
                    } else {
                        clusterNode.setVirtualHostName(virtualHostName);
                    }
                    MachineInfo machineInfo = MachineInfo.getInstance();
                    if (machineInfo.isLocalHost(publicNodeName)) {
                        clusterNode.setLocalNode(true);
                    }
                    break block6;
                }
                throw new IllegalArgumentException(text);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return clusterNode;
    }
}

