/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.cluster;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.library.db.RAC92Info;
import oracle.install.library.resource.CommonErrorCode;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.VendorClusterwareInfo;
import oracle.install.library.util.cluster.ClusterConfig;
import oracle.install.library.util.cluster.ClusterConfigException;
import oracle.install.library.util.cluster.ClusterNode;
import oracle.install.library.util.cluster.ClusterwareType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterSupport {
    private static final Logger logger = Logger.getLogger(ClusterSupport.class.getName());
    private static ClusterSupport instance = null;
    private ClusterNode localClusterNode;

    public static ClusterSupport getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (ClusterSupport)(proxyFactory = ProxyFactory.getInstance()).createProxy(ClusterSupport.class)) == null) {
            instance = new ClusterSupport();
        }
        return instance;
    }

    protected ClusterSupport() {
    }

    public ClusterConfig createClusterConfig() {
        ClusterConfig clusterConfig = new ClusterConfig();
        ArrayList<ClusterNode> clusterNodes = new ArrayList<ClusterNode>();
        clusterConfig.setClusterwareType(ClusterwareType.ORACLE_CLUSTERWARE);
        clusterConfig.setClusterNodes(clusterNodes);
        clusterNodes.add(this.getLocalClusterNode());
        return clusterConfig;
    }

    public ClusterNode getLocalClusterNode() {
        if (this.localClusterNode == null) {
            MachineInfo machineInfo = MachineInfo.getInstance();
            String localHostName = machineInfo.getFullHostName();
            this.localClusterNode = new ClusterNode();
            this.localClusterNode.setLocalNode(true);
            this.localClusterNode.setPublicNodeName(machineInfo.getDefPubName(localHostName));
            this.localClusterNode.setVirtualHostName(machineInfo.getDefVIPName(localHostName));
        }
        return this.localClusterNode;
    }

    public ClusterConfig getClusterConfig() {
        ClusterConfig clusterConfig = null;
        VendorClusterwareInfo vendorClusterwareInfo = VendorClusterwareInfo.getInstance();
        if (vendorClusterwareInfo.isVendorClusterware()) {
            logger.info("Found Vendor Clusterware. Fetching Cluster Configuration");
            clusterConfig = vendorClusterwareInfo.getClusterConfig();
        } else {
            RAC92Info rac92Info = RAC92Info.getInstance();
            if (rac92Info.is92RACPresent()) {
                logger.info("Found Oracle 9i RAC. Fetching Cluster Configuration");
                clusterConfig = rac92Info.getClusterConfig();
            }
        }
        return clusterConfig;
    }

    public ClusterConfig loadClusterConfiguration(File ccf) throws ClusterConfigException {
        ClusterConfig clusterConfig = null;
        FileInputStream ccfIn = null;
        try {
            ccfIn = new FileInputStream(ccf);
            clusterConfig = this.loadClusterConfiguration(ccfIn);
            clusterConfig.setClusterwareType(ClusterwareType.ORACLE_CLUSTERWARE);
        }
        catch (FileNotFoundException e) {
            throw new ClusterConfigException((Throwable)e, (ErrorCode)CommonErrorCode.CCF_READ_FAILED, new Object[0]);
        }
        finally {
            if (ccfIn != null) {
                try {
                    ccfIn.close();
                }
                catch (IOException e) {
                    throw new ClusterConfigException((Throwable)e, (ErrorCode)CommonErrorCode.CCF_READ_FAILED, new Object[0]);
                }
            }
        }
        return clusterConfig;
    }

    public ClusterConfig loadClusterConfiguration(InputStream ccfIn) throws ClusterConfigException {
        ClusterConfig clusterConfig = new ClusterConfig();
        String line = null;
        String[] data = null;
        ArrayList<ClusterNode> clusterNodes = new ArrayList<ClusterNode>();
        clusterConfig.setClusterNodes(clusterNodes);
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(ccfIn));
            while ((line = in.readLine()) != null) {
                line = line.trim().replaceAll("\\t", " ").replaceAll("\\s{2,}", " ");
                logger.log(Level.FINEST, "Processing line: {0}", line);
                if (line.length() == 0 || line.startsWith("#")) continue;
                data = line.split(" ");
                if (clusterConfig.getClusterName() == null && data.length == 1) {
                    clusterConfig.setClusterName(line);
                    continue;
                }
                ClusterNode clusterNode = new ClusterNode();
                if (data.length == 1) {
                    clusterNode.setPublicNodeName(data[0]);
                } else if (data.length == 2) {
                    clusterNode.setPublicNodeName(data[0]);
                    clusterNode.setVirtualHostName(data[1]);
                    clusterNode.setAutoVIPConfigEnabled("AUTO".equals(data[1]));
                } else if (data.length == 3) {
                    clusterNode.setPublicNodeName(data[0]);
                    clusterNode.setVirtualHostName(data[2]);
                } else {
                    throw new ClusterConfigException((ErrorCode)CommonErrorCode.CCF_INCORRECT_FORMAT, new Object[0]);
                }
                clusterNodes.add(clusterNode);
            }
        }
        catch (IOException e) {
            throw new ClusterConfigException((Throwable)e, (ErrorCode)CommonErrorCode.CCF_READ_FAILED, new Object[0]);
        }
        ClusterNode localClusterNode = this.getLocalClusterNode();
        int index = clusterNodes.indexOf(localClusterNode);
        if (index != -1) {
            localClusterNode = clusterNodes.get(index);
            localClusterNode.setLocalNode(true);
        }
        return clusterConfig;
    }

    public static ClusterConfig updateClusterConfig(ClusterConfig clusterConfig, List<String> tableList) {
        if (clusterConfig != null && tableList != null) {
            List<ClusterNode> nodeList = clusterConfig.getClusterNodes();
            HashMap<String, ClusterNode> map = new HashMap<String, ClusterNode>();
            for (ClusterNode node : nodeList) {
                map.put(node.getPublicNodeName(), node);
            }
            for (String entry : tableList) {
                ClusterNode node;
                ClusterNode nodeFromTable = ClusterNode.parseClusterNode(entry);
                if (nodeFromTable == null) continue;
                String pubNodeName = nodeFromTable.getPublicNodeName();
                if (pubNodeName.indexOf(".") != -1) {
                    pubNodeName = pubNodeName.substring(0, pubNodeName.indexOf("."));
                }
                if ((node = (ClusterNode)map.get(pubNodeName)) != null || (node = (ClusterNode)map.get(nodeFromTable.getPublicNodeName())) != null) {
                    node.setVirtualHostName(nodeFromTable.getVirtualHostName());
                    node.setPublicNodeName(nodeFromTable.getPublicNodeName());
                } else {
                    nodeList.add(nodeFromTable);
                }
                map.remove(pubNodeName);
                map.remove(nodeFromTable.getPublicNodeName());
            }
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                nodeList.remove(map.get(i.next()));
            }
            clusterConfig.setClusterNodes(nodeList);
        }
        return clusterConfig;
    }
}

