/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilQuery;
import oracle.sysman.oii.oiil.OiilQueryException;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class PingQuery
implements OiilQuery {
    private int[] portNumbers;
    private boolean unKnownHost = false;
    private static final int PING_SUCCESS = 0;
    private static final int PING_UNKNOWN_HOST = 1;
    private static final int PING_FAILURE = 2;

    public Object performQuery(Vector vector) throws OiilQueryException {
        Enumeration enumeration = vector.elements();
        String string = (String)this.retItem(vector, "hostName");
        String string2 = (String)this.retItem(vector, "listenPort");
        int n = 0;
        if (string == null || string.length() == 0) {
            return "ERROR:Invalid HostName";
        }
        if (string2 != null && string2.length() != 0) {
            try {
                n = Integer.parseInt(string2);
                if (n <= 0) {
                    return "ERROR:Invalid port number -" + n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return "ERROR: Invalid Port Number -" + string2;
            }
        }
        try {
            return String.valueOf(this.checkPingState(string, n));
        }
        catch (Exception exception) {
            String string3 = OiQueryFileRes.getString("PingException_desc") + "\n" + exception.getMessage();
            return "ERROR: " + string3;
        }
    }

    Object retItem(Vector vector, String string) {
        int n = OiixVectorOps.vectIndexOf((Vector)vector, (Object)string);
        if (n == -1) {
            return null;
        }
        OiilActionInputElement oiilActionInputElement = (OiilActionInputElement)vector.elementAt(n);
        return oiilActionInputElement.getObject();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int checkPingState(String string, int n) {
        Socket socket = null;
        boolean bl = false;
        try {
            block17: {
                try {
                    if (n > 0) {
                        this.portNumbers = new int[1];
                        this.portNumbers[0] = n;
                        if (this.loopThruWellKnownPorts(socket, string, this.portNumbers)) {
                            bl = true;
                        }
                        break block17;
                    }
                    this.portNumbers = new int[47];
                    this.setWellKnownPortArray(this.portNumbers);
                    if (this.loopThruWellKnownPorts(socket, string, this.portNumbers)) {
                        bl = true;
                    }
                    if (this.unKnownHost || bl) break block17;
                    if (this.isPinging(string)) {
                        bl = true;
                        break block17;
                    }
                    if (this.loopThruAllPorts(socket, string)) {
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    int n2 = 2;
                    Object var8_6 = null;
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        this.stopAllRunningThreads();
                        return n2;
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                        return 2;
                    }
                }
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {}
            catch (Exception exception) {
                exception.printStackTrace();
                return 2;
            }
            if (socket != null) {
                socket.close();
            }
            this.stopAllRunningThreads();
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            exception.printStackTrace();
            return 2;
        }
        if (socket != null) {
            socket.close();
        }
        this.stopAllRunningThreads();
        if (bl) {
            return 0;
        }
        if (!this.unKnownHost) return 2;
        return 1;
    }

    public void setWellKnownPortArray(int[] nArray) {
        nArray[0] = 1;
        nArray[1] = 23;
        nArray[2] = 139;
        nArray[3] = 21;
        nArray[4] = 20;
        nArray[5] = 137;
        nArray[6] = 143;
        nArray[7] = 150;
        nArray[8] = 5;
        nArray[9] = 7;
        nArray[10] = 18;
        nArray[11] = 22;
        nArray[12] = 25;
        nArray[13] = 29;
        nArray[14] = 37;
        nArray[15] = 42;
        nArray[16] = 43;
        nArray[17] = 49;
        nArray[18] = 53;
        nArray[19] = 69;
        nArray[20] = 70;
        nArray[21] = 79;
        nArray[22] = 80;
        nArray[23] = 103;
        nArray[24] = 108;
        nArray[25] = 109;
        nArray[26] = 110;
        nArray[27] = 115;
        nArray[28] = 118;
        nArray[29] = 119;
        nArray[30] = 156;
        nArray[31] = 161;
        nArray[32] = 179;
        nArray[33] = 190;
        nArray[34] = 194;
        nArray[35] = 197;
        nArray[36] = 389;
        nArray[37] = 396;
        nArray[38] = 443;
        nArray[39] = 444;
        nArray[40] = 445;
        nArray[41] = 458;
        nArray[42] = 546;
        nArray[43] = 547;
        nArray[44] = 563;
        nArray[45] = 569;
        nArray[46] = 1080;
    }

    public boolean loopThruWellKnownPorts(Socket socket, String string, int[] nArray) {
        boolean bl = false;
        long l = System.currentTimeMillis() / 1000L;
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        while (n < nArray.length) {
            try {
                l2 = System.currentTimeMillis() / 1000L;
                l3 = l2 - l;
                if (l3 > 60L && n < 10 || l3 > 60L) break;
                socket = PingQuery.getSocket(string, nArray[n], 8, 100, "PingKnown");
                bl = true;
                break;
            }
            catch (UnknownHostException unknownHostException) {
                this.unKnownHost = true;
                break;
            }
            catch (NoRouteToHostException noRouteToHostException) {
                this.unKnownHost = true;
                break;
            }
            catch (Exception exception) {
                ++n;
            }
        }
        return bl;
    }

    public boolean loopThruAllPorts(Socket socket, String string) {
        long l = System.currentTimeMillis() / 1000L;
        long l2 = 0L;
        long l3 = 0L;
        boolean bl = false;
        int n = 1;
        while (n < 1024) {
            try {
                l2 = System.currentTimeMillis() / 1000L;
                l3 = l2 - l;
                if (l3 > 20L && n < 10 || l3 > 20L) break;
                socket = PingQuery.getSocket(string, n, 8, 100, "PingAll");
                bl = true;
                break;
            }
            catch (UnknownHostException unknownHostException) {
                this.unKnownHost = true;
                break;
            }
            catch (NoRouteToHostException noRouteToHostException) {
                this.unKnownHost = true;
                break;
            }
            catch (Exception exception) {
                ++n;
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isPinging(String var1_1) {
        block14: {
            block13: {
                var2_2 = false;
                var3_3 = null;
                var4_4 = new StringBuffer();
                try {
                    try {
                        var5_5 = Runtime.getRuntime();
                        var6_7 = var5_5.exec("ping " + var1_1);
                        if (var6_7 == null) {
                            var7_9 = false;
                            var10_11 = null;
                            break block13;
                        }
                        var3_3 = new BufferedReader(new InputStreamReader(var6_7.getInputStream()));
                        var7_10 = null;
                        var8_19 = false;
                        while (true) {
                            if ((var7_10 = var3_3.readLine()) == null) {
                                var2_2 = this.parsePingResult(var4_4.toString());
                                break block14;
                            }
                            var4_4.append(var7_10).append(" ");
                        }
                    }
                    catch (Exception var5_6) {
                        var6_8 = false;
                        var10_13 = null;
                        try {
                            if (var3_3 == null) return var6_8;
                            var3_3.close();
                            return var6_8;
                        }
                        catch (Exception var11_17) {
                            // empty catch block
                        }
                        return var6_8;
                    }
                }
                catch (Throwable var9_20) {
                    var10_14 = null;
                    ** try [egrp 2[TRYBLOCK] [2 : 147->158)] { 
lbl38:
                    // 1 sources

                    if (var3_3 == null) throw var9_20;
                    var3_3.close();
                    throw var9_20;
lbl41:
                    // 1 sources

                    catch (Exception var11_18) {
                        // empty catch block
                    }
                    throw var9_20;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 147->158)] { 
lbl46:
            // 1 sources

            if (var3_3 == null) return var7_9;
            var3_3.close();
            return var7_9;
lbl49:
            // 1 sources

            catch (Exception var11_15) {
                // empty catch block
            }
            return var7_9;
        }
        var10_12 = null;
        try {}
        catch (Exception var11_16) {}
        if (var3_3 == null) return var2_2;
        var3_3.close();
        return var2_2;
        return var2_2;
    }

    public boolean parsePingResult(String string) throws Exception {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        String string2 = string.trim();
        boolean bl = false;
        int n3 = 0;
        boolean bl2 = false;
        String string3 = null;
        while (!bl2) {
            n3 = string2.indexOf(32, 0);
            if (n3 != -1) {
                string3 = string2.substring(0, n3);
                if (string3.equalsIgnoreCase("unknown") || string3.equalsIgnoreCase("unreachable") || string3.equalsIgnoreCase("timed") || string3.equalsIgnoreCase("out") || string3.equalsIgnoreCase("no")) {
                    n2 += 10;
                } else if (string3.equalsIgnoreCase("alive")) {
                    n2 = 0;
                    n += 10;
                } else if (string3.equalsIgnoreCase("received") && (n3 = (string2 = string2.substring(n3).trim()).indexOf(32, 0)) != -1 && (string3 = string2.substring(0, n3)).equalsIgnoreCase("=") && (n3 = (string2 = string2.substring(n3).trim()).indexOf(32, 0)) != -1) {
                    string3 = string2.substring(0, n3);
                    try {
                        int n4 = 0;
                        if (string3 != null) {
                            n4 = string3.indexOf(44, 0);
                            String string4 = string3 = n4 == -1 ? string3 : string3.substring(0, n4);
                            if (Integer.parseInt(string3) > 0) {
                                n2 = 0;
                                n += 10;
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.toString();
                    }
                }
                string2 = string2.substring(n3).trim();
                continue;
            }
            if (n3 != -1) continue;
            bl2 = true;
        }
        if (n > n2) {
            return true;
        }
        if (n < n2) {
            return false;
        }
        return false;
    }

    private static Socket getSocket(String string, int n, int n2, int n3, String string2) throws InterruptedIOException, UnknownHostException, NoRouteToHostException, IOException, Exception {
        SocketThread socketThread = new SocketThread(string, n, string2);
        socketThread.start();
        int n4 = 0;
        while (!socketThread.isConnected()) {
            if (n4 > n2) {
                throw new InterruptedIOException("Failed to establish connection");
            }
            if (socketThread.isError()) {
                throw socketThread.getException();
            }
            try {
                Thread.sleep(n3);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n4;
        }
        return socketThread.getSocket();
    }

    public void stopAllRunningThreads() {
        int n = Thread.activeCount();
        Thread[] threadArray = new Thread[n];
        Thread.enumerate(threadArray);
        int n2 = 0;
        while (n2 < n) {
            if (threadArray[n2] != null && (threadArray[n2].getName().startsWith("PingKnown") || threadArray[n2].getName().startsWith("PingAll"))) {
                threadArray[n2].interrupt();
            }
            ++n2;
        }
    }

    public static void main(String[] stringArray) throws MalformedURLException {
        long l = System.currentTimeMillis() / 1000L;
        long l2 = 0L;
        long l3 = 0L;
        Vector<OiilActionInputElement> vector = new Vector<OiilActionInputElement>();
        Object var8_5 = null;
        if (stringArray.length == 1) {
            vector.addElement(new OiilActionInputElement("hostName", (Object)stringArray[0]));
        }
        if (stringArray.length == 2) {
            vector.addElement(new OiilActionInputElement("hostName", (Object)stringArray[0]));
            vector.addElement(new OiilActionInputElement("listenPort", (Object)stringArray[1]));
        }
        if (stringArray.length == 0 || stringArray.length > 2) {
            System.out.println("Please Enter two arguments 1.hostname-mandatory argument 2.portNumber-optional argument");
            return;
        }
        try {
            PingQuery pingQuery = new PingQuery();
            System.out.println("PINGING STATE:" + pingQuery.performQuery(vector));
        }
        catch (Exception exception) {
            // empty catch block
        }
        l2 = System.currentTimeMillis() / 1000L;
        l3 = l2 - l;
        System.out.println("Total pinging wait period in seconds is:" + l3);
    }

    private static class SocketThread
    extends Thread {
        private Socket s_connection = null;
        private String s_host = null;
        private int s_port = 0;
        private IOException s_exception = null;

        public SocketThread(String string, int n, String string2) {
            super(string2 + n);
            this.s_host = string;
            this.s_port = n;
        }

        public void run() {
            Socket socket = null;
            try {
                socket = new Socket(this.s_host, this.s_port);
            }
            catch (IOException iOException) {
                this.s_exception = iOException;
                return;
            }
            this.s_connection = socket;
        }

        public boolean isConnected() {
            return null != this.s_connection;
        }

        public boolean isError() {
            return null != this.s_exception;
        }

        public Socket getSocket() {
            return this.s_connection;
        }

        public IOException getException() {
            return this.s_exception;
        }
    }
}

