/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import oracle.i18n.util.OraDisplayLocaleInfo;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilQuery;
import oracle.sysman.oii.oiil.OiilQueryException;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiCountryCode
implements OiilQuery {
    private static final String COUNTRY_NAME = "CountryName";
    private static final String OUTPUT_OPTION = "CountryOption";
    private static final String COUNTRY_CODE = "code";
    private static final String COUNTRY_NUMBER = "number";
    private Properties codes = new Properties();
    private Properties codeNumbers = new Properties();

    public Object performQuery(Vector vector) throws OiilQueryException {
        String string = "ERROR:";
        this.loadCountries();
        String string2 = (String)OiCountryCode.retItem(vector, COUNTRY_NAME);
        String string3 = (String)OiCountryCode.retItem(vector, OUTPUT_OPTION);
        Properties properties = string3.toUpperCase().equals(COUNTRY_CODE.toUpperCase()) ? this.codes : this.codeNumbers;
        String string4 = properties.getProperty(string2);
        if (string4 == null || string4.length() == 0) {
            return string + "Invalid Country Name Specified.";
        }
        return string4;
    }

    public static Object retItem(Vector vector, String string) {
        int n = OiixVectorOps.vectIndexOf((Vector)vector, (Object)string);
        if (n == -1) {
            return null;
        }
        OiilActionInputElement oiilActionInputElement = (OiilActionInputElement)vector.elementAt(n);
        return oiilActionInputElement.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCountries() {
        Object object;
        String[] stringArray;
        BufferedInputStream bufferedInputStream = null;
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringArray = "resource/country_codes.properties";
            object = this.getClass().getResource((String)stringArray);
            if (object == null) {
                stringBuffer.append("No codes info is available on this platform.");
            } else {
                bufferedInputStream = new BufferedInputStream(((URL)object).openStream());
                byte[] byArray = new byte[bufferedInputStream.available()];
                bufferedInputStream.read(byArray, 0, bufferedInputStream.available());
                string = new String(byArray, 0, byArray.length);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        stringArray = string.split("\\n");
        object = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            if (stringArray2[0].indexOf("#") >= 0) continue;
            String[] stringArray3 = stringArray2[1].split("\\/");
            OraDisplayLocaleInfo oraDisplayLocaleInfo = OraDisplayLocaleInfo.getInstance((Locale)Locale.getDefault());
            object = oraDisplayLocaleInfo.getDisplayCountry(stringArray2[0]);
            if (!((String)object).equals(stringArray2[0])) {
                stringArray3[1] = object;
            }
            if (stringArray3[1].length() > 36) {
                stringArray3[1] = stringArray3[1].substring(0, 36);
            }
            this.codes.setProperty(stringArray3[1], stringArray2[0]);
            this.codeNumbers.setProperty(stringArray3[1], stringArray3[0]);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("ERROR:OiCountryCode:Invalid Number of Arguments. Usage: CountryName number | code");
        }
        Vector<OiilActionInputElement> vector = new Vector<OiilActionInputElement>();
        vector.addElement(new OiilActionInputElement(COUNTRY_NAME, (Object)stringArray[0]));
        vector.addElement(new OiilActionInputElement(OUTPUT_OPTION, (Object)stringArray[1]));
        OiCountryCode oiCountryCode = new OiCountryCode();
        String string = (String)oiCountryCode.performQuery(vector);
        System.out.println(string);
    }
}

