/*
 * Decompiled with CFR 0.152.
 */
import HTTPClient.HTTPConnection;
import java.io.File;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OuiTestComms;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilQuery;
import oracle.sysman.oii.oiil.OiilQueryException;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiTestConnection
implements OiilQuery {
    public static final String ORACLEHOME = "oracleHome";
    public static final String PROXYHOST = "http.proxyHost";
    public static final String PROXYPORT = "http.proxyPort";
    public static final String USER = "http.proxyUser";
    public static final String PASSWORD = "http.proxyPassword";
    public static final String TIMEOUT = "http.proxyTimeout";
    public static final String HTTP_OK = "200";
    private String home = "/scratch/DUMMY";

    private boolean setProperty(Vector vector, Properties properties, String string) {
        String string2 = (String)OiTestConnection.retItem(vector, string);
        if (string2 != null && string2.length() > 0) {
            properties.setProperty(string, string2);
            return true;
        }
        return false;
    }

    private void set_OracleHome(String string) {
        if (string != null && string.length() > 0) {
            FakeCertificate fakeCertificate = new FakeCertificate();
            this.home = fakeCertificate.mkOracleHome(string);
        }
    }

    private String get_OracleHome() {
        return this.home;
    }

    public Object performQuery(Vector vector) throws OiilQueryException {
        String string = "ERROR:";
        Properties properties = new Properties();
        if (!this.setProperty(vector, properties, ORACLEHOME)) {
            return string + "ORACLEHOME to Test is unspecified";
        }
        if (!this.setProperty(vector, properties, TIMEOUT)) {
            properties.setProperty(TIMEOUT, "10000");
        }
        if (this.setProperty(vector, properties, PROXYHOST)) {
            if (!this.setProperty(vector, properties, PROXYPORT)) {
                return string + "Port must be specified to reach Proxy Server=" + properties.getProperty(PROXYHOST);
            }
            HTTPConnection.setProxyServer((String)properties.getProperty(PROXYHOST), (int)Integer.parseInt(properties.getProperty(PROXYPORT)));
            if (this.setProperty(vector, properties, USER) && !this.setProperty(vector, properties, PASSWORD)) {
                return string + "Password must be supplied to authenticate User=" + properties.getProperty(USER);
            }
        } else {
            properties.setProperty(PROXYHOST, "");
            properties.setProperty(PROXYPORT, "");
            HTTPConnection.setProxyServer((String)"", (int)0);
        }
        String string2 = this.testConnection(properties);
        FakeCertificate.removeDirs(new File(this.get_OracleHome()));
        if (string2.equals(HTTP_OK)) {
            return HTTP_OK;
        }
        return string + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String testConnection(Properties properties) {
        String string = properties.getProperty(ORACLEHOME);
        try {
            this.set_OracleHome(properties.getProperty(ORACLEHOME));
            String string2 = this.get_OracleHome();
            System.setProperty("ORACLE_HOME", string2);
            OuiTestComms.testConnect((Properties)properties);
        }
        catch (NetworkException networkException) {
            String string3 = OuiTestComms.formatExceptionChain((CCRException)networkException).toString();
            return string3;
        }
        finally {
            System.setProperty("ORACLE_HOME", string);
        }
        return HTTP_OK;
    }

    public static Object retItem(Vector vector, String string) {
        int n = OiixVectorOps.vectIndexOf((Vector)vector, (Object)string);
        if (n == -1) {
            return null;
        }
        OiilActionInputElement oiilActionInputElement = (OiilActionInputElement)vector.elementAt(n);
        return oiilActionInputElement.getObject();
    }

    private static void addItem(Vector vector, String string, String string2) {
        String string3 = null;
        if (string2 != null && string2.length() > 0 && !string2.equalsIgnoreCase("NO_DATA") && !string2.equalsIgnoreCase("<Value Unspecified>")) {
            string3 = string2;
        }
        vector.addElement(new OiilActionInputElement(string, string3));
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("ERROR:OiTestConnection:Invalid Number of Arguments. Usage: ORACLE_HOME TIMEOUT [PROXY_HOST PROXY_PORT [PROXY_USER PROXY_PASSWORD]]");
            return;
        }
        Vector vector = new Vector();
        OiTestConnection.addItem(vector, ORACLEHOME, stringArray[0]);
        OiTestConnection.addItem(vector, TIMEOUT, stringArray[1]);
        if (stringArray.length > 2) {
            OiTestConnection.addItem(vector, PROXYHOST, stringArray[2]);
        }
        if (stringArray.length > 3) {
            OiTestConnection.addItem(vector, PROXYPORT, stringArray[3]);
        }
        if (stringArray.length > 4) {
            OiTestConnection.addItem(vector, USER, stringArray[4]);
        }
        if (stringArray.length > 5) {
            OiTestConnection.addItem(vector, PASSWORD, stringArray[5]);
        }
        OiTestConnection oiTestConnection = new OiTestConnection();
        String string = (String)oiTestConnection.performQuery(vector);
        System.out.println(string);
    }
}

