/*
 * Decompiled with CFR 0.152.
 */
import HTTPClient.HTTPConnection;
import java.io.File;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.ccr.common.exception.CCRException;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OuiTestComms;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilQuery;
import oracle.sysman.oii.oiil.OiilQueryException;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiTestRegistration
implements OiilQuery {
    public static final String PROXYHOST = "http.proxyHost";
    public static final String PROXYPORT = "http.proxyPort";
    public static final String USER = "http.proxyUser";
    public static final String PASSWORD = "http.proxyPassword";
    public static final String TIMEOUT = "http.proxyTimeout";
    public static final String METALINK = "s_metaLink";
    public static final String CSINUMBER = "s_csiNumber";
    public static final String ICOUNTRYCODE = "i_countryCode";
    public static final String ORACLEHOME = "oracleHome";
    public static final String HTTP_OK = "200";
    private String errorStatus = "ERROR:";
    private String home = "/scratch/DUMMY";

    private boolean setProperty(Vector vector, Properties properties, String string) {
        String string2 = (String)OiTestRegistration.retItem(vector, string);
        if (string2 != null && string2.length() > 0) {
            properties.setProperty(string, string2);
            return true;
        }
        return false;
    }

    public Object performQuery(Vector vector) throws OiilQueryException {
        Properties properties = new Properties();
        if (!this.setProperty(vector, properties, TIMEOUT)) {
            properties.setProperty(TIMEOUT, "10000");
        }
        if (!this.setProperty(vector, properties, ORACLEHOME)) {
            return this.errorStatus + "OracleHome to Test Registration is unspecified";
        }
        if (!this.setProperty(vector, properties, METALINK)) {
            return this.errorStatus + "My Oracle Support User for Test Registration is unspecified";
        }
        if (!this.setProperty(vector, properties, CSINUMBER)) {
            return this.errorStatus + "CSI Number to Test Registration is unspecified";
        }
        if (!this.setProperty(vector, properties, ICOUNTRYCODE)) {
            return this.errorStatus + "Country Code to Test Registration is unspecified";
        }
        if (this.setProperty(vector, properties, PROXYHOST)) {
            if (!this.setProperty(vector, properties, PROXYPORT)) {
                return this.errorStatus + "Port must be specified to reach Proxy Server=" + properties.getProperty(PROXYHOST);
            }
            HTTPConnection.setProxyServer((String)properties.getProperty(PROXYHOST), (int)Integer.parseInt(properties.getProperty(PROXYPORT)));
            if (this.setProperty(vector, properties, USER) && !this.setProperty(vector, properties, PASSWORD)) {
                return this.errorStatus + "Password must be supplied to authenticate User=" + properties.getProperty(USER);
            }
        }
        String string = this.testRegistration(properties);
        FakeCertificate.removeDirs(new File(this.get_OracleHome()));
        if (string.equals(HTTP_OK)) {
            return HTTP_OK;
        }
        return this.errorStatus + string;
    }

    private void set_OracleHome(String string) {
        if (string != null && string.length() > 0) {
            FakeCertificate fakeCertificate = new FakeCertificate();
            this.home = fakeCertificate.mkOracleHome(string);
        }
    }

    private String get_OracleHome() {
        return this.home;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String testRegistration(Properties properties) {
        String string = properties.getProperty(ORACLEHOME);
        try {
            this.set_OracleHome(properties.getProperty(ORACLEHOME));
            String string2 = this.get_OracleHome();
            System.setProperty("ORACLE_HOME", string2);
            String string3 = properties.getProperty(METALINK);
            String string4 = properties.getProperty(CSINUMBER);
            int n = Integer.parseInt(properties.getProperty(ICOUNTRYCODE));
            OuiTestComms.testRegister((String)string4, (String)string3, (int)n, (String)string2, (Properties)properties);
        }
        catch (NetworkException networkException) {
            String string5 = OuiTestComms.formatExceptionChain((CCRException)networkException).toString();
            return string5;
        }
        finally {
            System.setProperty("ORACLE_HOME", string);
        }
        return HTTP_OK;
    }

    public static Object retItem(Vector vector, String string) {
        int n = OiixVectorOps.vectIndexOf((Vector)vector, (Object)string);
        if (n == -1) {
            return null;
        }
        OiilActionInputElement oiilActionInputElement = (OiilActionInputElement)vector.elementAt(n);
        return oiilActionInputElement.getObject();
    }

    private static void addItem(Vector vector, String string, String string2) {
        String string3 = null;
        if (string2 != null && string2.length() > 0 && !string2.equalsIgnoreCase("NO_DATA") && !string2.equalsIgnoreCase("<Value Unspecified>")) {
            string3 = string2;
        }
        vector.addElement(new OiilActionInputElement(string, string3));
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 5) {
            System.out.println("ERROR:OiTestRegistration:Invalid Number of Arguments. Usage: ORACLE_HOME TIMEOUT METALINK CSI_NUMBER ICOUNTRY_CODE [PROXY_HOST PROXY_PORT [PROXY_USER PROXY_PASSWORD]]");
            return;
        }
        Vector vector = new Vector();
        OiTestRegistration.addItem(vector, ORACLEHOME, stringArray[0]);
        OiTestRegistration.addItem(vector, TIMEOUT, stringArray[1]);
        OiTestRegistration.addItem(vector, METALINK, stringArray[2]);
        OiTestRegistration.addItem(vector, CSINUMBER, stringArray[3]);
        OiTestRegistration.addItem(vector, ICOUNTRYCODE, stringArray[4]);
        if (stringArray.length > 5) {
            OiTestRegistration.addItem(vector, PROXYHOST, stringArray[5]);
        }
        if (stringArray.length > 6) {
            OiTestRegistration.addItem(vector, PROXYPORT, stringArray[6]);
        }
        if (stringArray.length > 7) {
            OiTestRegistration.addItem(vector, USER, stringArray[7]);
        }
        if (stringArray.length > 8) {
            OiTestRegistration.addItem(vector, PASSWORD, stringArray[8]);
        }
        OiTestRegistration oiTestRegistration = new OiTestRegistration();
        String string = (String)oiTestRegistration.performQuery(vector);
        System.out.println(string);
    }
}

