/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Vector;
import oracle.sql.converter.CharacterConverter;

public class CharacterConverter1Byte
extends CharacterConverter {
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    public int m_l1KeyWidth = 0;
    public int m_l1KeyShift = 0;
    int m_l1KeyMask = 0;
    int m_l2KeyMask = 0;
    public char m_ucsReplacement = '\u0000';
    public char[] m_ucsChar = null;
    public char[] m_oraCharLevel1 = null;
    public byte[] m_oraCharLevel2 = null;
    public byte m_oraCharReplacement = 0;
    public char[][] extraUnicodeToOracleMapping = null;

    public CharacterConverter1Byte() {
        this.m_groupId = 0;
    }

    public void buildUnicodeToOracleMapping() {
        int n;
        int n2;
        int n3;
        int n4;
        char c;
        int n5 = this.m_l1KeyWidth;
        int n6 = 16 - n5;
        int n7 = (1 << n5) - 1;
        int n8 = (1 << n6) - 1;
        this.m_l1KeyShift = n6;
        this.m_l1KeyMask = n7;
        this.m_l2KeyMask = n8;
        int n9 = 1 << n5;
        char[] cArray = new char[n9];
        char[][] cArray2 = new char[n9][2];
        int n10 = 0;
        while (n10 < n9) {
            cArray[n10] = '\u0000';
            cArray2[n10][0] = (char)n8;
            cArray2[n10][1] = '\u0000';
            ++n10;
        }
        int n11 = this.m_ucsChar.length;
        char c2 = this.m_ucsReplacement;
        n10 = 0;
        while (n10 < n11) {
            c = this.m_ucsChar[n10];
            if (c != c2) {
                n4 = c >> n6 & n7;
                cArray[n4] = '\u0001';
                n3 = c & n8;
                if (n3 < cArray2[n4][0]) {
                    cArray2[n4][0] = (char)n3;
                }
                if (n3 > cArray2[n4][1]) {
                    cArray2[n4][1] = (char)n3;
                }
            }
            ++n10;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n11 = this.extraUnicodeToOracleMapping.length;
            n10 = 0;
            while (n10 < n11) {
                c = this.extraUnicodeToOracleMapping[n10][0];
                n4 = c >> n6 & n7;
                cArray[n4] = '\u0001';
                n3 = c & n8;
                if (n3 < cArray2[n4][0]) {
                    cArray2[n4][0] = (char)n3;
                }
                if (n3 > cArray2[n4][1]) {
                    cArray2[n4][1] = (char)n3;
                }
                ++n10;
            }
        }
        int n12 = n2 = n8 + 1;
        int n13 = 0;
        n10 = 0;
        while (n10 < n9) {
            if (cArray[n10] != '\u0000') {
                int n14 = cArray2[n10][0];
                cArray[n10] = (char)(n12 - (n13 < n14 ? n13 : n14));
                n12 = cArray[n10] + n2;
                n13 = n2 - cArray2[n10][1] - 1;
            }
            ++n10;
        }
        byte by = this.m_oraCharReplacement;
        byte[] byArray = new byte[n12];
        n10 = 0;
        while (n10 < n12) {
            byArray[n10] = by;
            ++n10;
        }
        n11 = this.m_ucsChar.length;
        n10 = 0;
        while (n10 < n11) {
            c = this.m_ucsChar[n10];
            if (c != c2 && byArray[n = cArray[n4 = c >> n6 & n7] + (n3 = c & n8)] == by) {
                byArray[n] = (byte)n10;
            }
            ++n10;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n11 = this.extraUnicodeToOracleMapping.length;
            n10 = 0;
            while (n10 < n11) {
                c = this.extraUnicodeToOracleMapping[n10][0];
                n4 = c >> n6 & n7;
                n3 = c & n8;
                n = cArray[n4] + n3;
                if (byArray[n] == by) {
                    byArray[n] = (byte)this.extraUnicodeToOracleMapping[n10][1];
                }
                ++n10;
            }
        }
        this.m_oraCharLevel1 = cArray;
        this.m_oraCharLevel2 = byArray;
    }

    public void extractCodepoints(Vector vector) {
        int n = 0;
        int n2 = 255;
        int n3 = n;
        while (n3 <= n2) {
            try {
                int[] nArray = new int[]{n3, this.toUnicode((byte)n3)};
                vector.addElement(nArray);
            }
            catch (SQLException sQLException) {}
            ++n3;
        }
    }

    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        int n = 0;
        while (n < this.extraUnicodeToOracleMapping.length) {
            int[] nArray = new int[]{this.extraUnicodeToOracleMapping[n][0], this.extraUnicodeToOracleMapping[n][1]};
            vector.addElement(nArray);
            ++n;
        }
    }

    public char getOraChar1ByteRep() {
        return (char)this.m_oraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return '\u0000';
    }

    public char getUCS2CharRep() {
        return this.m_ucsReplacement;
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    byte toOracleCharacter(char c) throws SQLException {
        int n = c >> this.m_l1KeyShift & this.m_l1KeyMask;
        int n2 = c & this.m_l2KeyMask;
        byte by = this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n2];
        if (by == this.m_oraCharReplacement) {
            throw new SQLException("Cannot map Unicode to Oracle character.");
        }
        return by;
    }

    byte toOracleCharacterWithReplacement(char c) {
        int n = c >> this.m_l1KeyShift & this.m_l1KeyMask;
        int n2 = c & this.m_l2KeyMask;
        return this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n2];
    }

    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.toOracleCharacter(cArray[n2]);
            ++n2;
        }
        return byArray;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.toOracleCharacterWithReplacement(cArray[n2]);
            ++n2;
        }
        return byArray;
    }

    char toUnicode(byte by) throws SQLException {
        char c = this.m_ucsChar[by & 0xFF];
        if (c == this.m_ucsReplacement) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        return c;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = n + n2;
        char[] cArray = new char[n2];
        int n4 = n;
        int n5 = 0;
        while (n4 < n3) {
            cArray[n5] = this.m_ucsChar[byArray[n4] & 0xFF];
            if (cArray[n5] == this.m_ucsReplacement) {
                throw new SQLException("Cannot map Oracle character to Unicode.");
            }
            ++n4;
            ++n5;
        }
        return new String(cArray);
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        char[] cArray = new char[n2];
        int n4 = n;
        int n5 = 0;
        while (n4 < n3) {
            cArray[n5] = this.m_ucsChar[byArray[n4] & 0xFF];
            ++n4;
            ++n5;
        }
        return new String(cArray);
    }

    char toUnicodeWithReplacement(byte by) {
        return this.m_ucsChar[by & 0xFF];
    }
}

