/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.IOException;
import oracle.sysman.oii.oiic.OiicBaseApp;
import oracle.sysman.oii.oiic.OiicExitCode;
import oracle.sysman.oii.oiic.OiicISession;
import oracle.sysman.oii.oiic.OiicISessionProxy;
import oracle.sysman.oii.oiic.OiicInvalidCmdLineException;
import oracle.sysman.oii.oiic.OiicSessionProvider;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oip.oipc.oipcc.OipccEndPrereqSessionException;
import oracle.sysman.oip.oipc.oipch.OipchBaseHostWriter;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchHostBuilder;
import oracle.sysman.oip.oipc.oipck.OipckIBuilder;
import oracle.sysman.oip.oipc.oipck.OipckIWriter;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcu.OipcuPrereqProps;

public class OipchHostXMLWriter
extends OiicBaseApp
implements OiicISessionProxy,
OiicISession {
    private OiiiInstallAreaControl m_oInstallAreaControl = null;

    public OipchHostXMLWriter(String sAppName) {
        super(sAppName);
    }

    public OiiiInstallInventory getInstallInventory() {
        if (this.m_oInstallAreaControl == null) {
            this.initInstallInventory();
        }
        if (this.m_oInstallAreaControl != null) {
            return this.m_oInstallAreaControl.getInstallInventory();
        }
        return null;
    }

    private void initInstallInventory() {
        try {
            OiiiInstallAreaControl.initAreaControl((int)0);
            this.m_oInstallAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
            this.m_oInstallAreaControl.grabReaderLock();
        }
        catch (OiitTargetLockNotAvailableException e) {
            this.m_oInstallAreaControl = null;
        }
        catch (IOException e) {
            this.m_oInstallAreaControl = null;
        }
        catch (OiiiInventoryDoesNotExistException e) {
            this.m_oInstallAreaControl = null;
        }
    }

    void endSession() {
        if (this.m_oInstallAreaControl != null) {
            this.m_oInstallAreaControl.releaseReaderLock();
        }
        this.m_oInstallAreaControl = null;
    }

    public OiiiInstallAreaControl getInstallAreaControl() {
        return this.m_oInstallAreaControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Object sNullString = null;
        String sOutFile = null;
        OipchHostXMLWriter oWriter = new OipchHostXMLWriter("hostwriter");
        try {
            oWriter.processCommandLine(args);
            if (oWriter.isHelpOptionSpecified()) {
                oWriter.displayHelp();
                System.exit(0);
            }
            sOutFile = System.getProperty("oracle.hostwriter.outFile", null);
            System.out.println("output file =" + sOutFile + ":");
            OiicSessionProvider.setSessionProxy((OiicISessionProxy)oWriter);
            try {
                String sPrereqFile = System.getProperty("oracle.installer.prereqConfigLoc") + "/prerequisite.properties";
                OipcuPrereqProps oProps = new OipcuPrereqProps(sPrereqFile);
            }
            catch (OipccEndPrereqSessionException e) {
                System.out.println(e.getMessage());
                System.exit(-1);
            }
            oWriter.execute(sOutFile);
            OiicExitCode.setExitCode((int)0);
        }
        catch (OiicInvalidCmdLineException e) {
            System.out.println(e.getMessage());
            OiicExitCode.setExitCode((int)-1);
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            OiicExitCode.setExitCode((int)-1);
        }
        finally {
            oWriter.endSession();
            System.exit(OiicExitCode.getExitCode());
        }
    }

    public OiisVariableOwner getContext() {
        return null;
    }

    public OiicISession getCurrentSession() {
        return this;
    }

    private void execute(String sOutFile) {
        String sNullString = null;
        OipckIBuilder oHostBuilder = OipchHostBuilder.getBuilder(sNullString);
        OipchHost oHost = null;
        try {
            oHost = (OipchHost)oHostBuilder.build();
        }
        catch (OipckKnowledgeSourceException e) {
            e.printStackTrace();
        }
        OipckIWriter oMyWriter = OipchBaseHostWriter.getWriter(sOutFile);
        try {
            oMyWriter.save((Object)oHost);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

