/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oii.oiic.OiicSystemPropertyOps;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectVersionFormatException;
import oracle.sysman.oip.oipc.oipch.OipchKernelInfo;
import oracle.sysman.oip.oipc.oipch.OipchKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchLinuxGlibcVersion;
import oracle.sysman.oip.oipc.oipch.OipchLinuxKernelReader;
import oracle.sysman.oip.oipc.oipch.OipchLinuxOS;
import oracle.sysman.oip.oipc.oipch.OipchLinuxOSVersion;
import oracle.sysman.oip.oipc.oipch.OipchLinuxPackageReader;
import oracle.sysman.oip.oipc.oipch.OipchLinuxVersion;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchOSCreator;
import oracle.sysman.oip.oipc.oipch.OipchPackage;
import oracle.sysman.oip.oipc.oipch.OipchVendor;
import oracle.sysman.oix.oixd.OixdDOMReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class OipchLinuxOSCreator
extends OipchOSCreator {
    private static final String LINUX_VENDOR_LIST_FILE = "LinuxVendors.xml";
    private static final String LINUX_VENDOR = "LinuxVendor_output.txt";
    private static final String LINUX_VENDOR_SCRIPT = "ls ";
    private static final String PKGINFO_FILE = "pkginfo.txt";
    private static final String PKGINFO_SCRIPT = "/bin/rpm -qa --queryformat \"%{NAME} %{EPOCH}:%{VERSION}-%{RELEASE} %{ARCH}\n\"";
    private static final String GLIBC_FILE = "glibc.txt";
    private static final String GLIBC_SCRIPT = "/bin/rpm -q glibc --queryformat \"%{EPOCH}:%{VERSION}-%{RELEASE}\n\"";
    private OipchLinuxOS m_oLinuxOS;
    private static final String LINUX_RELEASE_SCRIPT = "/usr/bin/lsb_release -r";
    private static final String LSB_RELEASE_COMMAND_LOCATION = "/usr/bin/lsb_release";
    private static final String LINUX_RELEASE_FILE = "LinuxRelease_output.txt";

    protected OipchLinuxOSCreator(int iPlatID) {
        super(iPlatID);
    }

    protected OipchOS createOS() {
        this.m_oLinuxOS = new OipchLinuxOS();
        this.updateOSInfo();
        return this.m_oLinuxOS;
    }

    protected void updateOSInfo() {
        this.m_oLinuxOS.setPlatformID(OiixPlatform.getCurrentPlatform());
        this.m_oLinuxOS.setOSName(OiixPlatform.getCurrentPlatformOSName());
        this.setOSVendorAndVersion();
        this.m_oLinuxOS.setOSArch(OiixPlatform.getCurrentPlatformArch());
        this.updatePackageInfo();
        this.updateKernelInfo();
        this.updateGlibcInfo();
    }

    private String[] splitString(String Source, String separator) {
        StringTokenizer strtok = new StringTokenizer(Source, separator);
        String[] retArr = new String[strtok.countTokens()];
        int i = 0;
        while (strtok.hasMoreTokens()) {
            retArr[i] = strtok.nextToken();
            ++i;
        }
        return retArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGlibcInfo() {
        String sGlibc = "";
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)GLIBC_FILE);
        File oFile = new File(sFile);
        if (!oFile.exists()) {
            String sParent = OiixPathOps.getParentDir((String)sFile);
            OiixFileOps.mkdirs((File)new File(sParent));
            String sCommand = "/bin/rpm -q glibc --queryformat \"%{EPOCH}:%{VERSION}-%{RELEASE}\n\">" + sFile;
            int result = 0;
            try {
                result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
            }
            catch (OiilNativeException e) {
                // empty catch block
            }
            File oTmpFile = new File(sFile);
            if (!oTmpFile.exists()) {
                return;
            }
        }
        BufferedReader reader = null;
        try {
            String sCurrentGlibc;
            reader = new BufferedReader(new FileReader(sFile));
            sGlibc = sCurrentGlibc = reader.readLine();
            while (sCurrentGlibc != null) {
                try {
                    OipchLinuxVersion ver1 = new OipchLinuxVersion(sGlibc);
                    OipchLinuxVersion ver2 = new OipchLinuxVersion(sCurrentGlibc);
                    if (ver2.compare(ver1) == 4) {
                        sGlibc = sCurrentGlibc;
                    }
                }
                catch (OipchIncorrectVersionFormatException oOivfe) {
                    // empty catch block
                }
                sCurrentGlibc = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        try {
            if (sGlibc != null) {
                this.m_oLinuxOS.setGLibCVersion(new OipchLinuxGlibcVersion(sGlibc));
            }
        }
        catch (OipchIncorrectVersionFormatException e) {
            e.printStackTrace();
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private List getVendorList(String sFile) {
        ArrayList<String> vendorList = new ArrayList<String>();
        try {
            Document oDoc = OixdDOMReader.getDocument((String)sFile);
            Element root = oDoc.getDocumentElement();
            NamedNodeMap oVendMap = root.getAttributes();
            Node oAttrib = oVendMap.getNamedItem("VALUES");
            if (oAttrib != null) {
                StringTokenizer strtok = new StringTokenizer(oAttrib.getNodeValue(), ",");
                while (strtok.hasMoreTokens()) {
                    vendorList.add(strtok.nextToken());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return vendorList;
    }

    private void setOSVendorAndVersion() {
        String sVendors = OiixPathOps.concatPath((String)this.getPrereqLoc(), (String)LINUX_VENDOR_LIST_FILE);
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)LINUX_VENDOR);
        String sCurrentVendor = "";
        File oFile = new File(sVendors);
        if (oFile.exists()) {
            List vendor_list = this.getVendorList(sVendors);
            for (int i = 0; i < vendor_list.size(); ++i) {
                String sParent = OiixPathOps.getParentDir((String)sFile);
                OiixFileOps.mkdirs((File)new File(sParent));
                String sCurrentFile = "/etc/" + (String)vendor_list.get(i) + "-release";
                String sCommand = LINUX_VENDOR_SCRIPT + sCurrentFile + " > " + sFile + " 2>&1";
                int result = 0;
                try {
                    result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
                    File oTmpFile = new File(sFile);
                    if (result != 0 && !oTmpFile.exists()) continue;
                    BufferedReader reader = new BufferedReader(new FileReader(sFile));
                    String sOutput = reader.readLine();
                    reader.close();
                    if (sOutput.indexOf("No such file") >= 0) continue;
                    if (new File(LSB_RELEASE_COMMAND_LOCATION).exists()) {
                        String releaseOutFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)LINUX_RELEASE_FILE);
                        String sReleaseCommand = "/usr/bin/lsb_release -r > " + releaseOutFile + " 2>&1";
                        result = OiipuUnixOps.sysFunctionEnglish((String)sReleaseCommand);
                        File oTmpReleaseFile = new File(releaseOutFile);
                        if (result == 0 || oTmpReleaseFile.exists()) {
                            BufferedReader releaseReader = new BufferedReader(new FileReader(releaseOutFile));
                            String sReleaseOutput = releaseReader.readLine();
                            releaseReader.close();
                            if (sReleaseOutput.indexOf("No such file") < 0) {
                                int index = sReleaseOutput.indexOf(":");
                                if (index == -1) continue;
                                String version = sReleaseOutput.substring(index + 1);
                                this.m_oLinuxOS.setOSVendor(new OipchVendor((String)vendor_list.get(i)));
                                this.m_oLinuxOS.setOSVersion(new OipchLinuxOSVersion((String)vendor_list.get(i) + "-" + version.trim()));
                                break;
                            }
                            BufferedReader etcReader = new BufferedReader(new FileReader(sCurrentFile));
                            this.m_oLinuxOS.setOSVendor(new OipchVendor((String)vendor_list.get(i)));
                            String etcFileLine = etcReader.readLine();
                            etcReader.close();
                            this.m_oLinuxOS.setOSVersion(new OipchLinuxOSVersion((String)vendor_list.get(i) + "-" + etcFileLine));
                            break;
                        }
                        BufferedReader etcReader = new BufferedReader(new FileReader(sCurrentFile));
                        this.m_oLinuxOS.setOSVendor(new OipchVendor((String)vendor_list.get(i)));
                        String etcFileLine = etcReader.readLine();
                        etcReader.close();
                        this.m_oLinuxOS.setOSVersion(new OipchLinuxOSVersion((String)vendor_list.get(i) + "-" + etcFileLine));
                        break;
                    }
                    BufferedReader etcReader = new BufferedReader(new FileReader(sCurrentFile));
                    this.m_oLinuxOS.setOSVendor(new OipchVendor((String)vendor_list.get(i)));
                    String etcFileLine = etcReader.readLine();
                    etcReader.close();
                    this.m_oLinuxOS.setOSVersion(new OipchLinuxOSVersion((String)vendor_list.get(i) + "-" + etcFileLine));
                    break;
                }
                catch (OiilNativeException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                File tmpFile = new File(sFile);
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
            }
            catch (Exception e) {}
        } else {
            return;
        }
    }

    private void updatePackageInfo() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)PKGINFO_FILE);
        File oFile = new File(sFile);
        if (!oFile.exists()) {
            String sParent = OiixPathOps.getParentDir((String)sFile);
            OiixFileOps.mkdirs((File)new File(sParent));
            String sCommand = "/bin/rpm -qa --queryformat \"%{NAME} %{EPOCH}:%{VERSION}-%{RELEASE} %{ARCH}\n\">" + sFile;
            int result = 0;
            try {
                result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
            }
            catch (OiilNativeException e) {
                // empty catch block
            }
            File oTmpFile = new File(sFile);
            if (!oTmpFile.exists()) {
                return;
            }
        }
        try {
            Collection oPackages = null;
            oPackages = OipchLinuxPackageReader.readPackageDetails(sFile);
            Iterator iter = oPackages.iterator();
            while (iter.hasNext()) {
                this.m_oLinuxOS.addPackage((OipchPackage)iter.next());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateKernelInfo() {
        OipchKernelInfo oOSKernelInfo = this.m_oLinuxOS.getKernel();
        try {
            OipchKernelProperty[] oOSKernParams = OipchLinuxKernelReader.getKernelParameters();
            for (int i = 0; i < oOSKernParams.length; ++i) {
                oOSKernelInfo.addProperty(oOSKernParams[i]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getScratchPath() {
        return OiicSystemPropertyOps.getScratchPath();
    }

    private String getPrereqLoc() {
        return OiicSystemPropertyOps.getPrereqLoc();
    }
}

