/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.util.Iterator;
import oracle.sysman.oip.oipc.oipch.OipchIComparable;
import oracle.sysman.oip.oipc.oipch.OipchIComparableConstants;
import oracle.sysman.oip.oipc.oipch.OipchRange;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;

public class OipchRangeSemantics
implements OipchIComparableConstants {
    private static final int LESSEQ = 3;
    private static final int GREATEREQ = 5;

    private OipchRangeSemantics() {
    }

    public static boolean compare(String sAtt, int iCompResult) {
        int iAtt = OipchRangeSemantics.getSemanticToIntegerValue(sAtt);
        if (iAtt == 8 || iCompResult == 8) {
            return false;
        }
        int iAnd = iAtt & iCompResult;
        if (iAnd != 0) {
            return true;
        }
        return iAtt == 0 && (iCompResult == 4 || iCompResult == 2 || iCompResult == 0);
    }

    private static int getSemanticToIntegerValue(String att) {
        if (att.equalsIgnoreCase("EQUALS")) {
            return 1;
        }
        if (att.equalsIgnoreCase("NOT_EQUALS")) {
            return 0;
        }
        if (att.equalsIgnoreCase("GREATER_THAN")) {
            return 4;
        }
        if (att.equalsIgnoreCase("LESS_THAN")) {
            return 2;
        }
        if (att.equalsIgnoreCase("ATMOST")) {
            return 3;
        }
        if (att.equalsIgnoreCase("ATLEAST")) {
            return 5;
        }
        return 8;
    }

    public static boolean isRangeAttribute(String sAtt) {
        int iAtt = OipchRangeSemantics.getSemanticToIntegerValue(sAtt);
        return iAtt != 8;
    }

    public static boolean doComparisons(Iterator oRangeList, OipchIComparable oRefHostInfo, OipchIComparable oHostInfo) throws OixdInvalidDocumentException {
        boolean bSatisfied = false;
        if (oHostInfo != null) {
            bSatisfied = true;
            while (oRangeList.hasNext() && bSatisfied) {
                String sAttName;
                OipchRange oRange = null;
                oRange = (OipchRange)oRangeList.next();
                if (oRange == null || !OipchRangeSemantics.isRangeAttribute(sAttName = oRange.getAttName())) continue;
                oRefHostInfo.setParameter(oRange.getAttValue());
                bSatisfied = OipchRangeSemantics.compare(sAttName, oHostInfo.compare(oRefHostInfo));
            }
        }
        return bSatisfied;
    }
}

