/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.StringTokenizer;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectVersionFormatException;
import oracle.sysman.oip.oipc.oipch.OipchKernelInfo;
import oracle.sysman.oip.oipc.oipch.OipchKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchNumKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchSolarisVersion;
import oracle.sysman.oip.oipc.oipch.OipchStrKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchVerKernelProperty;

public class OipchSolarisKernelReader {
    private static final String S_SYSDEF_COMMENT = "Tunable Parameters";
    private static final String S_VERSION_PROPERTY_NAME = "VER";
    private static final char S_WHITESPACE1 = ' ';
    private static final char S_WHITESPACE2 = '\t';
    private static final char S_OPENING_BRACKET = '(';
    private static final char S_CLOSING_BRACKET = ')';
    private static final char S_SYSDEF_COMMENT_CHAR = '*';

    private OipchSolarisKernelReader() {
    }

    static OipchKernelInfo readKernelInfo(String sFile) throws IOException {
        OipchKernelInfo oKernelInfo = new OipchKernelInfo();
        BufferedReader reader = new BufferedReader(new FileReader(sFile));
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        tokenizer.commentChar(42);
        tokenizer.eolIsSignificant(true);
        tokenizer.parseNumbers();
        tokenizer.slashSlashComments(false);
        tokenizer.slashStarComments(false);
        tokenizer.ordinaryChar(58);
        boolean bEofReached = false;
        int START_STATE = 0;
        int SET_STATE = 1;
        int NAME_STATE = 2;
        int EQUALS_STATE = 3;
        int VALUE_STATE = 4;
        String SET = "set";
        String EQUALS = "=";
        int state = START_STATE;
        String sName = null;
        OipchKernelProperty oKernelProp = null;
        block9: while (!bEofReached) {
            int tkn = tokenizer.nextToken();
            switch (tkn) {
                case -1: {
                    bEofReached = true;
                    continue block9;
                }
                case -3: {
                    String sHex;
                    if (tokenizer.sval.equals(SET)) {
                        state = SET_STATE;
                        sName = "";
                        continue block9;
                    }
                    if (state == SET_STATE) {
                        sName = sName + tokenizer.sval;
                        continue block9;
                    }
                    if (state == EQUALS_STATE) {
                        sHex = "0x";
                        if (tokenizer.sval.toLowerCase().startsWith(sHex)) {
                            try {
                                long lVal = Long.parseLong(tokenizer.sval.substring(sHex.length()), 16);
                                oKernelProp = new OipchNumKernelProperty(sName, new Long(lVal));
                            }
                            catch (NumberFormatException e) {
                                oKernelProp = new OipchStrKernelProperty(sName, tokenizer.sval);
                            }
                        } else {
                            oKernelProp = new OipchStrKernelProperty(sName, tokenizer.sval);
                        }
                        oKernelInfo.addProperty(oKernelProp);
                        state = START_STATE;
                        continue block9;
                    }
                    if (!tokenizer.sval.equals(EQUALS)) continue block9;
                    state = EQUALS_STATE;
                    continue block9;
                }
                case -2: {
                    String sHex = "0x";
                    String hexVal = "";
                    String shmmaxVal = "0xffffffffffffffff";
                    long lVal = 0L;
                    if (tokenizer.nval == 0.0) {
                        hexVal = "0";
                        if (tokenizer.nextToken() == -3) {
                            hexVal = hexVal + tokenizer.sval;
                        } else {
                            tokenizer.pushBack();
                            continue block9;
                        }
                    }
                    if (hexVal.toLowerCase().startsWith(sHex)) {
                        try {
                            lVal = hexVal.equals(shmmaxVal) ? Long.MAX_VALUE : Long.parseLong(hexVal.substring(sHex.length()), 16);
                            oKernelProp = new OipchNumKernelProperty(sName, new Long(lVal));
                        }
                        catch (NumberFormatException e) {
                            oKernelProp = new OipchStrKernelProperty(sName, hexVal);
                        }
                    } else if (state == EQUALS_STATE) {
                        oKernelProp = new OipchNumKernelProperty(sName, new Long((long)tokenizer.nval));
                    }
                    oKernelInfo.addProperty(oKernelProp);
                    state = START_STATE;
                    continue block9;
                }
            }
            if (tokenizer.ttype == 61) {
                state = EQUALS_STATE;
                continue;
            }
            if (state != SET_STATE) continue;
            sName = sName + (char)tokenizer.ttype;
        }
        ((Reader)reader).close();
        return oKernelInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OipchNumKernelProperty getKernelBitSize(String sFile) throws IOException {
        OipchNumKernelProperty oBitSize;
        Long lBitSize = new Long(0L);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sFile));
            String sBitSize = reader.readLine();
            lBitSize = new Long(sBitSize);
            oBitSize = new OipchNumKernelProperty("BIT_SIZE", lBitSize);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return oBitSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OipchKernelInfo getKernelArchVerInfo(String sFile) throws IOException {
        String sArchStr = "Kernel architecture";
        String sVerStr = "Kernel Version";
        OipchKernelInfo oKernelInfo = new OipchKernelInfo();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(sFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf(":");
                if (idx == -1) continue;
                String sLHS = line.substring(0, idx);
                String sRHS = line.substring(idx + 1);
                if (sLHS.equalsIgnoreCase("Kernel architecture")) {
                    OipchStrKernelProperty oKernelProp = new OipchStrKernelProperty("ARCHITECTURE", sRHS.trim());
                    oKernelInfo.addProperty(oKernelProp);
                    continue;
                }
                if (!sLHS.equalsIgnoreCase("Kernel Version")) continue;
                StringTokenizer st = new StringTokenizer(sRHS, " ");
                OipchSolarisVersion oVer = null;
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    try {
                        oVer = new OipchSolarisVersion(s);
                        oVer.setDisplayName(sRHS.trim());
                        break;
                    }
                    catch (OipchIncorrectVersionFormatException e) {
                    }
                }
                if (oVer == null) continue;
                OipchVerKernelProperty oKernelProp = new OipchVerKernelProperty("VERSION", oVer);
                oKernelInfo.addProperty(oKernelProp);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return oKernelInfo;
    }

    static OipchKernelInfo readSysdefKernelInfo(String sFile) throws IOException {
        OipchKernelInfo oKernelInfo = new OipchKernelInfo();
        BufferedReader reader = new BufferedReader(new FileReader(sFile));
        String sLine = null;
        while ((sLine = reader.readLine()).indexOf(S_SYSDEF_COMMENT) == -1) {
        }
        while (sLine != null) {
            OipchKernelProperty oKernelProp = OipchSolarisKernelReader.getKernelPropFromString(sLine);
            if (oKernelProp != null) {
                oKernelInfo.addProperty(oKernelProp);
            }
            sLine = reader.readLine();
        }
        reader.close();
        return oKernelInfo;
    }

    private static OipchKernelProperty getKernelPropFromString(String sLine) {
        char firstChar = sLine.charAt(0);
        if (firstChar != '*') {
            int currentCharIndex = 0;
            char currentChar = sLine.charAt(currentCharIndex);
            while (currentChar == ' ' || currentChar == '\t') {
                currentChar = sLine.charAt(++currentCharIndex);
            }
            sLine = sLine.substring(currentCharIndex);
            String sPropValue = null;
            String sPropName = null;
            int spaceIndex = sLine.indexOf(32);
            int tabIndex = sLine.indexOf(9);
            int blankIndex = -1;
            if (spaceIndex == -1) {
                if (tabIndex != -1) {
                    blankIndex = tabIndex;
                }
            } else {
                blankIndex = tabIndex != -1 ? (tabIndex < spaceIndex ? tabIndex : spaceIndex) : spaceIndex;
            }
            if (blankIndex != -1) {
                sPropValue = sLine.substring(0, blankIndex);
                int firstBracket = sLine.indexOf(40);
                int lastBracket = sLine.indexOf(41);
                if (firstBracket != -1 && lastBracket != -1) {
                    sPropName = sLine.substring(firstBracket + 1, lastBracket);
                }
            }
            if (sPropName != null && sPropValue != null) {
                OipchKernelProperty oKernelProp = null;
                if (sPropName.equals(S_VERSION_PROPERTY_NAME)) {
                    try {
                        OipchSolarisVersion oSolarisVer = new OipchSolarisVersion(sPropValue);
                        oKernelProp = new OipchVerKernelProperty(sPropName, oSolarisVer);
                    }
                    catch (OipchIncorrectVersionFormatException oErr) {
                        oKernelProp = new OipchStrKernelProperty(sPropName, sPropValue);
                    }
                } else {
                    try {
                        long lPropValue = Long.parseLong(sPropValue);
                        oKernelProp = new OipchNumKernelProperty(sPropName, new Long(lPropValue));
                    }
                    catch (NumberFormatException oNfe) {
                        oKernelProp = new OipchStrKernelProperty(sPropName, sPropValue);
                    }
                }
                return oKernelProp;
            }
        }
        return null;
    }
}

