/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.osd.unix.OiipuUnixOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oip.oipc.oipch.OipchKernelInfo;
import oracle.sysman.oip.oipc.oipch.OipchKernelProperty;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchOSCreator;
import oracle.sysman.oip.oipc.oipch.OipchPackage;
import oracle.sysman.oip.oipc.oipch.OipchPatch;
import oracle.sysman.oip.oipc.oipch.OipchSolarisKernelReader;
import oracle.sysman.oip.oipc.oipch.OipchSolarisOS;
import oracle.sysman.oip.oipc.oipch.OipchSolarisPackageReader;
import oracle.sysman.oip.oipc.oipch.OipchSolarisPatchReader;

class OipchSolarisOSCreator
extends OipchOSCreator {
    private static final String OSINFO_FILE = "osinfo.txt";
    private static final String PKGINFO_FILE = "pkginfo.txt";
    private static final String PKGINFO_DETAIL_SCRIPT = "pkginfo -x | cut -f1 -d' ' | xargs pkginfo -l";
    private static final String PKGINFO_SCRIPT = "pkginfo";
    private static final String PKGINFO_TYPE_PROPERTY = "oracle.installer.solaris.package";
    private static final String PKGINFO_TYPE_DETAILED = "detailed";
    private static final String PATCHINFO_FILE = "patchinfo.txt";
    private static final String PATCHINFO_SCRIPT = "showrev -p";
    private static final String PATCHINFO_SCRIPT_INTEL_SOLARIS = "/usr/sbin/patchadd -p";
    private static final String KERNELINFO_FILE = "/etc/system";
    private static final String KERNELINFO_FILE2 = "isainfo.txt";
    private static final String KERNELINFO_SCRIPT2 = "isainfo -b";
    private static final String KERNELINFO_FILE3 = "kernelarchver.txt";
    private static final String KERNELINFO_SCRIPT3 = "showrev | grep 'Kernel'";
    private static final String KERNELINFO_FILE4 = "sysdef.txt";
    private static final String KERNELINFO_SCRIPT4 = "/usr/sbin/sysdef";
    private OipchSolarisOS m_oSolarisOS;

    protected OipchSolarisOSCreator(int iPlatID) {
        super(iPlatID);
    }

    protected OipchOS createOS() {
        this.m_oSolarisOS = new OipchSolarisOS();
        this.updateOSInfo(this.m_oSolarisOS);
        this.updateKernelInfo();
        this.updateKernelInfo2();
        this.updateKernelInfo3();
        this.updateKernelInfo4();
        this.updatePackageInfo();
        this.updatePatchInfo();
        return this.m_oSolarisOS;
    }

    private void updateKernelInfo() {
        try {
            OipchKernelInfo oKernelInfo = OipchSolarisKernelReader.readKernelInfo(KERNELINFO_FILE);
            OipchKernelInfo oOSKernelInfo = this.m_oSolarisOS.getKernel();
            Collection props = oKernelInfo.getProperties();
            Iterator iter = props.iterator();
            while (iter.hasNext()) {
                oOSKernelInfo.addProperty((OipchKernelProperty)iter.next());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void updateKernelInfo2() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)KERNELINFO_FILE2);
        File oFile = new File(sFile);
        if (!oFile.exists()) {
            String sParent = OiixPathOps.getParentDir((String)sFile);
            OiixFileOps.mkdirs((File)new File(sParent));
            String sCommand = "isainfo -b>" + sFile;
            int result = 0;
            try {
                result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
            }
            catch (OiilNativeException e) {
                e.printStackTrace();
            }
            if (result != 0) {
                return;
            }
        }
        OipchKernelInfo oOSKernelInfo = this.m_oSolarisOS.getKernel();
        try {
            oOSKernelInfo.addProperty(OipchSolarisKernelReader.getKernelBitSize(sFile));
            OipchKernelProperty kp = oOSKernelInfo.getProperty("BIT_SIZE");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void updateKernelInfo3() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)KERNELINFO_FILE3);
        File oFile = new File(sFile);
        if (!oFile.exists()) {
            String sParent = OiixPathOps.getParentDir((String)sFile);
            OiixFileOps.mkdirs((File)new File(sParent));
            String sCommand = "showrev | grep 'Kernel'>" + sFile;
            int result = 0;
            try {
                result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
            }
            catch (OiilNativeException e) {
                // empty catch block
            }
            if (result != 0) {
                return;
            }
        }
        try {
            OipchKernelInfo oKernelInfo = OipchSolarisKernelReader.getKernelArchVerInfo(sFile);
            OipchKernelInfo oOSKernelInfo = this.m_oSolarisOS.getKernel();
            Collection props = oKernelInfo.getProperties();
            Iterator iter = props.iterator();
            while (iter.hasNext()) {
                oOSKernelInfo.addProperty((OipchKernelProperty)iter.next());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateKernelInfo4() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)KERNELINFO_FILE4);
        File oFile = new File(sFile);
        if (!oFile.exists()) {
            String sParent = OiixPathOps.getParentDir((String)sFile);
            OiixFileOps.mkdirs((File)new File(sParent));
            String sCommand = "/usr/sbin/sysdef>" + sFile;
            int result = 0;
            try {
                result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
            }
            catch (OiilNativeException e) {
                e.printStackTrace();
            }
            if (result != 0) {
                return;
            }
        }
        try {
            OipchKernelInfo oKernelInfo = OipchSolarisKernelReader.readSysdefKernelInfo(sFile);
            OipchKernelInfo oOSKernelInfo = this.m_oSolarisOS.getKernel();
            Collection props = oKernelInfo.getProperties();
            Iterator iter = props.iterator();
            while (iter.hasNext()) {
                oOSKernelInfo.addProperty((OipchKernelProperty)iter.next());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updatePackageInfo() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)PKGINFO_FILE);
        File oFile = new File(sFile);
        boolean bDetailedPkgInfo = System.getProperty(PKGINFO_TYPE_PROPERTY, "").equalsIgnoreCase(PKGINFO_TYPE_DETAILED);
        if (!oFile.exists()) {
            String sParent = OiixPathOps.getParentDir((String)sFile);
            OiixFileOps.mkdirs((File)new File(sParent));
            String sCommand = bDetailedPkgInfo ? "pkginfo -x | cut -f1 -d' ' | xargs pkginfo -l>" + sFile : "pkginfo>" + sFile;
            int result = 0;
            try {
                result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
            }
            catch (OiilNativeException e) {
                // empty catch block
            }
            if (result != 0) {
                return;
            }
        }
        try {
            Collection oPackages = null;
            oPackages = bDetailedPkgInfo ? OipchSolarisPackageReader.readAllPackageDetails(sFile) : OipchSolarisPackageReader.readPackageDetails(sFile);
            Iterator iter = oPackages.iterator();
            while (iter.hasNext()) {
                this.m_oSolarisOS.addPackage((OipchPackage)iter.next());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void updatePatchInfo() {
        String sFile = OiixPathOps.concatPath((String)this.getScratchPath(), (String)PATCHINFO_FILE);
        File oFile = new File(sFile);
        if (!oFile.exists()) {
            String sParent = OiixPathOps.getParentDir((String)sFile);
            OiixFileOps.mkdirs((File)new File(sParent));
            int iPlat = OiixPlatform.getCurrentPlatform();
            String sCommand = null;
            if (iPlat == 453) {
                sCommand = "showrev -p>" + sFile;
            } else if (iPlat == 173) {
                sCommand = "/usr/sbin/patchadd -p>" + sFile;
            } else {
                return;
            }
            int result = 0;
            try {
                result = OiipuUnixOps.sysFunctionEnglish((String)sCommand);
            }
            catch (OiilNativeException e) {
                // empty catch block
            }
            if (result != 0) {
                return;
            }
        }
        try {
            Collection oPatches = null;
            oPatches = OipchSolarisPatchReader.readPatchDetails(sFile);
            Iterator iter = oPatches.iterator();
            while (iter.hasNext()) {
                this.m_oSolarisOS.addPatch((OipchPatch)iter.next());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            File tmpFile = new File(sFile);
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getScratchPath() {
        return System.getProperty("oracle.installer.scratchPath", "");
    }
}

