/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.text.Collator;
import java.util.Iterator;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.StringComparator;
import oracle.sysman.oii.oiix.OiixAssert;
import oracle.sysman.oii.oiix.OiixInvalidDataException;
import oracle.sysman.oii.oiix.OiixSet;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectPatchFormatException;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectVersionFormatException;
import oracle.sysman.oip.oipc.oipch.OipchPatch;
import oracle.sysman.oip.oipc.oipch.OipchSolarisVersion;

public class OipchSolarisPatch
extends OipchPatch {
    private OipchSolarisVersion m_oPatch;
    private OiixSet m_oObsoletedPatches;
    private OiixSet m_oRequiredPatches;
    private OiixSet m_oIncompatiblePatches;
    private OiixSet m_oPackages;
    static final char VERSION_SEPARATOR = '-';

    OipchSolarisPatch(String ver) throws OipchIncorrectPatchFormatException {
        try {
            this.m_oPatch = new OipchSolarisVersion(ver);
        }
        catch (OipchIncorrectVersionFormatException e) {
            throw new OipchIncorrectPatchFormatException((Throwable)((Object)e));
        }
    }

    public int compare(Object other) {
        int iResult = 8;
        if (other != null) {
            if (other == this) {
                iResult = 1;
            } else if (other instanceof OipchSolarisPatch) {
                OipchSolarisPatch oPatch = (OipchSolarisPatch)other;
                int iCompare = this.m_oPatch.compare(oPatch.getVersion());
                if (iCompare == 1 || iCompare == 4 || iCompare == 2) {
                    iResult = iCompare;
                } else if (iCompare == 8 && this.m_oObsoletedPatches != null) {
                    Iterator iter = this.m_oObsoletedPatches.iterator();
                    while (iter.hasNext()) {
                        OipchSolarisPatch oObsPatch = (OipchSolarisPatch)iter.next();
                        int iObsCompare = oObsPatch.compare(other);
                        if (iObsCompare != 1 && iObsCompare != 4 && iObsCompare != 2) continue;
                        iResult = iObsCompare;
                        break;
                    }
                }
            }
        }
        return iResult;
    }

    public boolean isCompatible(Object obj) {
        int iCompare = this.compare(obj);
        return iCompare == 1 || iCompare == 4;
    }

    public String getDisplayName() {
        return this.m_oPatch.getDisplayName();
    }

    OipchSolarisVersion getVersion() {
        return this.m_oPatch;
    }

    public Iterator getObsoletedPatches() {
        return this.m_oObsoletedPatches == null ? null : this.m_oObsoletedPatches.iterator();
    }

    public Iterator getPackages() {
        return this.m_oPackages == null ? null : this.m_oPackages.iterator();
    }

    public Iterator getRequiredPatches() {
        return this.m_oRequiredPatches == null ? null : this.m_oRequiredPatches.iterator();
    }

    public Iterator getIncompatiblePatches() {
        return this.m_oIncompatiblePatches == null ? null : this.m_oIncompatiblePatches.iterator();
    }

    OipchSolarisPatch addObsoletePatch(OipchSolarisPatch patch) {
        OipchSolarisPatch oPatch = null;
        if (this.m_oObsoletedPatches == null) {
            try {
                this.m_oObsoletedPatches = new OiixSet(this.getClass().getName());
            }
            catch (OiixInvalidDataException e) {
                OiixAssert.assertion((boolean)true, (String)e.getMessage());
            }
        }
        try {
            oPatch = (OipchSolarisPatch)this.m_oObsoletedPatches.addElement((Object)patch);
        }
        catch (OiixInvalidDataException e) {
            OiixAssert.assertion((boolean)true, (String)e.getMessage());
        }
        return oPatch;
    }

    OipchSolarisPatch addRequiredPatch(OipchSolarisPatch patch) {
        OipchSolarisPatch oPatch = null;
        if (this.m_oRequiredPatches == null) {
            try {
                this.m_oRequiredPatches = new OiixSet(this.getClass().getName());
            }
            catch (OiixInvalidDataException e) {
                OiixAssert.assertion((boolean)true, (String)e.getMessage());
            }
        }
        try {
            oPatch = (OipchSolarisPatch)this.m_oRequiredPatches.addElement((Object)patch);
        }
        catch (OiixInvalidDataException e) {
            OiixAssert.assertion((boolean)true, (String)e.getMessage());
        }
        return oPatch;
    }

    OipchSolarisPatch addIncompatiblePatch(OipchSolarisPatch patch) {
        OipchSolarisPatch oPatch = null;
        if (this.m_oIncompatiblePatches == null) {
            try {
                this.m_oIncompatiblePatches = new OiixSet(this.getClass().getName());
            }
            catch (OiixInvalidDataException e) {
                OiixAssert.assertion((boolean)true, (String)e.getMessage());
            }
        }
        try {
            oPatch = (OipchSolarisPatch)this.m_oIncompatiblePatches.addElement((Object)patch);
        }
        catch (OiixInvalidDataException e) {
            OiixAssert.assertion((boolean)true, (String)e.getMessage());
        }
        return oPatch;
    }

    String addPackage(String sPackage) {
        String sPkg = null;
        if (this.m_oPackages == null) {
            try {
                this.m_oPackages = new OiixSet(String.class.getName(), (Comparator)new StringComparator(Collator.getInstance()));
            }
            catch (OiixInvalidDataException e) {
                OiixAssert.assertion((boolean)true, (String)e.getMessage());
            }
        }
        try {
            sPkg = (String)this.m_oPackages.addElement((Object)sPackage);
        }
        catch (OiixInvalidDataException e) {
            OiixAssert.assertion((boolean)true, (String)e.getMessage());
        }
        return sPkg;
    }

    public void setParameter(String sParam) {
        this.m_oPatch.setParameter(sParam);
    }
}

