/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiin.OiinNetOps;
import oracle.sysman.oii.oiip.oiipg.OiipgCRSClusterwareInfo;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterwareInfo;
import oracle.sysman.oii.oiip.oiipg.OiipgMemory;
import oracle.sysman.oii.oiip.oiipg.OiipgNetwork;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oip.oipc.oipch.OipchAIXSystemCreator;
import oracle.sysman.oip.oipc.oipch.OipchClusterDetails;
import oracle.sysman.oip.oipc.oipch.OipchDECSystemCreator;
import oracle.sysman.oip.oipc.oipch.OipchEnvironmentDetails;
import oracle.sysman.oip.oipc.oipch.OipchHPSystemCreator;
import oracle.sysman.oip.oipc.oipch.OipchLinuxSystemCreator;
import oracle.sysman.oip.oipc.oipch.OipchMemory;
import oracle.sysman.oip.oipc.oipch.OipchNIC;
import oracle.sysman.oip.oipc.oipch.OipchNetworkDetails;
import oracle.sysman.oip.oipc.oipch.OipchOracleHomes;
import oracle.sysman.oip.oipc.oipch.OipchSolarisSystemCreator;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipch.OipchUser;
import oracle.sysman.oip.oipc.oipch.OipchWindowsSystemCreator;

public abstract class OipchSystemCreator {
    protected OipchSystem m_oSystem;
    protected int m_iPlatID = 0;

    protected OipchSystemCreator(int iPlatID) {
        this.m_iPlatID = iPlatID;
    }

    protected abstract OipchSystem createSystem();

    public static OipchSystemCreator getCreator() {
        OipchSystemCreator oSystemCreator = null;
        int iPlat = OiixPlatform.getCurrentPlatform();
        switch (iPlat) {
            case 453: {
                oSystemCreator = new OipchSolarisSystemCreator(iPlat);
                break;
            }
            case 2: 
            case 197: {
                oSystemCreator = new OipchHPSystemCreator(iPlat);
                break;
            }
            case 610: {
                oSystemCreator = new OipchAIXSystemCreator(iPlat);
                break;
            }
            case 87: {
                oSystemCreator = new OipchDECSystemCreator(iPlat);
                break;
            }
            case 46: 
            case 110: 
            case 211: 
            case 227: {
                oSystemCreator = new OipchLinuxSystemCreator(iPlat);
                break;
            }
            case 208: 
            case 233: 
            case 912: {
                oSystemCreator = new OipchWindowsSystemCreator(iPlat);
            }
        }
        return oSystemCreator;
    }

    final OipchSystem getSystem() {
        if (this.m_oSystem == null) {
            this.m_oSystem = this.createSystem();
        }
        return this.m_oSystem;
    }

    public abstract OipchUser updateUserAndGroup(OipchSystem var1, String var2);

    protected void updateMemoryInfo(OipchSystem oSystem) {
        OipchMemory oAvblMem = new OipchMemory();
        oAvblMem.setSize(OiipgMemory.getAvailablePhysicalMemory(), 0);
        oSystem.setAvailableMemory(oAvblMem);
        OipchMemory oTotalMem = new OipchMemory();
        oTotalMem.setSize(OiipgMemory.getTotalPhysicalMemory(), 0);
        oSystem.setPhysicalMemory(oTotalMem);
    }

    protected void updateEnvVarsInfo(OipchSystem oSystem) {
        String[] asDefaultEnvVars = new String[]{"PATH", "CLASSPATH", "LD_LIBRARY_PATH", "TEMP", "TMP", "TMPDIR", "ORACLE_HOME"};
        OipchEnvironmentDetails oEnvDetails = oSystem.getEnvironmentDetails();
        for (int i = 0; i < asDefaultEnvVars.length; ++i) {
            String sVal = OiixEnvironmentOps.getEnv((String)asDefaultEnvVars[i]);
            oEnvDetails.setProperty(asDefaultEnvVars[i], sVal);
        }
    }

    protected void updateClusterInfo(OipchSystem oSystem) {
        OipchClusterDetails oClusterDetails = new OipchClusterDetails();
        OipchOracleHomes oh = new OipchOracleHomes();
        oh.getInstallInventory();
        oClusterDetails.setCRS(false);
        oClusterDetails.setVendorClusterware(false);
        OiipgClusterwareInfo oClusterInfo = OiipgClusterwareInfo.getClusterwareInfo();
        if (oClusterInfo instanceof OiipgCRSClusterwareInfo) {
            oClusterDetails.setCRS(oClusterInfo.isCluster());
        }
        oClusterDetails.setVendorClusterware(oClusterInfo.isVendorClusterwarePresent());
        oClusterDetails.setNodes(oClusterInfo.getNodeNames());
        oSystem.setClusterDetails(oClusterDetails);
    }

    protected void updateNetworkDetails(OipchSystem oSystem) {
        OipchNetworkDetails oNetworkDetails = new OipchNetworkDetails();
        OiinNetOps oNetOps = OiinNetOps.getNetOps();
        oNetworkDetails.setHostName(oNetOps.getHostName());
        oNetworkDetails.setHostAddress(oNetOps.getHostAddress());
        List oNICs = this.getNICs();
        oNetworkDetails.setHostNICs(oNICs);
        oSystem.setNetworkDetails(oNetworkDetails);
    }

    private List getNICs() {
        String[] asNics = null;
        ArrayList<OipchNIC> oList = new ArrayList<OipchNIC>();
        try {
            asNics = OiipgNetwork.getNetworkInterfaceList();
            if (asNics != null && asNics.length > 0) {
                for (int i = 0; i < asNics.length; ++i) {
                    StringTokenizer st = new StringTokenizer(asNics[i], ":");
                    String sName = st.nextToken();
                    String sIP = st.nextToken();
                    String sMask = st.nextToken();
                    OipchNIC oNIC = new OipchNIC();
                    oNIC.setName(sName);
                    oNIC.setSubnet(sIP);
                    oNIC.setMask(sMask);
                    if (OiipgNetwork.areInterfacesPrivate((String[])new String[]{sName})) {
                        oNIC.setType("PRIVATE");
                    } else {
                        oNIC.setType("PUBLIC");
                    }
                    oList.add(oNIC);
                }
            }
        }
        catch (OiilNativeException oiilNativeException) {
            // empty catch block
        }
        return oList;
    }

    protected String getScratchPath() {
        return System.getProperty("oracle.installer.scratchPath", "");
    }
}

