/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.sysman.oip.oipc.oipch.OipchIComparable;
import oracle.sysman.oip.oipc.oipch.OipchICompatComparable;
import oracle.sysman.oip.oipc.oipch.OipchIDisplayable;

public class OipchVersion
implements OipchICompatComparable,
OipchIDisplayable,
OipchIComparable {
    private String m_sVersion;
    private String m_sDisplayVersion;
    private static final String S_DOT = ".";
    private static final int ALL_TRAILING_ZEROS = 0;
    private static final int ALL_TRAILING_ZEROS_WITH_CHAR = 1;
    private static final int NON_TRAILING_ZEROS = 2;

    public OipchVersion(String sVer) {
        this(sVer, sVer);
    }

    OipchVersion(String sDisplayVersion, String sVer) {
        this.m_sDisplayVersion = sDisplayVersion;
        this.m_sVersion = sVer;
    }

    public int compare(Object other) {
        int iResult = 8;
        if (other != null) {
            if (this == other) {
                iResult = 1;
            } else if (other instanceof OipchVersion) {
                OipchVersion v = (OipchVersion)other;
                iResult = this.compare(v);
            } else {
                iResult = 8;
            }
        }
        return iResult;
    }

    public boolean isCompatible(Object other) {
        int iret;
        boolean bRet = false;
        if (other != null && other instanceof OipchVersion && ((iret = this.compare((OipchVersion)other)) == 1 || iret == 4)) {
            bRet = true;
        }
        return bRet;
    }

    public String getDisplayName() {
        return this.m_sDisplayVersion == null ? this.m_sVersion : this.m_sDisplayVersion;
    }

    public String getVersion() {
        return this.m_sVersion;
    }

    private int compare(OipchVersion other) {
        int i;
        int retVal = 2;
        List digs1 = this.getVerDigits(this.getVersion(), S_DOT);
        List digs2 = this.getVerDigits(other.getVersion(), S_DOT);
        int numdigs1 = digs1.size();
        int numdigs2 = digs2.size();
        int numiter = Math.min(numdigs1, numdigs2);
        for (i = 0; i < numiter; ++i) {
            int comp = this.partCompare((String)digs1.get(i), (String)digs2.get(i), false);
            if (comp != 1) {
                if (comp == 4) {
                    retVal = 4;
                    break;
                }
                if (comp != 2) break;
                retVal = 2;
                break;
            }
            retVal = 1;
        }
        if (retVal == 1 && i == numiter) {
            if (numdigs1 > numiter) {
                if (this.areAllTrailingZeros(digs1, numiter) != 0) {
                    retVal = 4;
                }
            } else if (numdigs2 > numiter && this.areAllTrailingZeros(digs2, numiter) != 0) {
                retVal = 2;
            }
        }
        return retVal;
    }

    private int areAllTrailingZeros(List digitList, int start) {
        int iRet = 0;
        for (int j = start; j < digitList.size(); ++j) {
            String verPart = (String)digitList.get(j);
            int dig = (int)this.digitValue(verPart, false);
            if (dig != 0) {
                iRet = 2;
                break;
            }
            char c = verPart.charAt(verPart.length() - 1);
            if (!Character.isLetter(c)) continue;
            iRet = 1;
            break;
        }
        return iRet;
    }

    private int partCompare(String ver1pt, String ver2pt, boolean bMkFraction) {
        int retval;
        double dig2;
        double dig1 = this.digitValue(ver1pt, bMkFraction);
        double diff = dig1 - (dig2 = this.digitValue(ver2pt, bMkFraction));
        int n = diff < 0.0 ? 2 : (retval = diff == 0.0 ? 1 : 4);
        if (retval == 1) {
            int pt1len = ver1pt.length();
            char pt1lc = ver1pt.charAt(pt1len - 1);
            boolean pt1let = Character.isLetter(pt1lc);
            int pt2len = ver2pt.length();
            char pt2lc = ver2pt.charAt(pt2len - 1);
            boolean pt2let = Character.isLetter(pt2lc);
            if (pt1let || pt2let) {
                String pt2ls;
                String pt1ls;
                int iret;
                retval = pt1let && pt2let ? ((iret = (pt1ls = String.valueOf(Character.toUpperCase(pt1lc))).compareTo(pt2ls = String.valueOf(Character.toUpperCase(pt2lc)))) == -1 ? 2 : (iret == 0 ? 1 : 4)) : (pt1let ? 4 : 2);
            }
        }
        return retval;
    }

    private double digitValue(String verPart, boolean makeFraction) {
        int verPartLen = verPart.length();
        char lastChar = verPart.charAt(verPartLen - 1);
        if (!Character.isDigit(lastChar)) {
            verPart = verPart.substring(0, verPartLen - 1);
        }
        if (makeFraction) {
            verPart = S_DOT + verPart;
        }
        return Double.valueOf(verPart);
    }

    private List getVerDigits(String verStr, String sDelims) {
        ArrayList<String> retVect = new ArrayList<String>();
        if (verStr != null && verStr.length() > 0) {
            verStr = verStr.replace('-', '.');
            if (sDelims == null) {
                sDelims = S_DOT;
            }
            StringTokenizer st = new StringTokenizer(verStr, sDelims);
            while (st.hasMoreTokens()) {
                retVect.add(st.nextToken());
            }
        }
        return retVect;
    }

    public boolean equals(Object obj) {
        return this.compare((OipchIComparable)obj) == 1;
    }

    public int hashCode() {
        return this.m_sVersion.hashCode();
    }

    public String toString() {
        return this.getVersion();
    }

    public void setParameter(String sParam) {
        this.m_sVersion = sParam;
    }

    protected void setVersion(String version) {
        this.m_sVersion = version;
    }
}

