/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiix.OiixRegistryOps;
import oracle.sysman.oip.oipc.oipch.OipchCPU;
import oracle.sysman.oip.oipc.oipch.OipchMemory;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipch.OipchSystemCreator;
import oracle.sysman.oip.oipc.oipch.OipchUser;

public class OipchWindowsSystemCreator
extends OipchSystemCreator {
    OipchWindowsSystemCreator(int iPlatID) {
        super(iPlatID);
    }

    public OipchSystem createSystem() {
        OipchSystem oSystem = new OipchSystem();
        this.updateCPUInfo(oSystem);
        this.updateMemoryInfo(oSystem);
        this.updateSwapSpaceInfo(oSystem);
        this.updateDisplayInfo(oSystem);
        this.updateEnvVarsInfo(oSystem);
        if (Boolean.getBoolean("oracle.installer.advancedHost")) {
            this.updateClusterInfo(oSystem);
            this.updateNetworkDetails(oSystem);
        }
        return oSystem;
    }

    public OipchUser updateUserAndGroup(OipchSystem oSystem, String sUser) {
        OipchUser oUser = null;
        return oUser;
    }

    private void updateCPUInfo(OipchSystem oSystem) {
        long lSpeed = 0L;
        try {
            lSpeed = OiixRegistryOps.RegGetNumValuew32((String)"HKEY_LOCAL_MACHINE", (String)"Hardware\\Description\\System\\CentralProcessor\\0", (String)"~Mhz");
        }
        catch (OiilNativeException e) {
            e.printStackTrace();
        }
        OipchCPU oCPU = new OipchCPU();
        oCPU.setSpeedInMhz(lSpeed);
        oSystem.addCPU(oCPU);
    }

    private void updateDisplayInfo(OipchSystem oSystem) {
    }

    private void updateSwapSpaceInfo(OipchSystem oSystem) {
        long lSwapSpace = OiipwWin32NativeCalls.ssGetAvailableSwapMemoryw32();
        OipchMemory oSwap = new OipchMemory();
        oSwap.setSize(lSwapSpace, 0);
        oSystem.setSwapSpace(oSwap);
    }
}

