/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcz;

import java.util.ArrayList;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchIncorrectVersionFormatException;
import oracle.sysman.oip.oipc.oipch.OipchInverseRangeList;
import oracle.sysman.oip.oipc.oipch.OipchLinuxGlibcVersion;
import oracle.sysman.oip.oipc.oipch.OipchLinuxOS;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchRangeList;
import oracle.sysman.oip.oipc.oipch.OipchRangeSemantics;
import oracle.sysman.oip.oipc.oipch.OipchVersion;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OipczGlibcChecks {
    private OipczGlibcChecks() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OipcrIResult checkGlibc(OipcrIRulesEngine oRulesEngine, String sRefFile) throws OixdInvalidDocumentException {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine == null) return OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        try {
            OipchLinuxOS oOS;
            OipchLinuxGlibcVersion oGlibc;
            OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
            OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
            OipchOS oGeneralOS = oHost.getOS();
            int iPlatID = oGeneralOS.getPlatformID();
            if (iPlatID != 46 && iPlatID != 110) {
                if (iPlatID != 211) return OipcrResult.NOT_EXECUTED_RESULT;
            }
            if ((oGlibc = (oOS = (OipchLinuxOS)oGeneralOS).getGLibCVersion()) == null) return OipcrResult.FAILED_RESULT;
            OipchVersion oVer = oGeneralOS.getOSVersion();
            Node oOSNode = oGenRefHost.getOSNode(oVer);
            if (oOSNode != null) {
                Node oGlibcNode = oGenRefHost.getNode("GLIBC", oOSNode);
                if (oGlibcNode == null) return OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("S_NO_GLIBC_INFO", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"S_NO_GLIBC_INFO")));
                NamedNodeMap oNodeAttribs = oGlibcNode.getAttributes();
                if (oNodeAttribs != null) {
                    return OipczGlibcChecks.doSemanticCheck(oGlibcNode, oGlibc);
                }
                Object[] args = new String[]{"GLIBC"};
                throw new OixdInvalidDocumentException("OUI-11202", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11202", (Object[])args));
            }
            Object[] args = new String[]{oOS == null ? OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ004") : oOS.getOSName(), oVer == null ? OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ005") : oOS.getOSVersion().getDisplayName()};
            return OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-18001", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OUI-18001", (Object[])args)));
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
    }

    private static OipcrResult doSemanticCheck(Node oGlibcNode, OipchLinuxGlibcVersion oGlibc) throws OixdInvalidDocumentException {
        boolean bExclude;
        NamedNodeMap oAttribs = oGlibcNode.getAttributes();
        OipchRangeList oRangeList = new OipchRangeList(oAttribs);
        ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
        OipcrIResult oRes = null;
        String sActualGlibc = oGlibc.getDisplayName();
        StringBuffer sExpectedGlibc = new StringBuffer(oRangeList.toString());
        OipchLinuxGlibcVersion oRefGlibc = null;
        try {
            oRefGlibc = new OipchLinuxGlibcVersion("1");
        }
        catch (OipchIncorrectVersionFormatException e) {
            // empty catch block
        }
        boolean bSatisfied = OipchRangeSemantics.doComparisons(oRangeList.getRangeList(), oRefGlibc, oGlibc);
        oRes = bSatisfied ? ((bExclude = OipczGlibcChecks.doExcludeCheck(oGlibcNode, oGlibc, sExpectedGlibc)) ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT) : OipcrResult.FAILED_RESULT;
        oResDetails.add(new OipcrResultDetails((Object)sActualGlibc, (Object)sExpectedGlibc, oRes));
        return new OipcrResult(oResDetails);
    }

    private static boolean doExcludeCheck(Node oGlibcNode, OipchLinuxGlibcVersion oGlibc, StringBuffer sExpectedGlibc) throws OixdInvalidDocumentException {
        boolean bExclude = true;
        NodeList oExcludeNodes = oGlibcNode.getChildNodes();
        OipchLinuxGlibcVersion oRefGlibc = null;
        try {
            oRefGlibc = new OipchLinuxGlibcVersion("1");
        }
        catch (OipchIncorrectVersionFormatException e) {
            // empty catch block
        }
        if (oExcludeNodes != null) {
            int nExcludeNodes = oExcludeNodes.getLength();
            NamedNodeMap oExcludeNodeAttribs = null;
            for (int i = 0; i < nExcludeNodes && bExclude; ++i) {
                Node oExcludeNode = oExcludeNodes.item(i);
                if (oExcludeNode.getNodeType() != 1 || !oExcludeNode.getNodeName().equalsIgnoreCase("EXCLUDE") || (oExcludeNodeAttribs = oExcludeNode.getAttributes()) == null) continue;
                OipchInverseRangeList oInvRangeList = new OipchInverseRangeList(oExcludeNodeAttribs);
                sExpectedGlibc.append(oInvRangeList.toString());
                bExclude = OipchRangeSemantics.doComparisons(oInvRangeList.getRangeList(), oRefGlibc, oGlibc);
                oInvRangeList = null;
            }
        }
        return bExclude;
    }
}

