/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcz;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchLinuxOS;
import oracle.sysman.oip.oipc.oipch.OipchLinuxOSVersion;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchRefHost;
import oracle.sysman.oip.oipc.oipch.OipchVersion;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;

public class OipczOSChecks {
    public static final String SEPARATOR = ",";

    private OipczOSChecks() {
    }

    public static OipcrIResult checkCertifiedOSVersions(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine != null) {
            try {
                OipchRefHost oRefhost = (OipchRefHost)oRulesEngine.getRefKnowledgeSource("refhost", sRefFile);
                OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                OipchOS oOS = oHost.getOS();
                OipchVersion oVer = oOS.getOSVersion();
                Iterator oVers = oRefhost.getOSVersions();
                ArrayList<String> oList = new ArrayList<String>();
                while (oVers.hasNext()) {
                    OipchVersion v = (OipchVersion)oVers.next();
                    oList.add(v.getDisplayName());
                    if (oResult == OipcrResult.PASSED_RESULT) continue;
                    OipchOS oRefOS = oRefhost.getOSForVersion(v);
                    if (oOS.getPlatformID() == oRefOS.getPlatformID() && oVer != null && oVer.compare((Object)v) == 1) {
                        oResult = OipcrResult.PASSED_RESULT;
                        if (oOS.getPlatformID() != 46 && oOS.getPlatformID() != 227) continue;
                        OipchLinuxOS oLnxOS = (OipchLinuxOS)oOS;
                        OipchLinuxOSVersion lnxVer = new OipchLinuxOSVersion(v.getVersion());
                        oLnxOS.setOSVersion(lnxVer);
                        oVer = lnxVer;
                        continue;
                    }
                    oResult = OipcrResult.FAILED_RESULT;
                }
                String[] asVers = new String[oList.size()];
                asVers = oList.toArray(asVers);
                Object[] args = new String[]{OiixFunctionOps.implodeList((String[])asVers, (String)SEPARATOR)};
                String sExpectedValue = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ0001", (Object[])args);
                String sActualValue = oVer == null ? OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ005") : oVer.getDisplayName();
                OipcrResultDetails oResData = new OipcrResultDetails((Object)sActualValue, (Object)sExpectedValue, oResult);
                ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                oResDetails.add(oResData);
                oResult = new OipcrResult(oResDetails);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }
}

