/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcz;

import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchRefHost;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;

public class OipczRunlevelChecks {
    private OipczRunlevelChecks() {
    }

    public static OipcrIResult checkDefaultRunlevel(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        return OipczRunlevelChecks.checkRunlevel(oRulesEngine, sRefFile, true);
    }

    public static OipcrIResult checkCurrentRunlevel(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        return OipczRunlevelChecks.checkRunlevel(oRulesEngine, sRefFile, false);
    }

    private static OipcrIResult checkRunlevel(OipcrIRulesEngine oRulesEngine, String sRefFile, boolean bDefault) {
        OipcrIResult oResult;
        block11: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    OipchRefHost oRefhost = (OipchRefHost)oRulesEngine.getRefKnowledgeSource("refhost", sRefFile);
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    OipchSystem oSystem = oHost.getSystem();
                    OipchSystem oRefSystem = oRefhost.getSystem();
                    if (oRefSystem != null) {
                        String oExpectedRunlevel = "";
                        String oRunlevel = "";
                        ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>(1);
                        if (bDefault) {
                            oExpectedRunlevel = oRefSystem.getDefaultRunlevel();
                            oRunlevel = oSystem.getDefaultRunlevel();
                        } else {
                            oExpectedRunlevel = oRefSystem.getCurrentRunlevel();
                            oRunlevel = oSystem.getCurrentRunlevel();
                        }
                        if (!oRefSystem.isRunlevelInitialized(oExpectedRunlevel)) {
                            Object[] args = new String[]{bDefault ? "Default runlevel" : "Current runlevel"};
                            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("S_NO_EXPECTED_RUNLEVEL", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"S_NO_EXPECTED_RUNLEVEL", (Object[])args)));
                            return oResult;
                        }
                        boolean bMatch = OipczRunlevelChecks.isRunlevelExpected(oRunlevel, oExpectedRunlevel);
                        oResult = bMatch ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                        oResDetails.add(new OipcrResultDetails((Object)oRunlevel, (Object)oExpectedRunlevel, oResult));
                        oResult = new OipcrResult(oResDetails);
                        break block11;
                    }
                    oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-18003", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OUI-18003")));
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    private static boolean isRunlevelExpected(String actualRunlevel, String expectedRunlevel) {
        StringTokenizer st = new StringTokenizer(expectedRunlevel, ",");
        while (st.hasMoreTokens()) {
            String runlevel = st.nextToken();
            if (!runlevel.equals(actualRunlevel)) continue;
            return true;
        }
        return false;
    }
}

