/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcz;

import java.util.ArrayList;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchDescriptor;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchMaxproc;
import oracle.sysman.oip.oipc.oipch.OipchShell;
import oracle.sysman.oip.oipc.oipch.OipchStack;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OipczShellLimitChecks {
    private OipczShellLimitChecks() {
    }

    public static OipcrIResult checkShellLimits(OipcrIRulesEngine oRulesEngine, String sRefFile) throws OixdInvalidDocumentException {
        OipcrIResult oResult;
        block40: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            String S_UNLIMITED = "UNLIMITED";
            if (oRulesEngine != null) {
                try {
                    String Shell = null;
                    OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    OipchSystem oSystem = oHost.getSystem();
                    ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                    OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
                    OiisVariable oVar = oContext.getVariable("SHELLNAME");
                    if (oVar != null) {
                        Shell = (String)oVar.getValue();
                        Shell = Shell.trim();
                        Shell = Shell.toLowerCase();
                    }
                    if (Shell != null) {
                        if (Shell.startsWith("/bin/")) {
                            Shell = OipczShellLimitChecks.getCommonShellName(Shell).toLowerCase();
                            Shell = Shell.trim();
                        }
                    } else {
                        String sEnvVar = "SHELL";
                        Shell = OiixEnvironmentOps.getEnv((String)sEnvVar);
                        Shell = OipczShellLimitChecks.getCommonShellName(Shell).toLowerCase();
                    }
                    OipchShell oRefHost = new OipchShell(Shell);
                    Node oShellLimitNode = oGenRefHost.getNode("SYSTEM/SHELL_LIMIT_CHECKS");
                    if (Shell.equalsIgnoreCase("ash") || Shell.equalsIgnoreCase("bash") || Shell.equalsIgnoreCase("bsh") || Shell.equalsIgnoreCase("csh") || Shell.equalsIgnoreCase("ksh") || Shell.equalsIgnoreCase("tcsh") || Shell.equalsIgnoreCase("zsh") || Shell.equalsIgnoreCase("sh")) {
                        if (oShellLimitNode != null) {
                            oRefHost = OipczShellLimitChecks.addShellLimitDetails(Shell, oShellLimitNode);
                            if (oRefHost != null) {
                                OipchShell oActualHost = oSystem.getShell(Shell.toLowerCase());
                                String sActualValue = "";
                                String sExpectedValueString = "";
                                int softmaxprocVal = oActualHost.getMaxproc().softCompare(oRefHost);
                                int hardmaxprocVal = oActualHost.getMaxproc().hardCompare(oRefHost);
                                String actualSoftVal = "Maxproc SoftLimit Value " + oActualHost.getMaxproc().getSoftMaxProc();
                                String refValSoft = "Maxproc SoftLimit Value " + oRefHost.getMaxproc().getSoftMaxProc();
                                String actualValHard = "Maxproc HardLimit Value " + oActualHost.getMaxproc().getHardMaxProc();
                                String refValhard = "Maxproc HardLimit Value " + oRefHost.getMaxproc().getHardMaxProc();
                                if (oRefHost.getMaxproc().getHardOperatorMaxproc() != null && oRefHost.getMaxproc().getHardOperatorMaxproc().equalsIgnoreCase("ATLEAST")) {
                                    refValhard = "Maxproc HardLimit Value " + oRefHost.getMaxproc().getHardMaxProc();
                                } else if (oRefHost.getMaxproc().getHardOperatorMaxproc() != null && oRefHost.getMaxproc().getHardOperatorMaxproc().equalsIgnoreCase("ATMOST")) {
                                    refValhard = "Maxproc HardLimit Value ATMOST " + oRefHost.getMaxproc().getHardMaxProc();
                                }
                                if (oRefHost.getMaxproc().getSoftOperatorMaxproc() != null && oRefHost.getMaxproc().getSoftOperatorMaxproc().equalsIgnoreCase("ATLEAST")) {
                                    refValSoft = "Maxproc SoftLimit Value " + oRefHost.getMaxproc().getSoftMaxProc();
                                } else if (oRefHost.getMaxproc().getSoftOperatorMaxproc() != null && oRefHost.getMaxproc().getSoftOperatorMaxproc().equalsIgnoreCase("ATMOST")) {
                                    refValSoft = "Maxproc SoftLimit Value ATMOST " + oRefHost.getMaxproc().getSoftMaxProc();
                                }
                                OipcrIResult oRes = softmaxprocVal == 1 ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                                if (oRefHost.getMaxproc().getSoftMaxProc() != null) {
                                    oResDetails.add(new OipcrResultDetails((Object)actualSoftVal, (Object)refValSoft, oRes));
                                }
                                oRes = hardmaxprocVal == 1 ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                                if (oRefHost.getMaxproc().getHardMaxProc() != null) {
                                    oResDetails.add(new OipcrResultDetails((Object)actualValHard, (Object)refValhard, oRes));
                                }
                                actualSoftVal = null;
                                actualValHard = null;
                                refValhard = null;
                                refValSoft = null;
                                int softDescriptorVal = oActualHost.getDescriptor().softCompare(oRefHost);
                                int hardDescriptorVal = oActualHost.getDescriptor().hardCompare(oRefHost);
                                actualSoftVal = "Descriptor SoftLimit Value " + oActualHost.getDescriptor().getSoftDescriptor();
                                refValSoft = "Descriptor SoftLimit Value " + oRefHost.getDescriptor().getSoftDescriptor();
                                actualValHard = "Descriptor HardLimit Value " + oActualHost.getDescriptor().getHardDescriptor();
                                refValhard = "Descriptor HardLimit Value " + oRefHost.getDescriptor().getHardDescriptor();
                                if (oRefHost.getDescriptor().getHardOperatorDescriptor() != null && oRefHost.getDescriptor().getHardOperatorDescriptor().equalsIgnoreCase("ATLEAST")) {
                                    refValhard = "Descriptor HardLimit Value " + oRefHost.getDescriptor().getHardDescriptor();
                                } else if (oRefHost.getDescriptor().getHardOperatorDescriptor() != null && oRefHost.getDescriptor().getHardOperatorDescriptor().equalsIgnoreCase("ATMOST")) {
                                    refValhard = "Descriptor HardLimit Value ATMOST " + oRefHost.getDescriptor().getHardDescriptor();
                                }
                                if (oRefHost.getDescriptor().getSoftOperatorDescriptor() != null && oRefHost.getDescriptor().getSoftOperatorDescriptor().equalsIgnoreCase("ATLEAST")) {
                                    refValSoft = "Descriptor SoftLimit Value " + oRefHost.getDescriptor().getSoftDescriptor();
                                } else if (oRefHost.getDescriptor().getSoftOperatorDescriptor() != null && oRefHost.getDescriptor().getSoftOperatorDescriptor().equalsIgnoreCase("ATMOST")) {
                                    refValSoft = "Descriptor SoftLimit Value ATMOST " + oRefHost.getDescriptor().getSoftDescriptor();
                                }
                                oRes = softDescriptorVal == 1 ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                                if (oRefHost.getDescriptor().getSoftDescriptor() != null) {
                                    oResDetails.add(new OipcrResultDetails((Object)actualSoftVal, (Object)refValSoft, oRes));
                                }
                                oRes = hardDescriptorVal == 1 ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                                if (oRefHost.getDescriptor().getHardDescriptor() != null) {
                                    oResDetails.add(new OipcrResultDetails((Object)actualValHard, (Object)refValhard, oRes));
                                }
                                actualSoftVal = null;
                                actualValHard = null;
                                refValhard = null;
                                refValSoft = null;
                                int softStackVal = oActualHost.getStack().softCompare(oRefHost);
                                int hardStackVal = oActualHost.getStack().hardCompare(oRefHost);
                                actualSoftVal = oActualHost.getStack().getSoftStack().equalsIgnoreCase(S_UNLIMITED) ? "Stack SoftLimit Value " + oActualHost.getStack().getSoftStack() : "Stack SoftLimit Value " + oActualHost.getStack().getSoftStack() + " " + oActualHost.getStack().getSoftUnitStack();
                                if (oRefHost.getStack().getSoftOperatorStack() != null && oRefHost.getStack().getSoftOperatorStack().equalsIgnoreCase("ATLEAST")) {
                                    refValSoft = "Stack SoftLimit Value " + oRefHost.getStack().getSoftStack() + " " + oRefHost.getStack().getSoftUnitStack();
                                } else if (oRefHost.getStack().getSoftOperatorStack() != null && oRefHost.getStack().getSoftOperatorStack().equalsIgnoreCase("ATMOST")) {
                                    refValSoft = "Stack SoftLimit Value ATMOST " + oRefHost.getStack().getSoftStack() + " " + oRefHost.getStack().getSoftUnitStack();
                                }
                                oRes = softStackVal == 1 ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                                if (oRefHost.getStack().getSoftStack() != null) {
                                    oResDetails.add(new OipcrResultDetails((Object)actualSoftVal, (Object)refValSoft, oRes));
                                }
                                actualValHard = oActualHost.getStack().getHardStack().equalsIgnoreCase(S_UNLIMITED) ? "Stack HardLimit Value " + oActualHost.getStack().getHardStack() : "Stack HardLimit Value " + oActualHost.getStack().getHardStack() + " " + oActualHost.getStack().getHardUnitStack();
                                if (oRefHost.getStack().getHardOperatorStack() != null && oRefHost.getStack().getHardOperatorStack().equalsIgnoreCase("ATLEAST")) {
                                    refValhard = "Stack HardLimit Value " + oRefHost.getStack().getHardStack() + " " + oRefHost.getStack().getHardUnitStack();
                                } else if (oRefHost.getStack().getHardOperatorStack() != null && oRefHost.getStack().getHardOperatorStack().equalsIgnoreCase("ATMOST")) {
                                    refValhard = "Stack HardLimit Value ATMOST " + oRefHost.getStack().getHardStack() + " " + oRefHost.getStack().getHardUnitStack();
                                }
                                oRes = hardStackVal == 1 ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                                if (oRefHost.getStack().getHardStack() != null) {
                                    oResDetails.add(new OipcrResultDetails((Object)actualValHard, (Object)refValhard, oRes));
                                }
                                oResult = new OipcrResult(oResDetails);
                            } else {
                                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("S_CHECK_SHELL_LIMIT_PARAMETERS", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"S_CHECK_SHELL_LIMIT_PARAMETERS")));
                            }
                        } else {
                            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("S_CHECK_SHELL_LIMIT_PARAMETERS", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"S_CHECK_SHELL_LIMIT_PARAMETERS")));
                        }
                        break block40;
                    }
                    oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("S_CHECK_SHELL_LIMIT_PARAMETERS", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"S_CHECK_SHELL_LIMIT_PARAMETERS")));
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    private static OipchShell addShellLimitDetails(String Shell, Node oSLNode) throws OixdInvalidDocumentException {
        OipchShell oShellObj = new OipchShell(Shell);
        boolean FoundShellFLAG = false;
        if (oSLNode != null) {
            NodeList oSHDetails = oSLNode.getChildNodes();
            boolean noChoiceTagFlag = false;
            if (oSHDetails != null) {
                int nSHDetails = oSHDetails.getLength();
                Node oSLDetailNode = null;
                Object oAttrib = null;
                Object oNodeAttribs = null;
                for (int nNode = 0; nNode < nSHDetails; ++nNode) {
                    oSLDetailNode = oSHDetails.item(nNode);
                    if (oSLDetailNode.getNodeName().equalsIgnoreCase("CHOICE")) {
                        noChoiceTagFlag = false;
                        break;
                    }
                    if (oSLDetailNode == null || oSLDetailNode.getNodeName() == null || !oSLDetailNode.getNodeName().equalsIgnoreCase("FILE_DESCRIPTORS") && !oSLDetailNode.getNodeName().equalsIgnoreCase("MAXPROC") && !oSLDetailNode.getNodeName().equalsIgnoreCase("STACK")) continue;
                    noChoiceTagFlag = true;
                    break;
                }
                if (!noChoiceTagFlag) {
                    NodeList selectionNodes = oSLDetailNode.getChildNodes();
                    int nSelectionNode = selectionNodes.getLength();
                    for (int j = 0; j < nSelectionNode; ++j) {
                        NamedNodeMap nselectionNodeMap;
                        Node selectionNode = selectionNodes.item(j);
                        if (selectionNode == null || (nselectionNodeMap = selectionNode.getAttributes()) == null) continue;
                        String shellFromRefHost = selectionNode.getAttributes().getNamedItem("VALUE").getNodeValue();
                        if (shellFromRefHost.startsWith("/bin/")) {
                            shellFromRefHost = OipczShellLimitChecks.getCommonShellName(shellFromRefHost);
                        }
                        if (!(shellFromRefHost = shellFromRefHost.toLowerCase()).equalsIgnoreCase(Shell)) continue;
                        OipczShellLimitChecks.addShellLimitInfo(oShellObj, selectionNode);
                        FoundShellFLAG = true;
                        break;
                    }
                } else {
                    OipczShellLimitChecks.addShellLimitInfo(oShellObj, oSLNode);
                }
            }
        }
        if (FoundShellFLAG) {
            return oShellObj;
        }
        oShellObj = null;
        return oShellObj;
    }

    private static void addShellLimitInfo(OipchShell oShellLimit, Node oShellLimitNode) throws OixdInvalidDocumentException {
        OipchDescriptor oDes = new OipchDescriptor();
        OipchMaxproc oMax = new OipchMaxproc();
        OipchStack oStk = new OipchStack();
        if (oShellLimitNode != null) {
            NodeList childNodes = oShellLimitNode.getChildNodes();
            int nChildNodes = childNodes.getLength();
            for (int k = 0; k < nChildNodes; ++k) {
                int m;
                Node nodeUnderShellLimit = childNodes.item(k);
                if (nodeUnderShellLimit.getNodeType() == 1 && nodeUnderShellLimit.getNodeName().equalsIgnoreCase("FILE_DESCRIPTORS")) {
                    NodeList file_Descriptor_Child = nodeUnderShellLimit.getChildNodes();
                    int nfile_Descriptor_Child = file_Descriptor_Child.getLength();
                    for (m = 0; m < nfile_Descriptor_Child; ++m) {
                        Node childOfDescriptos = file_Descriptor_Child.item(m);
                        if (childOfDescriptos == null) continue;
                        if (childOfDescriptos.getNodeType() == 1 && childOfDescriptos.getNodeName().equalsIgnoreCase("HARDLIMIT")) {
                            String hardLimitFileDescriptor = childOfDescriptos.getAttributes().getNamedItem("VALUE").getNodeValue();
                            if (hardLimitFileDescriptor != null) {
                                oDes.setHardDescriptor(hardLimitFileDescriptor);
                            }
                            String hardOperator = null;
                            if (childOfDescriptos.getAttributes().getNamedItem("OPERATOR") != null) {
                                hardOperator = childOfDescriptos.getAttributes().getNamedItem("OPERATOR").getNodeValue();
                            }
                            if (hardOperator != null) {
                                oDes.setHardOperatorDescriptor(hardOperator);
                                continue;
                            }
                            oDes.setHardOperatorDescriptor("ATLEAST");
                            continue;
                        }
                        if (childOfDescriptos.getNodeType() != 1 || !childOfDescriptos.getNodeName().equalsIgnoreCase("SOFTLIMIT")) continue;
                        String softLimitFileDescriptor = childOfDescriptos.getAttributes().getNamedItem("VALUE").getNodeValue();
                        if (softLimitFileDescriptor != null) {
                            oDes.setSoftDescriptor(softLimitFileDescriptor);
                        }
                        String softOperator = null;
                        if (childOfDescriptos.getAttributes().getNamedItem("OPERATOR") != null) {
                            softOperator = childOfDescriptos.getAttributes().getNamedItem("OPERATOR").getNodeValue();
                        }
                        if (softOperator != null) {
                            oDes.setSoftOperatorDescriptor(softOperator);
                            continue;
                        }
                        oDes.setSoftOperatorDescriptor("ATLEAST");
                    }
                    continue;
                }
                if (nodeUnderShellLimit.getNodeType() == 1 && nodeUnderShellLimit.getNodeName().equalsIgnoreCase("MAXPROC")) {
                    NodeList maxproc_Child = nodeUnderShellLimit.getChildNodes();
                    int nmaxproc_Child = maxproc_Child.getLength();
                    for (m = 0; m < nmaxproc_Child; ++m) {
                        Node childOfMaxproc = maxproc_Child.item(m);
                        if (childOfMaxproc.getNodeType() == 1 && childOfMaxproc.getNodeName().equalsIgnoreCase("HARDLIMIT")) {
                            String hardLimitMaxproc = childOfMaxproc.getAttributes().getNamedItem("VALUE").getNodeValue();
                            if (hardLimitMaxproc != null) {
                                oMax.setHardMaxProc(hardLimitMaxproc);
                            }
                            String hardOperator1 = null;
                            if (childOfMaxproc.getAttributes().getNamedItem("OPERATOR") != null) {
                                hardOperator1 = childOfMaxproc.getAttributes().getNamedItem("OPERATOR").getNodeValue();
                            }
                            if (hardOperator1 != null) {
                                oMax.setHardOperatorMaxproc(hardOperator1);
                                continue;
                            }
                            oMax.setHardOperatorMaxproc("ATLEAST");
                            continue;
                        }
                        if (childOfMaxproc.getNodeType() != 1 || !childOfMaxproc.getNodeName().equalsIgnoreCase("SOFTLIMIT")) continue;
                        String softLimitMaxproc = childOfMaxproc.getAttributes().getNamedItem("VALUE").getNodeValue();
                        if (softLimitMaxproc != null) {
                            oMax.setSoftMaxProc(softLimitMaxproc);
                        }
                        String softOperator1 = null;
                        if (childOfMaxproc.getAttributes().getNamedItem("OPERATOR") != null) {
                            softOperator1 = childOfMaxproc.getAttributes().getNamedItem("OPERATOR").getNodeValue();
                        }
                        if (softOperator1 != null) {
                            oMax.setSoftOperatorMaxproc(softOperator1);
                            continue;
                        }
                        oMax.setSoftOperatorMaxproc("ATLEAST");
                    }
                    continue;
                }
                if (nodeUnderShellLimit.getNodeType() != 1 || !nodeUnderShellLimit.getNodeName().equalsIgnoreCase("STACK")) continue;
                NodeList stack_Child = nodeUnderShellLimit.getChildNodes();
                int nstack_Child = stack_Child.getLength();
                for (m = 0; m < nstack_Child; ++m) {
                    Node childOfStack = stack_Child.item(m);
                    if (childOfStack.getNodeType() == 1 && childOfStack.getNodeName().equalsIgnoreCase("SOFTLIMIT")) {
                        String softLimitStack = null;
                        String softUnit = null;
                        String softOperator = null;
                        if (childOfStack.getAttributes().getNamedItem("VALUE") != null) {
                            softLimitStack = childOfStack.getAttributes().getNamedItem("VALUE").getNodeValue();
                        }
                        if (childOfStack.getAttributes().getNamedItem("UNIT") != null) {
                            softUnit = childOfStack.getAttributes().getNamedItem("UNIT").getNodeValue();
                        }
                        softOperator = childOfStack.getAttributes().getNamedItem("OPERATOR") != null ? childOfStack.getAttributes().getNamedItem("OPERATOR").getNodeValue() : "ATLEAST";
                        if (softLimitStack != null) {
                            oStk.setSoftStack(softLimitStack);
                        }
                        if (softUnit != null) {
                            oStk.setSoftUnitStack(softUnit);
                        }
                        if (softOperator == null) continue;
                        oStk.setSoftOperatorStack(softOperator);
                        continue;
                    }
                    if (childOfStack.getNodeType() != 1 || !childOfStack.getNodeName().equalsIgnoreCase("HARDLIMIT")) continue;
                    String hardLimitStack = null;
                    String hardUnit = null;
                    String hardOperator = null;
                    if (childOfStack.getAttributes().getNamedItem("VALUE") != null) {
                        hardLimitStack = childOfStack.getAttributes().getNamedItem("VALUE").getNodeValue();
                    }
                    if (childOfStack.getAttributes().getNamedItem("UNIT") != null) {
                        hardUnit = childOfStack.getAttributes().getNamedItem("UNIT").getNodeValue();
                    }
                    hardOperator = childOfStack.getAttributes().getNamedItem("OPERATOR") != null ? childOfStack.getAttributes().getNamedItem("OPERATOR").getNodeValue() : "ATLEAST";
                    if (hardLimitStack != null) {
                        oStk.setHardStack(hardLimitStack);
                    }
                    if (hardUnit != null) {
                        oStk.setHardUnitStack(hardUnit);
                    }
                    if (hardOperator == null) continue;
                    oStk.setHardOperatorStack(hardOperator);
                }
            }
        }
        oShellLimit.setStack(oStk);
        oShellLimit.setDescriptor(oDes);
        oShellLimit.setMaxproc(oMax);
    }

    private static String getCommonShellName(String shellName) {
        String tempShell = "";
        int strlength = shellName.length();
        int lastindexofseparator = shellName.lastIndexOf("/");
        tempShell = shellName.substring(++lastindexofseparator, strlength);
        shellName = tempShell.toLowerCase();
        shellName = tempShell.trim();
        return shellName;
    }

    private static String getShellNameAsEnviron(String shellName) {
        String tempShell = "";
        tempShell = shellName;
        shellName = "/bin/";
        shellName.concat(tempShell);
        return shellName;
    }
}

