/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.util.ArrayList;
import java.util.Map;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchDevice;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipch.OipchUnixDevice;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ASMInputChecks {
    private ASMInputChecks() {
    }

    public static OipcrIResult checkASMRedundancy(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block10: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    String sValue = ASMInputChecks.getStringRefInfo(oRulesEngine, sRefFile, "REDUNDANCY_TYPE");
                    String[] asmDisks = ASMInputChecks.getStringArrayRefInfo(oRulesEngine, sRefFile, "ASM_DISKS");
                    Integer oInt = new Integer(sValue);
                    int noOfDisks = asmDisks.length;
                    if (noOfDisks >= oInt) {
                        oResult = OipcrResult.PASSED_RESULT;
                        break block10;
                    }
                    oResult = OipcrResult.FAILED_RESULT;
                }
                catch (NumberFormatException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException((Throwable)e));
                }
                catch (OipcrExecuteRuleException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getStringRefInfo(OipcrIRulesEngine oRulesEngine, String sRefFile, String sTag) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        String sValue = null;
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oNode = oGenRefHost.getNode("ASM_INPUTS/" + sTag);
        if (oNode != null) {
            Object oHomeNode = null;
            NamedNodeMap oNodeAttribs = null;
            Node oAttrib = null;
            oNodeAttribs = oNode.getAttributes();
            if (oNodeAttribs != null) {
                oAttrib = oNodeAttribs.getNamedItem("VAR");
                String sVar = null;
                if (oAttrib == null) {
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_VAR_FOR_TAG", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_TAG", (Object[])args));
                }
                sVar = oAttrib.getNodeValue();
                OiisVariable oVar = oContext.getVariable(sVar);
                if (oVar == null) return sValue;
                return (String)oVar.getValue();
            }
            Object[] args = new String[]{sRefFile, sTag};
            throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_TAG", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_TAG", (Object[])args));
        }
        Object[] args = new String[]{sRefFile, sTag};
        throw new OipcrExecuteRuleException("S_NO_TAG_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_TAG_INFO", (Object[])args));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] getStringArrayRefInfo(OipcrIRulesEngine oRulesEngine, String sRefFile, String sTag) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        String[] sValue = null;
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oNode = oGenRefHost.getNode("ASM_INPUTS/" + sTag);
        if (oNode != null) {
            Object oHomeNode = null;
            NamedNodeMap oNodeAttribs = null;
            Node oAttrib = null;
            oNodeAttribs = oNode.getAttributes();
            if (oNodeAttribs != null) {
                oAttrib = oNodeAttribs.getNamedItem("VAR");
                String sVar = null;
                if (oAttrib == null) {
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_VAR_FOR_TAG", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_TAG", (Object[])args));
                }
                sVar = oAttrib.getNodeValue();
                OiisVariable oVar = oContext.getVariable(sVar);
                if (oVar == null) return sValue;
                return (String[])oVar.getValue();
            }
            Object[] args = new String[]{sRefFile, sTag};
            throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_TAG", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_TAG", (Object[])args));
        }
        Object[] args = new String[]{sRefFile, sTag};
        throw new OipcrExecuteRuleException("S_NO_TAG_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_TAG_INFO", (Object[])args));
    }

    public static OipcrIResult checkASMDisksSize(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine != null) {
            try {
                String sValue = ASMInputChecks.getStringRefInfo(oRulesEngine, sRefFile, "TOTAL_ASM_SIZE");
                Long oRefValue = new Long(sValue);
                long refSize = oRefValue;
                String[] asmDisks = ASMInputChecks.getStringArrayRefInfo(oRulesEngine, sRefFile, "ASM_DISKS");
                OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                OipchSystem oSystem = oHost.getSystem();
                Map oDeviceDetails = oSystem.getDeviceDetails();
                int noOfDisks = asmDisks.length;
                long actSize = 0L;
                for (int i = 0; i < noOfDisks; ++i) {
                    Long oMem;
                    String sCurDeviceName = asmDisks[i];
                    OipchDevice oHostDev = (OipchDevice)oDeviceDetails.get(sCurDeviceName);
                    if (oHostDev == null || (oMem = oHostDev.getAvailMem()) == null) continue;
                    long lMem = oMem / 1024L;
                    actSize += lMem;
                }
                Long oActValue = new Long(actSize);
                OipcrIResult oRes = OipcrResult.FAILED_RESULT;
                oRes = actSize > refSize ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                oResDetails.add(new OipcrResultDetails((Object)oActValue, (Object)oRefValue, oRes));
                oResult = new OipcrResult(oResDetails);
            }
            catch (NumberFormatException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException((Throwable)e));
            }
            catch (OipcrExecuteRuleException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkASMDisksValidity(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine != null) {
            try {
                String[] asmDisks = ASMInputChecks.getStringArrayRefInfo(oRulesEngine, sRefFile, "ASM_DISKS");
                OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                OipchSystem oSystem = oHost.getSystem();
                Map oDeviceDetails = oSystem.getDeviceDetails();
                int noOfDisks = asmDisks.length;
                long actSize = 0L;
                ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                for (int i = 0; i < noOfDisks; ++i) {
                    OipcrIResult oRes = OipcrResult.FAILED_RESULT;
                    String sCurDeviceName = asmDisks[i];
                    OipchUnixDevice oHostDev = (OipchUnixDevice)oDeviceDetails.get(sCurDeviceName);
                    if (oHostDev != null && oHostDev.isASMCandidate()) {
                        oRes = OipcrResult.PASSED_RESULT;
                    }
                    oResDetails.add(new OipcrResultDetails(null, (Object)sCurDeviceName, oRes));
                }
                oResult = new OipcrResult(oResDetails);
            }
            catch (OipcrExecuteRuleException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }
}

