/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.util.ArrayList;
import java.util.List;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oip.oipc.oipch.OipchClusterDetails;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.prov.prereqs.NetworkChecks;

public class ClusterChecks {
    private ClusterChecks() {
    }

    public static OipcrIResult areNodesInCluster(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block13: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    OipchSystem oSystem = oHost.getSystem();
                    OipchClusterDetails oClusterDetails = oSystem.getClusterDetails();
                    List oNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile);
                    String[] oNodesArray = OiixVectorOps.list2StrArr((List)oNodesList);
                    if (oNodesArray == null || oNodesArray.length == 0) break block13;
                    int iSize = oNodesArray.length;
                    if (oClusterDetails != null) {
                        String[] clusterNodes = oClusterDetails.getNodes();
                        if (clusterNodes != null && clusterNodes.length >= iSize) {
                            ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                            for (int j = 0; j < iSize; ++j) {
                                String sCurExpNode = oNodesArray[j];
                                OipcrIResult oRes = OipcrResult.FAILED_RESULT;
                                boolean bCurrentFound = false;
                                for (int k = 0; k < clusterNodes.length; ++k) {
                                    if (!sCurExpNode.equals(clusterNodes[k])) continue;
                                    oRes = OipcrResult.PASSED_RESULT;
                                }
                                oResDetails.add(new OipcrResultDetails(null, (Object)sCurExpNode, oRes));
                            }
                            oResult = new OipcrResult(oResDetails);
                        } else {
                            oResult = OipcrResult.FAILED_RESULT;
                        }
                        break block13;
                    }
                    throw new OipcrExecuteRuleException("S_NO_HOST_CLUSTER_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_HOST_CLUSTER_INFO"));
                }
                catch (OipcrExecuteRuleException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }
}

