/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.util.ArrayList;
import java.util.List;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.prov.prereqs.NetworkChecks;
import oracle.sysman.prov.prereqs.RefCheckDir;
import oracle.sysman.prov.remoteinterfaces.clusterops.ClusterFileOps;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteFileOperationException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteShellFatalException;
import oracle.sysman.prov.remoteinterfaces.result.ClusterResult;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DirChecks {
    private DirChecks() {
    }

    public static OipcrIResult areDirWritableOnNodes(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block19: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    ArrayList oLocationsList = new ArrayList();
                    DirChecks.parseXMLToPrepareCheck(oRulesEngine, sRefFile, oLocationsList);
                    String sUsername = null;
                    if (oLocationsList == null || oLocationsList.size() <= 0) break block19;
                    sUsername = NetworkChecks.getUserName(oRulesEngine, sRefFile);
                    List oClusterNodes = NetworkChecks.getNodeNames(oRulesEngine, sRefFile);
                    String[] oNodesArray = OiixVectorOps.list2StrArr((List)oClusterNodes);
                    if (oNodesArray == null || oNodesArray.length == 0) break block19;
                    ClusterFileOps oClusterOps = null;
                    try {
                        oClusterOps = new ClusterFileOps();
                    }
                    catch (FatalException e) {
                        oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                    }
                    if (oClusterOps == null) break block19;
                    oClusterOps.startup(oNodesArray, sUsername, "");
                    ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                    for (int i = 0; i < oLocationsList.size(); ++i) {
                        RefCheckDir oRefLoc = (RefCheckDir)oLocationsList.get(i);
                        String sLoc = oRefLoc.getLoc();
                        boolean bType = oRefLoc.getType();
                        for (int j = 0; j < oNodesArray.length; ++j) {
                            OipcrIResult oRes = null;
                            boolean bWritable = false;
                            String sExpected = null;
                            try {
                                ClusterResult oClusterRes = oClusterOps.isDirWritable(oNodesArray[j], sLoc);
                                if (((Boolean)oClusterRes.getResultOnNode(oNodesArray[j]).getResult()).booleanValue()) {
                                    // empty if block
                                }
                                bWritable = true;
                            }
                            catch (FatalException e) {
                                throw e;
                            }
                            catch (RemoteFileOperationException e) {
                                bWritable = false;
                            }
                            oRes = !(bWritable ^ bType) ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                            sExpected = null;
                            Object[] args = new String[]{sLoc, oNodesArray[j]};
                            sExpected = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_DIR_WRITABLE_ON", (Object[])args);
                            oResDetails.add(new OipcrResultDetails(null, (Object)sExpected, oRes));
                        }
                    }
                    oResult = new OipcrResult(oResDetails);
                }
                catch (ClusterException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (RemoteShellFatalException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (FatalException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipcrExecuteRuleException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    private static void parseXMLToPrepareCheck(OipcrIRulesEngine oRulesEngine, String sRefFile, List oLocationsList) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oLocationsNode = oGenRefHost.getNode("DIRS");
        if (oLocationsNode != null) {
            NodeList oNodes = oLocationsNode.getChildNodes();
            if (oNodes != null) {
                int iNodes = oNodes.getLength();
                Node oNode = null;
                NamedNodeMap oNodeAttribs = null;
                Node oAttrib = null;
                for (int i = 0; i < iNodes; ++i) {
                    oNode = oNodes.item(i);
                    if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("DIR")) continue;
                    oNodeAttribs = oNode.getAttributes();
                    if (oNodeAttribs != null) {
                        String sLoc;
                        String sNodeVal;
                        boolean bType = true;
                        oAttrib = oNodeAttribs.getNamedItem("WRITABLE");
                        if (oAttrib != null && (sNodeVal = oAttrib.getNodeValue()) != null && sNodeVal.equalsIgnoreCase("FALSE")) {
                            bType = false;
                        }
                        oAttrib = oNodeAttribs.getNamedItem("VAR");
                        String sLocVar = null;
                        if (oAttrib == null) {
                            Object[] args = new String[]{sRefFile};
                            throw new OipcrExecuteRuleException("S_NO_VAR_FOR_DIR_UNDER_DIRS", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_DIR_UNDER_DIRS", (Object[])args));
                        }
                        sLocVar = oAttrib.getNodeValue();
                        OiisVariable oVar = oContext.getVariable(sLocVar);
                        if (oVar == null || (sLoc = (String)oVar.getValue()) == null) continue;
                        RefCheckDir oRcl = new RefCheckDir(sLoc, bType);
                        oLocationsList.add(oRcl);
                        continue;
                    }
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_DIR_UNDER_DIRS", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_DIR_UNDER_DIRS", (Object[])args));
                }
            }
        } else {
            Object[] args = new String[]{sRefFile};
            throw new OipcrExecuteRuleException("S_NO_DIRS_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_DIRS_INFO", (Object[])args));
        }
    }
}

